/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.repo.cache.RefreshableCacheEvent;
import org.alfresco.repo.cache.RefreshableCacheListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAsynchronouslyRefreshedCacheRegistry
implements AsynchronouslyRefreshedCacheRegistry {
    private static Log logger = LogFactory.getLog(DefaultAsynchronouslyRefreshedCacheRegistry.class);
    private List<RefreshableCacheListener> listeners = new LinkedList<RefreshableCacheListener>();

    @Override
    public void register(RefreshableCacheListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Listener added for " + listener.getCacheId()));
        }
        this.listeners.add(listener);
    }

    @Override
    public void broadcastEvent(RefreshableCacheEvent event, boolean toAll) {
        for (RefreshableCacheListener listener : this.listeners) {
            if (toAll) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Delivering event (" + event + ") to listener (" + listener + ")."));
                }
                listener.onRefreshableCacheEvent(event);
                continue;
            }
            if (!listener.getCacheId().equals(event.getCacheId())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delivering event (" + event + ") to listener (" + listener + ")."));
            }
            listener.onRefreshableCacheEvent(event);
        }
    }
}

