/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.LockingCache;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class TransactionalCache<K extends Serializable, V>
implements LockingCache<K, V>,
TransactionListener,
InitializingBean {
    private static final String RESOURCE_KEY_TXN_DATA = "TransactionalCache.TxnData";
    private Log logger = LogFactory.getLog(TransactionalCache.class);
    private boolean isDebugEnabled = this.logger.isDebugEnabled();
    private String name;
    private boolean disableSharedCache = false;
    private SimpleCache<Serializable, Object> sharedCache;
    private boolean isMutable = true;
    private boolean allowEqualsChecks = false;
    private int maxCacheSize = 500;
    private String resourceKeyTxnData;
    private boolean isTenantAware = true;

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionalCache)) {
            return false;
        }
        TransactionalCache that = (TransactionalCache)obj;
        return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSharedCache(SimpleCache<Serializable, Object> sharedCache) {
        this.sharedCache = sharedCache;
    }

    public void setDisableSharedCache(boolean disableSharedCache) {
        this.disableSharedCache = disableSharedCache;
    }

    public void setMutable(boolean isMutable) {
        this.isMutable = isMutable;
    }

    public void setAllowEqualsChecks(boolean allowEqualsChecks) {
        this.allowEqualsChecks = allowEqualsChecks;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTenantAware(boolean isTenantAware) {
        this.isTenantAware = isTenantAware;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"name", (Object)this.name);
        PropertyCheck.mandatory((Object)this, (String)"sharedCache", this.sharedCache);
        this.resourceKeyTxnData = "TransactionalCache.TxnData." + this.name;
        this.logger = LogFactory.getLog((String)(TransactionalCache.class.getName() + "." + this.name));
        this.isDebugEnabled = this.logger.isDebugEnabled();
        if (this.disableSharedCache) {
            this.sharedCache = NullCache.getInstance();
        }
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)AlfrescoTransactionSupport.getResource(this.resourceKeyTxnData);
        if (data == null) {
            data = new TransactionData();
            data.updatedItemsCache = new LRULinkedHashMap(23);
            data.removedItemsCache = new HashSet(13);
            data.lockedItemsCache = new HashSet(13);
            data.isReadOnly = AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
            AlfrescoTransactionSupport.bindListener(this);
            AlfrescoTransactionSupport.bindResource(this.resourceKeyTxnData, data);
        }
        return data;
    }

    public boolean getDisableSharedCacheReadForTransaction() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData = this.getTransactionData();
            return txnData.noSharedCacheRead;
        }
        return false;
    }

    public void setDisableSharedCacheReadForTransaction(boolean noSharedCacheRead) {
        TransactionData txnData = this.getTransactionData();
        if (noSharedCacheRead && !txnData.noSharedCacheRead) {
            txnData.noSharedCacheRead = noSharedCacheRead;
            String currentCacheRegion = TenantUtil.getCurrentDomain();
            for (Map.Entry entry : new ArrayList(txnData.updatedItemsCache.entrySet())) {
                Serializable cacheKey = (Serializable)entry.getKey();
                Serializable key = null;
                if (cacheKey instanceof CacheRegionKey) {
                    CacheRegionKey cacheRegionKey = (CacheRegionKey)cacheKey;
                    if (currentCacheRegion.equals(cacheRegionKey.getCacheRegion())) {
                        key = cacheRegionKey.getCacheKey();
                    }
                } else {
                    key = cacheKey;
                }
                if (key == null) continue;
                CacheBucket bucket = (CacheBucket)entry.getValue();
                if (bucket instanceof ReadCacheBucket) {
                    txnData.updatedItemsCache.remove(cacheKey);
                    continue;
                }
                if (!(bucket instanceof UpdateCacheBucket)) continue;
                this.remove(key);
            }
        }
    }

    public boolean contains(K key) {
        V value = this.get(key);
        return value != null;
    }

    public Collection<K> getKeys() {
        HashSet<Object> keys = null;
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            keys = new HashSet<Object>(23);
            TransactionData txnData = this.getTransactionData();
            if (!txnData.isClearOn) {
                Collection backingKeys = this.sharedCache.getKeys();
                HashSet<Serializable> backingCacheKeys = new HashSet<Serializable>(backingKeys.size());
                for (Serializable backingKey : backingKeys) {
                    backingCacheKeys.add(this.getTenantAwareCacheKey(backingKey));
                }
                keys.addAll(backingCacheKeys);
            }
            keys.addAll(txnData.updatedItemsCache.keySet());
            keys.removeAll(txnData.removedItemsCache);
        } else {
            keys = this.sharedCache.getKeys();
        }
        HashSet<Serializable> cacheKeys = new HashSet<Serializable>(keys.size());
        String currentCacheRegion = TenantUtil.getCurrentDomain();
        for (Serializable serializable : keys) {
            if (serializable instanceof CacheRegionKey) {
                CacheRegionKey cacheRegionKey = (CacheRegionKey)serializable;
                if (!currentCacheRegion.equals(cacheRegionKey.getCacheRegion())) continue;
                cacheKeys.add(cacheRegionKey.getCacheKey());
                continue;
            }
            cacheKeys.add(serializable);
        }
        return cacheKeys;
    }

    private V getSharedCacheValue(Serializable key) {
        return (V)this.sharedCache.get(key);
    }

    private final boolean isValueLocked(TransactionData txnData, Serializable key) {
        return txnData.lockedItemsCache.size() > 0 && txnData.lockedItemsCache.contains(key);
    }

    public boolean isValueLocked(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            return txnData.lockedItemsCache.contains(key);
        }
        return false;
    }

    public void lockValue(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            txnData.lockedItemsCache.add(key);
            return;
        }
    }

    public void unlockValue(K keyIn) {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            Serializable key = this.getTenantAwareCacheKey(keyIn);
            TransactionData txnData = this.getTransactionData();
            txnData.lockedItemsCache.remove(key);
            return;
        }
    }

    public V get(K keyIn) {
        TransactionData txnData;
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        boolean ignoreSharedCache = false;
        if (AlfrescoTransactionSupport.getTransactionId() != null && !(txnData = this.getTransactionData()).isClosed) {
            if (!txnData.isClearOn && txnData.removedItemsCache.contains(key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("get returning null - item has been removed from transactional cache: \n   cache: " + this + "\n" + "   key: " + key));
                }
                return null;
            }
            ReadCacheBucket<V> bucket = (ReadCacheBucket<V>)txnData.updatedItemsCache.get(key);
            if (bucket != null) {
                Object value = bucket.getValue();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Found item in transactional cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
                return (V)value;
            }
            if (txnData.isClearOn) {
                ignoreSharedCache = true;
            } else if (txnData.noSharedCacheRead) {
                ignoreSharedCache = true;
            } else {
                V value = this.getSharedCacheValue(key);
                bucket = new ReadCacheBucket<V>(value);
                txnData.updatedItemsCache.put(key, bucket);
                return value;
            }
        }
        if (!ignoreSharedCache) {
            V value = this.getSharedCacheValue(key);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No value found in transaction - fetching instance from shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
            return value;
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("No value found in transaction and ignoring shared cache: \n   cache: " + this + "\n" + "   key: " + key));
        }
        return null;
    }

    public void put(K keyIn, V value) {
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.put(key, value);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - adding item direct to shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit add: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            } else if (this.isValueLocked(txnData, key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Ignoring put after detecting locked key: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            } else {
                if (txnData.updatedItemsCache.hasHitSize()) {
                    txnData.isClearOn = true;
                    if (!txnData.haveIssuedFullWarning && this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Transactional update cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                        txnData.haveIssuedFullWarning = true;
                    }
                }
                Object existingValueObj = txnData.noSharedCacheRead ? null : this.sharedCache.get(key);
                CacheBucket<Object> bucket = null;
                bucket = existingValueObj == null ? new NewCacheBucket<V>(value) : new UpdateCacheBucket<Object>(existingValueObj, value);
                txnData.updatedItemsCache.put(key, bucket);
                txnData.removedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional update cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            }
        }
    }

    public void remove(K keyIn) {
        Serializable key = this.getTenantAwareCacheKey(keyIn);
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.remove(key);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - removing item from shared cache: \n   cache: " + this + "\n" + "   key: " + key));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit remove: \n   cache: " + this + "\n" + "   key: " + key));
                }
            } else if (this.isValueLocked(txnData, key)) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Ignoring remove after detecting locked key: \n   cache: " + this + "\n" + "   key: " + key));
                }
            } else {
                if (!txnData.isClearOn) {
                    if (txnData.removedItemsCache.size() >= this.maxCacheSize) {
                        txnData.isClearOn = true;
                        if (!txnData.haveIssuedFullWarning && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Transactional removal cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                            txnData.haveIssuedFullWarning = true;
                        }
                    } else {
                        txnData.removedItemsCache.add(key);
                    }
                }
                txnData.updatedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional removed cache: \n   cache: " + this + "\n" + "   key: " + key));
                }
            }
        }
    }

    public void clear() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData;
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("In transaction clearing cache: \n   cache: " + this + "\n" + "   txn: " + AlfrescoTransactionSupport.getTransactionId()));
            }
            if ((txnData = this.getTransactionData()).isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit clear: \n   cache: " + this));
                }
            } else {
                txnData.isClearOn = true;
                txnData.updatedItemsCache.clear();
                txnData.removedItemsCache.clear();
            }
        } else {
            if (this.isDebugEnabled) {
                this.logger.debug((Object)"No transaction - clearing shared cache");
            }
            this.sharedCache.clear();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)"Processing before-commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)"Clear notification recieved in commit - clearing shared cache");
                }
            } else {
                for (Serializable key : txnData.removedItemsCache) {
                    this.sharedCache.remove(key);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in commit"));
                }
            }
            Set keys = txnData.updatedItemsCache.keySet();
            for (Map.Entry entry : txnData.updatedItemsCache.entrySet()) {
                Serializable key = (Serializable)entry.getKey();
                CacheBucket bucket = (CacheBucket)entry.getValue();
                bucket.doPreCommit(this.sharedCache, key, this.isMutable, this.allowEqualsChecks, txnData.isReadOnly);
            }
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("Pre-commit called for " + keys.size() + " values."));
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
        }
        finally {
            txnData.isClosed = true;
        }
    }

    @Override
    public void afterCommit() {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)"Processing after-commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)"Clear notification recieved in commit - clearing shared cache");
                }
            } else {
                for (Serializable key : txnData.removedItemsCache) {
                    this.sharedCache.remove(key);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in commit"));
                }
            }
            Set keys = txnData.updatedItemsCache.keySet();
            for (Map.Entry entry : txnData.updatedItemsCache.entrySet()) {
                Serializable key = (Serializable)entry.getKey();
                CacheBucket bucket = (CacheBucket)entry.getValue();
                bucket.doPostCommit(this.sharedCache, key, this.isMutable, this.allowEqualsChecks, txnData.isReadOnly);
            }
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("Post-commit called for " + keys.size() + " values."));
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
        }
        finally {
            this.removeCaches(txnData);
        }
    }

    @Override
    public void afterRollback() {
        TransactionData txnData = this.getTransactionData();
        try {
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)"Clear notification recieved in rollback - clearing shared cache");
                }
            } else {
                for (Serializable key : txnData.removedItemsCache) {
                    this.sharedCache.remove(key);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in rollback"));
                }
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", e);
        }
        finally {
            this.removeCaches(txnData);
        }
    }

    private void removeCaches(TransactionData txnData) {
        txnData.isClosed = true;
    }

    private Serializable getTenantAwareCacheKey(K key) {
        String tenantDomain;
        if (this.isTenantAware && !(tenantDomain = TenantUtil.getCurrentDomain()).equals("")) {
            return new CacheRegionKey(tenantDomain, (Serializable)key);
        }
        return key;
    }

    public static class CacheRegionKey
    implements Serializable {
        private static final long serialVersionUID = -213050301938804468L;
        private final String cacheRegion;
        private final Serializable cacheKey;
        private final int hashCode;

        public CacheRegionKey(String cacheRegion, Serializable cacheKey) {
            this.cacheRegion = cacheRegion;
            this.cacheKey = cacheKey;
            this.hashCode = cacheRegion.hashCode() + cacheKey.hashCode();
        }

        public Serializable getCacheKey() {
            return this.cacheKey;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public String toString() {
            return this.cacheRegion + (this.cacheRegion != "" ? "." : "") + this.cacheKey.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheRegionKey)) {
                return false;
            }
            CacheRegionKey that = (CacheRegionKey)obj;
            return this.cacheRegion.equals(that.cacheRegion) && this.cacheKey.equals(that.cacheKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class LRULinkedHashMap<K1, V1>
    extends LinkedHashMap<K1, V1> {
        private static final long serialVersionUID = -4874684348174271106L;

        private LRULinkedHashMap(int initialSize) {
            super(initialSize);
        }

        private boolean hasHitSize() {
            return this.size() >= TransactionalCache.this.maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K1, V1> eldest) {
            return this.size() > TransactionalCache.this.maxCacheSize;
        }
    }

    private class TransactionData {
        private LRULinkedHashMap<Serializable, CacheBucket<V>> updatedItemsCache;
        private Set<Serializable> removedItemsCache;
        private Set<Serializable> lockedItemsCache;
        private boolean haveIssuedFullWarning;
        private boolean isClearOn;
        private boolean isClosed;
        private boolean isReadOnly;
        private boolean noSharedCacheRead;

        private TransactionData() {
        }
    }

    private static class ReadCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = 7885689778259779578L;
        private final BV value;

        public ReadCacheBucket(BV value) {
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }
    }

    private static class UpdateCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = 7885689778259779578L;
        private final BV value;
        private final BV originalValue;

        public UpdateCacheBucket(BV originalValue, BV value) {
            this.originalValue = originalValue;
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
            Object sharedObj = sharedCache.get(key);
            if (sharedObj == null) {
                if (!mutable) {
                    sharedCache.put(key, this.value);
                }
            } else if (mutable) {
                if (sharedObj == this.originalValue) {
                    sharedCache.put(key, this.value);
                } else if (!allowEqualsCheck || !EqualsHelper.nullSafeEquals(this.value, (Object)sharedObj)) {
                    sharedCache.remove(key);
                }
            }
        }
    }

    private static class NewCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = -8536386687213957425L;
        private final BV value;

        public NewCacheBucket(BV value) {
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPreCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key, boolean mutable, boolean allowEqualsCheck, boolean readOnly) {
            Object sharedObj = sharedCache.get(key);
            if (sharedObj == null) {
                sharedCache.put(key, this.value);
            } else if (!(!mutable || sharedObj == this.value || allowEqualsCheck && EqualsHelper.nullSafeEquals(this.value, (Object)sharedObj))) {
                sharedCache.remove(key);
            }
        }
    }

    private static interface CacheBucket<BV>
    extends Serializable {
        public BV getValue();

        public void doPreCommit(SimpleCache<Serializable, Object> var1, Serializable var2, boolean var3, boolean var4, boolean var5);

        public void doPostCommit(SimpleCache<Serializable, Object> var1, Serializable var2, boolean var3, boolean var4, boolean var5);
    }
}

