/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.util.Pair;

public class AVMLs
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-R", 0};
    private static String USAGE = "usage: AVMLs [-R] nodepath";

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        Pair<String, Integer> pathVersion = this.splitPathVersion(args.get(0));
        AVMNodeDescriptor desc = this.fAVMRemote.lookup((Integer)pathVersion.getSecond(), (String)pathVersion.getFirst());
        if (flags.containsKey("-R")) {
            this.recursiveList(desc, 0);
        } else {
            this.list(desc);
        }
    }

    private void list(AVMNodeDescriptor desc) {
        if (desc.isFile()) {
            System.out.println(desc.getName() + '\t' + desc);
            return;
        }
        SortedMap<String, AVMNodeDescriptor> listing = this.fAVMRemote.getDirectoryListing(desc);
        for (Map.Entry entry : listing.entrySet()) {
            System.out.println((String)entry.getKey() + '\t' + entry.getValue());
        }
    }

    private void recursiveList(AVMNodeDescriptor desc, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(desc.getName() + '\t' + desc);
        if (desc.isDirectory()) {
            indent += 2;
            SortedMap<String, AVMNodeDescriptor> listing = this.fAVMRemote.getDirectoryListing(desc);
            for (Map.Entry entry : listing.entrySet()) {
                this.recursiveList((AVMNodeDescriptor)entry.getValue(), indent);
            }
        }
    }

    public static void main(String[] args) {
        AVMLs me = new AVMLs();
        me.exec(args, flagDefs, 1, USAGE);
    }
}

