/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.Pair;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class CltBase {
    protected AVMRemote fAVMRemote;
    protected AVMSyncService fAVMSyncService;
    protected RepoRemote fRepoRemote;
    protected ConfigurableApplicationContext fContext = new ClassPathXmlApplicationContext("clt-context.xml");
    protected AuthenticationService fAuthenticationService;
    private String fUsage;

    protected CltBase() {
        this.fAVMRemote = (AVMRemote)this.fContext.getBean("avmRemote");
        this.fAVMSyncService = (AVMSyncService)this.fContext.getBean("avmSyncService");
        this.fRepoRemote = (RepoRemote)this.fContext.getBean("repoRemote");
        this.fAuthenticationService = (AuthenticationService)this.fContext.getBean("authenticationService");
        this.fAuthenticationService.authenticate(System.getenv("ALFUSER"), System.getenv("ALFPASSWORD").toCharArray());
        String ticket = this.fAuthenticationService.getCurrentTicket();
        ((ClientTicketHolder)this.fContext.getBean("clientTicketHolder")).setTicket(ticket);
    }

    public void exec(String[] args, Object[] flagDefs, int minArgs, String usageMessage) {
        this.fUsage = usageMessage;
        HashMap<String, Integer> flagArgs = new HashMap<String, Integer>();
        HashMap<String, List<String>> flagValues = new HashMap<String, List<String>>();
        ArrayList<String> actualArgs = new ArrayList<String>();
        for (int i = 0; i < flagDefs.length / 2; ++i) {
            flagArgs.put((String)flagDefs[i * 2], (Integer)flagDefs[i * 2 + 1]);
        }
        int pos = 0;
        while (pos < args.length) {
            if (args[pos].equals("-h")) {
                this.usage();
            }
            if (flagArgs.containsKey(args[pos])) {
                String flag;
                int count;
                if (args.length - ++pos < (count = ((Integer)flagArgs.get(flag = args[pos])).intValue())) {
                    this.usage();
                }
                ArrayList<String> flArgs = new ArrayList<String>();
                for (int i = 0; i < count; ++i) {
                    flArgs.add(args[pos + i]);
                }
                flagValues.put(flag, flArgs);
                pos += count;
                continue;
            }
            actualArgs.add(args[pos]);
            ++pos;
        }
        if (actualArgs.size() < minArgs) {
            this.usage();
        }
        this.run(flagValues, actualArgs);
        this.fContext.close();
    }

    protected void usage() {
        System.err.println(this.fUsage);
        this.fContext.close();
        System.exit(1);
    }

    protected String[] splitPath(String path) {
        if (path.endsWith(":/")) {
            String[] ret = new String[]{path};
            return ret;
        }
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash == -1) {
            System.err.println("Malformed path: " + path);
            this.fContext.close();
            System.exit(1);
        }
        String name = path.substring(lastSlash + 1);
        String parent = path.substring(0, lastSlash);
        if (parent.endsWith(":")) {
            parent = parent + "/";
        }
        while (parent.endsWith("/") && !parent.endsWith(":/")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        String[] ret = new String[]{parent, name};
        return ret;
    }

    protected void copyStream(InputStream in, OutputStream out) {
        try {
            byte[] buff = new byte[8192];
            int read = 0;
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fContext.close();
            System.exit(1);
        }
    }

    protected Pair<String, Integer> splitPathVersion(String pathVersion) {
        int index = pathVersion.lastIndexOf(64);
        if (index == -1) {
            this.usage();
        }
        String path = pathVersion.substring(0, index);
        int version = Integer.parseInt(pathVersion.substring(index + 1));
        return new Pair((Object)path, (Object)version);
    }

    protected abstract void run(Map<String, List<String>> var1, List<String> var2);
}

