/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class CheckOutCheckInServiceImpl
implements CheckOutCheckInService {
    private static final String MSG_ERR_BAD_COPY = "coci_service.err_bad_copy";
    private static final String MSG_WORKING_COPY_LABEL = "coci_service.working_copy_label";
    private static final String MSG_ERR_NOT_OWNER = "coci_service.err_not_owner";
    private static final String MSG_ERR_ALREADY_WORKING_COPY = "coci_service.err_workingcopy_checkout";
    private static final String MSG_ERR_NOT_AUTHENTICATED = "coci_service.err_not_authenticated";
    private static final String MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE = "coci_service.err_workingcopy_has_no_mimetype";
    private static final String MSG_ALREADY_CHECKEDOUT = "coci_service.err_already_checkedout";
    private static final String MSG_ERR_CANNOT_RENAME = "coci_service.err_cannot_rename";
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckOut> beforeCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckOut> onCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckIn> beforeCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckIn> onCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> beforeCancelCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCancelCheckOut> onCancelCheckOut;
    private static final String EXTENSION_CHARACTER = ".";
    private static Log logger = LogFactory.getLog(CheckOutCheckInServiceImpl.class);
    private NodeService nodeService;
    private VersionService versionService;
    private LockService lockService;
    private CopyService copyService;
    private FileFolderService fileFolderService;
    private OwnableService ownableService;
    private PolicyComponent policyComponent;
    private AuthenticationService authenticationService;
    private RuleService ruleService;
    private BehaviourFilter behaviourFilter;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.beforeCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckOut.class);
        this.onCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckOut.class);
        this.beforeCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckIn.class);
        this.onCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckIn.class);
        this.beforeCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCancelCheckOut.class);
        this.onCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCancelCheckOut.class);
    }

    private List<QName> getInvokeClasses(NodeRef nodeRef) {
        ArrayList<QName> result = new ArrayList<QName>(10);
        result.add(this.nodeService.getType(nodeRef));
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            result.add(aspect);
        }
        return result;
    }

    private void invokeBeforeCheckOut(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckOut> policies = this.beforeCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckOut policy : policies) {
                policy.beforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
            }
        }
    }

    private void invokeOnCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckOut> policies = this.onCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckOut policy : policies) {
                policy.onCheckOut(workingCopy);
            }
        }
    }

    private void invokeBeforeCheckIn(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        List<QName> classes = this.getInvokeClasses(workingCopyNodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckIn> policies = this.beforeCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckIn policy : policies) {
                policy.beforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
            }
        }
    }

    private void invokeOnCheckIn(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckIn> policies = this.onCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckIn policy : policies) {
                policy.onCheckIn(nodeRef);
            }
        }
    }

    private void invokeBeforeCancelCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> policies = this.beforeCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCancelCheckOut policy : policies) {
                policy.beforeCancelCheckOut(workingCopy);
            }
        }
    }

    private void invokeOnCancelCheckOut(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCancelCheckOut> policies = this.onCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCancelCheckOut policy : policies) {
                policy.onCancelCheckOut(nodeRef);
            }
        }
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef) {
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        return this.checkout(nodeRef, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef checkout(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
            throw new CheckOutCheckInServiceException(MSG_ALREADY_CHECKEDOUT);
        }
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new CheckOutCheckInServiceException(MSG_ERR_ALREADY_WORKING_COPY);
        }
        LockStatus lockStatus = this.lockService.getLockStatus(nodeRef);
        if (lockStatus != LockStatus.NO_LOCK && lockStatus != LockStatus.LOCK_EXPIRED) {
            throw new NodeLockedException(nodeRef);
        }
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        this.behaviourFilter.disableBehaviour(destinationParentNodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            NodeRef nodeRef2 = this.doCheckout(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
            return nodeRef2;
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.enableBehaviour(destinationParentNodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef doCheckout(final NodeRef nodeRef, final NodeRef destinationParentNodeRef, final QName destinationAssocTypeQName, QName destinationAssocQName) {
        this.invokeBeforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
        final String userName = this.getUserName();
        NodeRef workingCopy = null;
        this.ruleService.disableRuleType("update");
        try {
            String copyName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String workingCopyLabel = CheckOutCheckInServiceImpl.getWorkingCopyLabel();
            copyName = CheckOutCheckInServiceImpl.createWorkingCopyName(copyName, workingCopyLabel);
            final QName copyQName = QName.createQName((String)destinationAssocQName.getNamespaceURI(), (String)QName.createValidLocalName((String)copyName));
            ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            workingCopy = destinationParentNodeRef.equals((Object)childAssocRef.getParentRef()) ? (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef copy = CheckOutCheckInServiceImpl.this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, copyQName);
                    CheckOutCheckInServiceImpl.this.ownableService.setOwner(copy, userName);
                    return copy;
                }
            }, (String)AuthenticationUtil.getSystemUserName()) : this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, copyQName);
            this.nodeService.setProperty(workingCopy, ContentModel.PROP_NAME, (Serializable)((Object)copyName));
            HashMap<QName, String> workingCopyProperties = new HashMap<QName, String>(1);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, userName);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_LABEL, workingCopyLabel);
            this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
            this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_LOCKABLE, null);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT, null);
            this.nodeService.createAssociation(nodeRef, workingCopy, ContentModel.ASSOC_WORKING_COPY_LINK);
        }
        finally {
            this.ruleService.enableRuleType("update");
        }
        this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        this.invokeOnCheckOut(workingCopy);
        return workingCopy;
    }

    private String getUserName() {
        String un = this.authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new CheckOutCheckInServiceException(MSG_ERR_NOT_AUTHENTICATED);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties) {
        return this.checkin(workingCopyNodeRef, versionProperties, null, false);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl) {
        return this.checkin(workingCopyNodeRef, versionProperties, contentUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        NodeRef nodeRef = this.getCheckedOut(workingCopyNodeRef);
        if (nodeRef == null) {
            throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
        }
        this.invokeBeforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
        try {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                this.lockService.unlock(nodeRef, false, true);
            }
        }
        catch (UnableToReleaseLockException exception) {
            throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
        }
        if (contentUrl != null) {
            ContentData contentData = (ContentData)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT);
            if (contentData == null) {
                throw new AlfrescoRuntimeException(MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE, new Object[]{workingCopyNodeRef});
            }
            contentData = new ContentData(contentUrl, contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
            this.nodeService.setProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
        }
        this.copyService.copy(workingCopyNodeRef, nodeRef);
        if (this.fileFolderService.getFileInfo(workingCopyNodeRef) != null) {
            String origName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String name = (String)((Object)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_NAME));
            String wcLabel = (String)((Object)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_WORKING_COPY_LABEL));
            if (wcLabel == null) {
                wcLabel = CheckOutCheckInServiceImpl.getWorkingCopyLabel();
            }
            if (this.hasWorkingCopyNameChanged(name, origName, wcLabel)) {
                if (!name.contains(" " + wcLabel)) {
                    try {
                        this.fileFolderService.rename(workingCopyNodeRef, CheckOutCheckInServiceImpl.createWorkingCopyName(name, wcLabel));
                    }
                    catch (FileExistsException e) {
                        throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, wcLabel);
                    }
                    catch (FileNotFoundException e) {
                        throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, wcLabel);
                    }
                }
                String newName = this.getNameFromWorkingCopyName(name, wcLabel);
                try {
                    this.fileFolderService.rename(nodeRef, newName);
                }
                catch (FileExistsException e) {
                    throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, origName, newName);
                }
                catch (FileNotFoundException e) {
                    throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, newName);
                }
            }
        }
        if (versionProperties != null && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.versionService.createVersion(nodeRef, versionProperties);
        }
        if (!keepCheckedOut) {
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
            try {
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
                this.nodeService.deleteNode(workingCopyNodeRef);
            }
            finally {
                this.behaviourFilter.enableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        } else {
            this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        }
        this.invokeOnCheckIn(nodeRef);
        return nodeRef;
    }

    @Override
    public NodeRef cancelCheckout(NodeRef workingCopyNodeRef) {
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        NodeRef nodeRef = this.getCheckedOut(workingCopyNodeRef);
        if (nodeRef == null) {
            throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
        }
        this.invokeBeforeCancelCheckOut(workingCopyNodeRef);
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        this.behaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
        try {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                this.lockService.unlock(nodeRef, false, true);
            }
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
            this.nodeService.deleteNode(workingCopyNodeRef);
            this.invokeOnCancelCheckOut(nodeRef);
        }
        catch (UnableToReleaseLockException exception) {
            throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
        return nodeRef;
    }

    @Override
    public NodeRef getWorkingCopy(NodeRef nodeRef) {
        List assocs;
        NodeRef workingCopy = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT) && (assocs = this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK)).size() > 0) {
            if (assocs.size() > 1) {
                logger.warn((Object)("Found multiple " + ContentModel.ASSOC_WORKING_COPY_LINK + " association from node: " + nodeRef));
            }
            workingCopy = ((AssociationRef)assocs.get(0)).getTargetRef();
        }
        return workingCopy;
    }

    @Override
    public NodeRef getCheckedOut(NodeRef nodeRef) {
        List assocs;
        NodeRef original = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && (assocs = this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK)).size() > 0) {
            if (assocs.size() > 1) {
                logger.warn((Object)("Found multiple " + ContentModel.ASSOC_WORKING_COPY_LINK + " associations to node: " + nodeRef));
            }
            original = ((AssociationRef)assocs.get(0)).getSourceRef();
        }
        return original;
    }

    @Override
    public boolean isWorkingCopy(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
    }

    @Override
    public boolean isCheckedOut(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT);
    }

    public static String createWorkingCopyName(String name, String workingCopyLabel) {
        if (workingCopyLabel != null && workingCopyLabel.length() != 0) {
            int index;
            name = name != null && name.length() != 0 ? ((index = name.lastIndexOf(EXTENSION_CHARACTER)) > 0 ? name.substring(0, index) + " " + workingCopyLabel + name.substring(index) : name + " " + workingCopyLabel) : workingCopyLabel;
        } else {
            throw new IllegalArgumentException("workingCopyLabel is null or empty");
        }
        return name;
    }

    private String getNameFromWorkingCopyName(String workingCopyName, String workingCopyLabel) {
        String workingCopyLabelRegEx = workingCopyLabel.replaceAll("\\(", "\\\\(");
        workingCopyLabelRegEx = workingCopyLabelRegEx.replaceAll("\\)", "\\\\)");
        if (workingCopyName.contains(" " + workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(" " + workingCopyLabelRegEx, "");
        } else if (workingCopyName.contains(workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(workingCopyLabelRegEx, "");
        }
        return workingCopyName;
    }

    private boolean hasWorkingCopyNameChanged(String workingCopyName, String origName, String wcLabel) {
        String origWorkingCopyName = CheckOutCheckInServiceImpl.createWorkingCopyName(origName, wcLabel);
        return !workingCopyName.equals(origWorkingCopyName);
    }

    public static String getWorkingCopyLabel() {
        return I18NUtil.getMessage((String)MSG_WORKING_COPY_LABEL);
    }
}

