/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformerLimits;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentServiceTransientException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractContentTransformer2
extends AbstractContentTransformerLimits {
    private static final Log logger = LogFactory.getLog(AbstractContentTransformer2.class);
    private ContentTransformerRegistry registry;
    private boolean registerTransformer;
    private static ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected AbstractContentTransformer2() {
    }

    public void setRegistry(ContentTransformerRegistry registry) {
        this.registry = registry;
    }

    public void setRegisterTransformer(boolean registerTransformer) {
        this.registerTransformer = registerTransformer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void register() {
        super.register();
        if (this.registry == null) {
            logger.warn((Object)("Property 'registry' has not been set.  Ignoring auto-registration: \n   transformer: " + this.getName()));
        } else if (this.registerTransformer) {
            this.registry.addTransformer(this);
        } else {
            this.registry.addComponentTransformer(this);
            logger.debug((Object)("Property 'registerTransformer' have not been set, so transformer (" + this.getName() + ") may only be used as a component of a complex transformer."));
        }
    }

    protected void checkTransformable(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        String targetMimetype = this.getMimetype((ContentAccessor)writer);
        long sourceSize = reader.getSize();
        boolean transformable = this.isTransformable(sourceMimetype, sourceSize, targetMimetype, options);
        if (!transformable) {
            long maxSourceSizeKBytes = this.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
            boolean sizeOkay = maxSourceSizeKBytes < 0L || maxSourceSizeKBytes > 0L && sourceSize <= maxSourceSizeKBytes * 1024L;
            UnsupportedTransformationException e = new UnsupportedTransformationException("Unsupported transformation: " + this.getBeanName() + ' ' + sourceMimetype + " to " + targetMimetype + ' ' + (sizeOkay ? "" : this.transformerDebug.fileSize(sourceSize) + " > " + this.transformerDebug.fileSize(maxSourceSizeKBytes * 1024L)));
            throw (AlfrescoRuntimeException)this.transformerDebug.setCause(e);
        }
    }

    protected abstract void transformInternal(ContentReader var1, ContentWriter var2, TransformationOptions var3) throws Exception;

    @Override
    public final void transform(ContentReader reader, ContentWriter writer) throws ContentIOException {
        this.transform(reader, writer, new TransformationOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws ContentIOException {
        try {
            depth.set(depth.get() + 1);
            long before = System.currentTimeMillis();
            String sourceMimetype = reader.getMimetype();
            String targetMimetype = writer.getMimetype();
            if (options == null) {
                options = new TransformationOptions();
            }
            try {
                if (this.transformerDebug.isEnabled()) {
                    this.transformerDebug.pushTransform(this, reader.getContentUrl(), sourceMimetype, targetMimetype, reader.getSize(), options);
                }
                this.checkTransformable(reader, writer, options);
                this.setReaderLimits(reader, writer, options);
                this.transformInternal(reader, writer, options);
                long after = System.currentTimeMillis();
                this.recordTime(sourceMimetype, targetMimetype, after - before);
            }
            catch (ContentServiceTransientException cste) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformation has been transiently declined: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options + "\n" + "   transformer: " + this));
                }
                throw cste;
            }
            catch (UnsupportedTransformationException e) {
                this.transformerDebug.debug("          Failed", (Throwable)((Object)e));
                throw e;
            }
            catch (Throwable e) {
                long after = System.currentTimeMillis();
                this.recordError(sourceMimetype, targetMimetype, after - before);
                String differentType = this.getMimetypeService().getMimetypeIfNotMatches(reader.getReader());
                if (differentType == null) {
                    this.transformerDebug.debug("          Failed", e);
                    throw new ContentIOException("Content conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options.toString(false) + "\n" + "   limits: " + this.getLimits(reader, writer, options), e);
                }
                this.transformerDebug.debug("          Failed: Mime type was '" + differentType + "'", e);
                throw new ContentIOException("Content conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options.toString(false) + "\n" + "   limits: " + this.getLimits(reader, writer, options) + "\n" + "   claimed mime type: " + reader.getMimetype() + "\n" + "   detected mime type: " + differentType, e);
            }
            finally {
                this.transformerDebug.popTransform();
                if (reader.isChannelOpen()) {
                    logger.error((Object)("Content reader not closed by transformer: \n   reader: " + reader + "\n" + "   transformer: " + this));
                }
                if (writer.isChannelOpen()) {
                    logger.error((Object)("Content writer not closed by transformer: \n   writer: " + writer + "\n" + "   transformer: " + this));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Completed transformation: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options + "\n" + "   transformer: " + this));
            }
        }
        finally {
            depth.set(depth.get() - 1);
        }
    }

    @Override
    public final void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
        this.transform(reader, writer, new TransformationOptions(options));
    }

    @Override
    public synchronized long getTransformationTime() {
        return this.transformerConfig.getStatistics(this, null, null, true).getAverageTime();
    }

    @Override
    public synchronized long getTransformationTime(String sourceMimetype, String targetMimetype) {
        return this.transformerConfig.getStatistics(this, sourceMimetype, targetMimetype, true).getAverageTime();
    }

    protected final synchronized void recordTime(long transformationTime) {
        this.recordTime("*", "*", transformationTime);
    }

    protected final synchronized void recordTime(String sourceMimetype, String targetMimetype, long transformationTime) {
        this.transformerConfig.getStatistics(this, sourceMimetype, targetMimetype, true).recordTime(transformationTime);
        if (depth.get() == 1) {
            this.transformerConfig.getStatistics(null, sourceMimetype, targetMimetype, true).recordTime(transformationTime);
        }
    }

    protected final synchronized void recordError(String sourceMimetype, String targetMimetype, long transformationTime) {
        this.transformerConfig.getStatistics(this, sourceMimetype, targetMimetype, true).recordError(transformationTime);
        if (depth.get() == 1) {
            this.transformerConfig.getStatistics(null, sourceMimetype, targetMimetype, true).recordError(transformationTime);
        }
    }
}

