/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Map;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;

public abstract class AbstractContentTransformerLimits
extends ContentTransformerHelper
implements ContentTransformer {
    private boolean pageLimitsSupported;
    protected TransformerDebug transformerDebug;

    protected boolean isPageLimitSupported(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.pageLimitsSupported;
    }

    public void setPageLimitsSupported(boolean pageLimitsSupported) {
        this.pageLimitsSupported = pageLimitsSupported;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        throw new IllegalStateException("Method should no longer be called. Override isTransformableMimetype in subclass.");
    }

    @Override
    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return this.isSupportedTransformation(sourceMimetype, targetMimetype, options) && this.isTransformableMimetype(sourceMimetype, targetMimetype, options) && this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options);
    }

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.isTransformable(sourceMimetype, targetMimetype, options);
    }

    @Override
    public boolean isTransformableSize(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        boolean sizeOkay = true;
        if (sourceSize >= 0L) {
            long maxSourceSizeKBytes = this.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
            boolean bl = sizeOkay = maxSourceSizeKBytes < 0L || maxSourceSizeKBytes > 0L && sourceSize <= maxSourceSizeKBytes * 1024L;
            if (!sizeOkay && this.transformerDebug.isEnabled()) {
                this.transformerDebug.unavailableTransformer(this, sourceMimetype, targetMimetype, maxSourceSizeKBytes);
            }
        }
        return sizeOkay;
    }

    @Override
    public long getMaxSourceSizeKBytes(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        long maxSourceSizeKBytes = -1L;
        TransformationOptionLimits limits = this.getLimits(sourceMimetype, targetMimetype, options);
        if (!this.isPageLimitSupported(sourceMimetype, targetMimetype, options) || limits.getPageLimit() <= 0) {
            maxSourceSizeKBytes = limits.getMaxSourceSizeKBytes();
        }
        return maxSourceSizeKBytes;
    }

    protected long getTimeoutMs() {
        return this.getLimits().getTimeoutMs();
    }

    public void setTimeoutMs(long timeoutMs) {
        this.deprecatedSetter(null, null, "timeoutMs=" + timeoutMs);
    }

    protected long getReadLimitTimeMs() {
        return this.getLimits().getReadLimitTimeMs();
    }

    public void setReadLimitTimeMs(long readLimitTimeMs) {
        this.deprecatedSetter(null, null, "readLimitTimeMs=" + readLimitTimeMs);
    }

    protected long getMaxSourceSizeKBytes() {
        return this.getLimits().getMaxSourceSizeKBytes();
    }

    public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
        this.deprecatedSetter(null, null, "maxSourceSizeKBytes=" + maxSourceSizeKBytes);
    }

    protected long getReadLimitKBytes() {
        return this.getLimits().getReadLimitKBytes();
    }

    public void setReadLimitKBytes(long readLimitKBytes) {
        this.deprecatedSetter(null, null, "readLimitKBytes=" + readLimitKBytes);
    }

    protected int getMaxPages() {
        return this.getLimits().getMaxPages();
    }

    public void setMaxPages(int maxPages) {
        this.deprecatedSetter(null, null, "maxPages=" + maxPages);
    }

    protected int getPageLimit() {
        return this.getLimits().getPageLimit();
    }

    public void setPageLimit(int pageLimit) {
        this.deprecatedSetter(null, null, "pageLimit=" + pageLimit);
    }

    protected TransformationOptionLimits getLimits() {
        return this.transformerConfig.getLimits(this, null, null, null);
    }

    public void setLimits(TransformationOptionLimits limits) {
        this.deprecatedLimitsSetter(null, null, limits);
    }

    public void setMimetypeLimits(Map<String, Map<String, TransformationOptionLimits>> mimetypeLimits) {
        for (Map.Entry<String, Map<String, TransformationOptionLimits>> source : mimetypeLimits.entrySet()) {
            String sourceMimetype = source.getKey();
            for (Map.Entry<String, TransformationOptionLimits> target : source.getValue().entrySet()) {
                String targetMimetype = target.getKey();
                TransformationOptionLimits limits = target.getValue();
                this.deprecatedLimitsSetter(sourceMimetype, targetMimetype, limits);
            }
        }
    }

    private void deprecatedLimitsSetter(String sourceMimetype, String targetMimetype, TransformationOptionLimits limits) {
        if (limits.supported()) {
            for (String limit : new String[]{limits.getTimePair().toString("timeoutMs", "readLimitTimeMs"), limits.getKBytesPair().toString("maxSourceSizeKBytes", "readLimitKBytes"), limits.getPagesPair().toString("maxPages", "pageLimit")}) {
                if (limit == null) continue;
                this.deprecatedSetter(sourceMimetype, targetMimetype, '.' + limit);
            }
        } else {
            this.deprecatedSetter(sourceMimetype, targetMimetype, ".supported=false");
        }
    }

    protected TransformationOptionLimits getLimits(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        return reader == null || writer == null ? this.transformerConfig.getLimits(this, null, null, options.getUse()).combine(options.getLimits()) : this.getLimits(reader.getMimetype(), writer.getMimetype(), options);
    }

    protected TransformationOptionLimits getLimits(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        TransformationOptionLimits limits = this.transformerConfig.getLimits(this, sourceMimetype, targetMimetype, options == null ? null : options.getUse());
        return options == null ? limits : limits.combine(options.getLimits());
    }

    protected void setReaderLimits(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        if (reader instanceof AbstractContentReader) {
            AbstractContentReader abstractContentReader = (AbstractContentReader)reader;
            TransformationOptionLimits limits = this.getLimits(reader, writer, options);
            abstractContentReader.setLimits(limits);
            abstractContentReader.setTransformerDebug(this.transformerDebug);
        }
    }
}

