/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerSelector;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentTransformerRegistry {
    private static final Log logger = LogFactory.getLog(ContentTransformerRegistry.class);
    private final List<ContentTransformer> transformers;
    private final List<ContentTransformer> allTransformers;
    private final TransformerSelector transformerSelector;

    public ContentTransformerRegistry(TransformerSelector transformerSelector) {
        this.transformerSelector = transformerSelector;
        this.transformers = new ArrayList<ContentTransformer>(70);
        this.allTransformers = new ArrayList<ContentTransformer>(70);
    }

    public synchronized void addTransformer(ContentTransformer transformer) {
        this.transformers.add(transformer);
        this.allTransformers.add(transformer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered general transformer: \n   transformer: " + transformer.getName() + " (" + transformer + ")"));
        }
    }

    public synchronized void addComponentTransformer(ContentTransformer transformer) {
        this.allTransformers.add(transformer);
    }

    public synchronized void removeTransformer(ContentTransformer transformer) {
        this.transformers.remove(transformer);
        this.allTransformers.remove(transformer);
    }

    public synchronized List<ContentTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public synchronized List<ContentTransformer> getAllTransformers() {
        return Collections.unmodifiableList(this.allTransformers);
    }

    public synchronized ContentTransformer getTransformer(String transformerName) {
        if (transformerName != null) {
            for (ContentTransformer transformer : this.allTransformers) {
                if (!transformerName.equals(transformer.getName())) continue;
                return transformer;
            }
            throw new IllegalArgumentException("Unknown transformer: " + (transformerName.startsWith("transformer.") ? transformerName.substring("transformer.".length()) : transformerName));
        }
        return null;
    }

    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.getTransformer(sourceMimetype, -1L, targetMimetype, options);
    }

    public ContentTransformer getTransformer(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
        ContentTransformer bestTransformer = null;
        if (transformers.size() > 0) {
            bestTransformer = transformers.get(0);
        }
        return bestTransformer;
    }

    public List<ContentTransformer> getActiveTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.transformerSelector.selectTransformers(sourceMimetype, sourceSize, targetMimetype, options);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searched for transformer: \n   source mimetype: " + sourceMimetype + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   transformers: " + transformers));
        }
        return transformers;
    }

    private void buildTransformer(List<ContentTransformer> transformers, double reliability, List<String> touchedMimetypes, String currentMimetype, String targetMimetype) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static class TransformationKey {
        private final String sourceMimetype;
        private final String targetMimetype;
        private final String key;

        public TransformationKey(String sourceMimetype, String targetMimetype) {
            this.key = sourceMimetype + "_" + targetMimetype;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
        }

        public String getSourceMimetype() {
            return this.sourceMimetype;
        }

        public String getTargetMimetype() {
            return this.targetMimetype;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TransformationKey)) {
                return false;
            }
            TransformationKey that = (TransformationKey)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

