/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DoubleMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> mapMap = new ConcurrentHashMap<K1, Map<K2, V>>();
    private final K1 anyKey1;
    private final K2 anyKey2;

    public DoubleMap(K1 anyKey1, K2 anyKey2) {
        this.anyKey1 = anyKey1;
        this.anyKey2 = anyKey2;
    }

    public V get(K1 key1, K2 key2) {
        V value = null;
        Map<K2, V> map = this.mapMap.get(key1);
        boolean anySource = false;
        if (map == null) {
            map = this.mapMap.get(this.anyKey1);
            anySource = true;
        }
        if (map != null && (value = (V)map.get(key2)) == null && (value = (V)map.get(this.anyKey2)) == null && !anySource && (map = this.mapMap.get(this.anyKey1)) != null && (value = (V)map.get(key2)) == null) {
            value = map.get(this.anyKey2);
        }
        return value;
    }

    public V getNoWildcards(K1 key1, K2 key2) {
        V value = null;
        Map<K2, V> map = this.mapMap.get(key1);
        if (map != null) {
            value = map.get(key2);
        }
        return value;
    }

    public void put(K1 key1, K2 key2, V t) {
        Map<K2, V> map = this.mapMap.get(key1);
        if (map == null) {
            map = new ConcurrentHashMap<K2, V>();
            this.mapMap.put(key1, map);
        }
        map.put(key2, t);
    }
}

