/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class FailoverContentTransformer
extends AbstractContentTransformer2
implements InitializingBean {
    private static Log logger = LogFactory.getLog(FailoverContentTransformer.class);
    private List<ContentTransformer> transformers;

    public void setTransformers(List<ContentTransformer> transformers) {
        this.transformers = transformers;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transformers == null || this.transformers.size() == 0) {
            throw new AlfrescoRuntimeException("At least one inner transformer must be supplied: " + this);
        }
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("'mimetypeService' is a required property");
        }
    }

    @Override
    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return this.isSupportedTransformation(sourceMimetype, targetMimetype, options) && (sourceSize >= 0L && this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options) || sourceSize < 0L && this.isTransformableMimetype(sourceMimetype, targetMimetype, options));
    }

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.isTransformableMimetypeAndSize(sourceMimetype, -1L, targetMimetype, options);
    }

    @Override
    public boolean isTransformableSize(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return sourceSize < 0L || super.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options) && this.isTransformableMimetypeAndSize(sourceMimetype, sourceSize, targetMimetype, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTransformableMimetypeAndSize(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        boolean result = false;
        for (ContentTransformer ct : this.transformers) {
            if (!ct.isTransformableMimetype(sourceMimetype, targetMimetype, options)) continue;
            if (sourceSize < 0L) {
                result = true;
                break;
            }
            try {
                this.transformerDebug.pushIsTransformableSize(this);
                if (!ct.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options)) continue;
                result = true;
                break;
            }
            finally {
                this.transformerDebug.popIsTransformableSize();
            }
        }
        return result;
    }

    @Override
    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = true;
        for (ContentTransformer ct : this.transformers) {
            if (ct.isExplicitTransformation(sourceMimetype, targetMimetype, options)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String outputMimetype = writer.getMimetype();
        String outputFileExt = this.getMimetypeService().getExtension(outputMimetype);
        Exception transformationException = null;
        for (int i = 0; i < this.transformers.size(); ++i) {
            int oneBasedCount = i + 1;
            ContentTransformer transf = this.transformers.get(i);
            FileContentWriter currentWriter = null;
            File tempFile = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformation attempt " + oneBasedCount + " of " + this.transformers.size() + ": " + transf));
                }
                tempFile = TempFileProvider.createTempFile((String)("FailoverTransformer_intermediate_" + transf.getClass().getSimpleName() + "_"), (String)("." + outputFileExt));
                currentWriter = new FileContentWriter(tempFile);
                currentWriter.setMimetype(outputMimetype);
                currentWriter.setEncoding(writer.getEncoding());
                transf.transform(reader, (ContentWriter)currentWriter, options);
            }
            catch (Exception are) {
                if (transformationException == null) {
                    transformationException = are;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformation " + oneBasedCount + " was unsuccessful."));
                    if (i != this.transformers.size() - 1) {
                        logger.debug((Object)"The below exception is provided for information purposes only.", (Throwable)are);
                    }
                }
                reader = reader.getReader();
                continue;
            }
            if (tempFile != null) {
                writer.putContent(tempFile);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Transformation was successful");
            }
            return;
        }
        if (transformationException != null) {
            this.transformerDebug.debug("          No more transformations to failover to");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"All transformations were unsuccessful. Throwing first exception.", transformationException);
            }
            throw transformationException;
        }
    }

    @Override
    public String getComments(boolean available) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getComments(available));
        sb.append("# ");
        sb.append("content.");
        sb.append(this.getName());
        sb.append(".failover");
        sb.append('=');
        boolean first = true;
        for (ContentTransformer transformer : this.transformers) {
            if (!first) {
                sb.append('|');
            }
            first = false;
            sb.append(transformer != null ? FailoverContentTransformer.getSimpleName(transformer) : "*");
        }
        sb.append('\n');
        return sb.toString();
    }
}

