/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.sf.jooreports.converter.DocumentFamily;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.converter.XmlDocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.FileCopyUtils;

public abstract class OOoContentTransformerHelper
extends ContentTransformerHelper {
    private String documentFormatsConfiguration;
    private DocumentFormatRegistry formatRegistry;
    protected TransformerDebug transformerDebug;

    public void setDocumentFormatsConfiguration(String path) {
        this.documentFormatsConfiguration = path;
    }

    protected abstract Log getLogger();

    protected abstract String getTempFilePrefix();

    public abstract boolean isAvailable();

    protected abstract void convert(File var1, DocumentFormat var2, File var3, DocumentFormat var4);

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.documentFormatsConfiguration != null) {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            try {
                InputStream is = resourceLoader.getResource(this.documentFormatsConfiguration).getInputStream();
                this.formatRegistry = new XmlDocumentFormatRegistry(is);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to load document formats configuration file: " + this.documentFormatsConfiguration);
            }
        } else {
            this.formatRegistry = new XmlDocumentFormatRegistry();
        }
    }

    protected boolean isTransformationBlocked(String sourceMimetype, String targetMimetype) {
        if (targetMimetype.equals("application/xhtml+xml")) {
            return true;
        }
        if (targetMimetype.equals("application/wordperfect")) {
            return true;
        }
        return targetMimetype.equals("application/x-shockwave-flash");
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (sourceMimetype.equals(targetMimetype)) {
            return false;
        }
        if (!this.isAvailable()) {
            return false;
        }
        if (this.isTransformationBlocked(sourceMimetype, targetMimetype)) {
            if (this.getLogger().isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Transformation from ").append(sourceMimetype).append(" to ").append(targetMimetype).append(" is blocked and therefore unavailable.");
                this.getLogger().debug((Object)msg.toString());
            }
            return false;
        }
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            return false;
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            return false;
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        return targetFormat.isExportableFrom(sourceFamily);
    }

    @Override
    public String getComments(boolean available) {
        return "# Transformations supported by OpenOffice/LibreOffice\n";
    }

    private void produceEmptyPdfFile(File tempToFile) {
        PDDocument pdfDoc = null;
        PDPageContentStream contentStream = null;
        try {
            pdfDoc = new PDDocument();
            PDPage pdfPage = new PDPage();
            contentStream = new PDPageContentStream(pdfDoc, pdfPage);
            pdfDoc.addPage(pdfPage);
            pdfDoc.save(tempToFile.getAbsolutePath());
        }
        catch (COSVisitorException cvx) {
            throw new ContentIOException("Error creating empty PDF file", (Throwable)cvx);
        }
        catch (IOException iox) {
            throw new ContentIOException("Error creating empty PDF file", (Throwable)iox);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException ignored) {}
            }
            if (pdfDoc != null) {
                try {
                    pdfDoc.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public String getVersionString() {
        return "";
    }

    public void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        if (!this.isAvailable()) {
            throw new ContentIOException("Content conversion failed (unavailable): \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("transforming content from ").append(reader.getMimetype()).append(" to ").append(writer.getMimetype());
            this.getLogger().debug((Object)msg.toString());
        }
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        String targetMimetype = this.getMimetype((ContentAccessor)writer);
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            throw new ContentIOException("No OpenOffice document format for source extension: " + sourceExtension);
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            throw new ContentIOException("No OpenOffice document format for target extension: " + targetExtension);
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        if (!targetFormat.isExportableFrom(sourceFamily)) {
            throw new ContentIOException("OpenOffice conversion not supported: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
        File tempFromFile = TempFileProvider.createTempFile((String)(this.getTempFilePrefix() + "-source-"), (String)("." + sourceExtension));
        File tempToFile = TempFileProvider.createTempFile((String)(this.getTempFilePrefix() + "-target-"), (String)("." + targetExtension));
        long documentSize = reader.getSize();
        if (documentSize == 0L || this.temporaryMsFile(options)) {
            this.produceEmptyPdfFile(tempToFile);
        } else {
            this.saveContentInFile(sourceMimetype, reader, tempFromFile);
            try {
                this.convert(tempFromFile, sourceFormat, tempToFile, targetFormat);
            }
            catch (OpenOfficeException e) {
                throw new ContentIOException("OpenOffice server conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   from file: " + tempFromFile + "\n" + "   to file: " + tempToFile, (Throwable)e);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("transforming ").append(tempFromFile.getName()).append(" to ").append(tempToFile.getName());
            this.getLogger().debug((Object)msg.toString());
        }
        writer.putContent(tempToFile);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"transformation successful");
        }
    }

    private boolean temporaryMsFile(TransformationOptions options) {
        String fileName = this.transformerDebug == null ? null : this.transformerDebug.getFileName(options, true, -1L);
        return fileName != null && fileName.startsWith("~$");
    }

    public void saveContentInFile(String sourceMimetype, ContentReader reader, File file) throws ContentIOException {
        String encoding = reader.getEncoding();
        if (this.encodeAsUtf8(sourceMimetype, encoding)) {
            this.saveContentInUtf8File(reader, file);
        } else {
            reader.getContent(file);
        }
    }

    protected boolean encodeAsUtf8(String sourceMimetype, String encoding) {
        return "text/plain".equals(sourceMimetype) && !"UTF-8".equals(encoding);
    }

    private void saveContentInUtf8File(ContentReader reader, File file) {
        String encoding = reader.getEncoding();
        try {
            InputStreamReader in = new InputStreamReader(reader.getContentInputStream(), encoding);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8");
            FileCopyUtils.copy((Reader)in, (Writer)out);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to file and convert " + encoding + " to UTF-8: \n" + "   file: " + file, (Throwable)e);
        }
    }
}

