/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptionPair;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.TextToPDF;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextToPdfContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(TextToPdfContentTransformer.class);
    private PagedTextToPDF transformer;

    public TextToPdfContentTransformer() {
        this.setPageLimitsSupported(true);
        this.transformer = new PagedTextToPDF();
    }

    public void setStandardFont(String fontName) {
        try {
            this.transformer.setFont((PDSimpleFont)PDType1Font.getStandardFont((String)fontName));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set Standard Font for PDF generation: " + fontName, e);
        }
    }

    public void setTrueTypeFont(String fontName) {
        try {
            this.transformer.setFont((PDSimpleFont)PDTrueTypeFont.loadTTF(null, (String)fontName));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set True Type Font for PDF generation: " + fontName, e);
        }
    }

    public void setFontSize(int fontSize) {
        try {
            this.transformer.setFontSize(fontSize);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set Font Size for PDF generation: " + fontSize);
        }
    }

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return ("text/plain".equals(sourceMimetype) || "text/csv".equals(sourceMimetype) || "text/xml".equals(sourceMimetype)) && "application/pdf".equals(targetMimetype);
    }

    @Override
    public String getComments(boolean available) {
        return this.getCommentsOnlySupports(Arrays.asList("text/plain", "text/csv", "text/xml"), Arrays.asList("application/pdf"), available);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        PDDocument pdf = null;
        InputStream is = null;
        InputStreamReader ir = null;
        OutputStream os = null;
        try {
            is = reader.getContentInputStream();
            ir = this.buildReader(is, reader.getEncoding(), reader.getContentUrl());
            TransformationOptionLimits limits = this.getLimits(reader, writer, options);
            TransformationOptionPair pageLimits = limits.getPagesPair();
            pdf = this.transformer.createPDFFromText(ir, pageLimits, reader.getContentUrl());
            os = writer.getContentOutputStream();
            pdf.save(os);
        }
        finally {
            if (pdf != null) {
                try {
                    pdf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected InputStreamReader buildReader(InputStream is, String encoding, String node) {
        if (encoding != null) {
            Charset charset = null;
            try {
                charset = Charset.forName(encoding);
            }
            catch (Exception e) {
                logger.warn((Object)("JVM doesn't understand encoding '" + encoding + "' when transforming " + node));
            }
            if (charset != null) {
                logger.debug((Object)("Processing plain text in encoding " + charset.displayName()));
                return new InputStreamReader(is, charset);
            }
        }
        logger.debug((Object)"Processing plain text using system default encoding");
        return new InputStreamReader(is);
    }

    private class PagedTextToPDF
    extends TextToPDF {
        private PagedTextToPDF() {
        }

        public PDDocument createPDFFromText(Reader text, TransformationOptionPair pageLimits, String contentUrl) throws IOException {
            int pageLimit = (int)pageLimits.getValue();
            PDDocument doc = null;
            int pageCount = 0;
            try {
                int margin = 40;
                float height = this.getFont().getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
                height = height * (float)this.getFontSize() * 1.05f;
                doc = new PDDocument();
                BufferedReader data = new BufferedReader(text);
                String nextLine = null;
                PDPage page = new PDPage();
                PDPageContentStream contentStream = null;
                float y = -1.0f;
                float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
                boolean textIsEmpty = true;
                block2: while ((nextLine = data.readLine()) != null) {
                    textIsEmpty = false;
                    String[] lineWords = nextLine.trim().split(" ");
                    int lineIndex = 0;
                    while (lineIndex < lineWords.length) {
                        StringBuffer nextLineToDraw = new StringBuffer();
                        float lengthIfUsingNextWord = 0.0f;
                        do {
                            nextLineToDraw.append(lineWords[lineIndex]);
                            nextLineToDraw.append(" ");
                            if (++lineIndex >= lineWords.length) continue;
                            String lineWithNextWord = nextLineToDraw.toString() + lineWords[lineIndex];
                            lengthIfUsingNextWord = this.getFont().getStringWidth(lineWithNextWord) / 1000.0f * (float)this.getFontSize();
                        } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                        if (y < 40.0f) {
                            if (pageLimit > 0 && pageCount++ >= pageLimit) {
                                pageLimits.getAction().throwIOExceptionIfRequired("Page limit (" + pageLimit + ") reached.", TextToPdfContentTransformer.this.transformerDebug);
                                break block2;
                            }
                            page = new PDPage();
                            doc.addPage(page);
                            if (contentStream != null) {
                                contentStream.endText();
                                contentStream.close();
                            }
                            contentStream = new PDPageContentStream(doc, page);
                            contentStream.setFont((PDFont)this.getFont(), (float)this.getFontSize());
                            contentStream.beginText();
                            y = page.getMediaBox().getHeight() - 40.0f + height;
                            contentStream.moveTextPositionByAmount(40.0f, y);
                        }
                        if (contentStream == null) {
                            throw new IOException("Error:Expected non-null content stream.");
                        }
                        contentStream.moveTextPositionByAmount(0.0f, -height);
                        y -= height;
                        contentStream.drawString(nextLineToDraw.toString());
                    }
                }
                if (textIsEmpty) {
                    doc.addPage(page);
                }
                if (contentStream != null) {
                    contentStream.endText();
                    contentStream.close();
                }
            }
            catch (IOException io) {
                if (doc != null) {
                    doc.close();
                }
                throw io;
            }
            return doc;
        }
    }
}

