/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Properties;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerConfigDynamicTransformers;
import org.alfresco.repo.content.transform.TransformerConfigLimits;
import org.alfresco.repo.content.transform.TransformerConfigProperty;
import org.alfresco.repo.content.transform.TransformerConfigStatistics;
import org.alfresco.repo.content.transform.TransformerConfigSupported;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerDebugLog;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyGetter;
import org.alfresco.repo.content.transform.TransformerPropertySetter;
import org.alfresco.repo.content.transform.TransformerStatistics;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class TransformerConfigImpl
extends AbstractLifecycleBean
implements TransformerConfig {
    private MimetypeService mimetypeService;
    private ContentService contentService;
    private ContentTransformerRegistry transformerRegistry;
    private TransformerDebug transformerDebug;
    private TransformerLog transformerLog;
    private TransformerDebugLog transformerDebugLog;
    private TransformerConfigStatistics statistics;
    private TransformerConfigLimits limits;
    private TransformerConfigSupported supported;
    private TransformerConfigProperty priorities;
    private TransformerConfigProperty thresholdCounts;
    private TransformerConfigProperty errorTimes;
    private TransformerConfigProperty initialAverageTimes;
    private TransformerConfigProperty initialCounts;
    private TransformerPropertySetter propertySetter;
    private ChildApplicationContextFactory subsystemFactory;
    private Properties globalProperties;
    private TransformerProperties transformerProperties;
    private TransformerConfigDynamicTransformers dynamicTransformers;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setContentTransformerRegistry(ContentTransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setTransformerLog(TransformerLog transformerLog) {
        this.transformerLog = transformerLog;
    }

    public void setTransformerDebugLog(TransformerDebugLog transformerDebugLog) {
        this.transformerDebugLog = transformerDebugLog;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void initialise() {
        ChildApplicationContextFactory subsystem = this.getSubsystem();
        this.transformerProperties = new TransformerProperties(subsystem, this.globalProperties);
        this.dynamicTransformers = new TransformerConfigDynamicTransformers(this, this.transformerProperties, this.mimetypeService, this.contentService, this.transformerRegistry, this.transformerDebug);
        this.statistics = new TransformerConfigStatistics(this, this.mimetypeService);
        this.limits = new TransformerConfigLimits(this.transformerProperties, this.mimetypeService);
        this.supported = new TransformerConfigSupported(this.transformerProperties, this.mimetypeService);
        this.priorities = new TransformerConfigProperty(this.transformerProperties, this.mimetypeService, ".priority", Integer.toString(100));
        this.thresholdCounts = new TransformerConfigProperty(this.transformerProperties, this.mimetypeService, ".thresholdCount", "3");
        this.errorTimes = new TransformerConfigProperty(this.transformerProperties, this.mimetypeService, ".errorTime", "120000");
        this.initialAverageTimes = new TransformerConfigProperty(this.transformerProperties, this.mimetypeService, ".time", "0");
        this.initialCounts = new TransformerConfigProperty(this.transformerProperties, this.mimetypeService, ".count", "100000");
        this.propertySetter = new TransformerPropertySetter(this.transformerProperties, this.mimetypeService, this.transformerRegistry);
    }

    synchronized ChildApplicationContextFactory getSubsystem() {
        if (this.subsystemFactory == null) {
            this.subsystemFactory = (ChildApplicationContextFactory)this.getApplicationContext().getBean("Transformers", ChildApplicationContextFactory.class);
        }
        return this.subsystemFactory;
    }

    protected void onBootstrap(ApplicationEvent event) {
    }

    protected void onShutdown(ApplicationEvent event) {
        this.dynamicTransformers.removeTransformers(this.transformerRegistry);
    }

    @Override
    public String getProperty(String name) {
        return this.transformerProperties.getProperty(name);
    }

    @Override
    public String getProperties(boolean changesOnly) {
        return new TransformerPropertyGetter(changesOnly, this.transformerProperties, this.mimetypeService, this.transformerRegistry, this.transformerLog, this.transformerDebugLog).toString();
    }

    @Override
    public int setProperties(String propertyNamesAndValues) {
        return this.propertySetter.setProperties(propertyNamesAndValues);
    }

    @Override
    public int removeProperties(String propertyNames) {
        return this.propertySetter.removeProperties(propertyNames);
    }

    @Override
    public TransformerStatistics getStatistics(ContentTransformer transformer, String sourceMimetype, String targetMimetype, boolean createNew) {
        return this.statistics.getStatistics(transformer, sourceMimetype, targetMimetype, createNew);
    }

    @Override
    public TransformationOptionLimits getLimits(ContentTransformer transformer, String sourceMimetype, String targetMimetype, String use) {
        return this.limits.getLimits(transformer, sourceMimetype, targetMimetype, use);
    }

    @Override
    public boolean isSupportedTransformation(ContentTransformer transformer, String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.supported.isSupportedTransformation(transformer, sourceMimetype, targetMimetype, options);
    }

    @Override
    public int getPriority(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        try {
            return this.priorities.getInt(transformer, sourceMimetype, targetMimetype);
        }
        catch (NumberFormatException e1) {
            try {
                return this.priorities.getInt(null, null, null);
            }
            catch (NumberFormatException e2) {
                return 0;
            }
        }
    }

    @Override
    public int getThresholdCount(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        try {
            return this.thresholdCounts.getInt(transformer, sourceMimetype, targetMimetype);
        }
        catch (NumberFormatException e1) {
            try {
                return this.thresholdCounts.getInt(null, null, null);
            }
            catch (NumberFormatException e2) {
                return 0;
            }
        }
    }

    long getErrorTime(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        try {
            return this.errorTimes.getLong(transformer, sourceMimetype, targetMimetype);
        }
        catch (NumberFormatException e1) {
            try {
                return this.errorTimes.getInt(null, null, null);
            }
            catch (NumberFormatException e2) {
                return 0L;
            }
        }
    }

    long getInitialAverageTime(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        try {
            return this.initialAverageTimes.getLong(transformer, sourceMimetype, targetMimetype);
        }
        catch (NumberFormatException e1) {
            try {
                return this.initialAverageTimes.getInt(null, null, null);
            }
            catch (NumberFormatException e2) {
                return 0L;
            }
        }
    }

    int getInitialCount(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        try {
            return this.initialCounts.getInt(transformer, sourceMimetype, targetMimetype);
        }
        catch (NumberFormatException e1) {
            try {
                return this.initialCounts.getInt(null, null, null);
            }
            catch (NumberFormatException e2) {
                return 0;
            }
        }
    }
}

