/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.DoubleMap;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixKey;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerConfigLimits
extends TransformerPropertyNameExtractor {
    private static Log logger = LogFactory.getLog(TransformerConfigLimits.class);
    private Map<String, Map<String, DoubleMap<String, String, TransformationOptionLimits>>> limitsMap;
    private Set<String> uses;

    public TransformerConfigLimits(TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        this.setLimits(transformerProperties, mimetypeService);
    }

    private void setLimits(TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        this.limitsMap = new ConcurrentHashMap<String, Map<String, DoubleMap<String, String, TransformationOptionLimits>>>();
        this.uses = new HashSet<String>();
        Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> allUseMap = this.getTransformerSourceTargetValuesMap(TransformerConfig.LIMIT_SUFFIXES, true, true, true, transformerProperties, mimetypeService);
        this.uses.add("*");
        for (TransformerSourceTargetSuffixValue property : allUseMap.values()) {
            String propertyUse = property.use == null ? "*" : property.use;
            this.uses.add(propertyUse);
        }
        for (String use : this.uses) {
            TransformationOptionLimits limits = this.getOrCreateTransformerOptionLimits("transformer.default", "*", "*", use);
            Collection<TransformerSourceTargetSuffixValue> properties = this.getPropertiesForUse(use, allUseMap);
            for (int pass = 0; pass <= 3; ++pass) {
                for (TransformerSourceTargetSuffixValue property : properties) {
                    int origLevel = this.getLevel(property.transformerName, property.sourceMimetype);
                    if (pass != origLevel) continue;
                    String transformerName = property.transformerName == null ? "transformer.default" : property.transformerName;
                    limits = this.getOrCreateTransformerOptionLimits(transformerName, property.sourceMimetype, property.targetMimetype, use);
                    this.setTransformationLimitsFromProperties(limits, property.value, property.suffix);
                    this.debug("V", transformerName, property.sourceMimetype, property.targetMimetype, use, limits);
                }
            }
        }
    }

    private Collection<TransformerSourceTargetSuffixValue> getPropertiesForUse(String use, Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> allUseMap) {
        ArrayList<TransformerSourceTargetSuffixValue> properties = new ArrayList<TransformerSourceTargetSuffixValue>();
        for (TransformerSourceTargetSuffixValue property : allUseMap.values()) {
            String propertyUse;
            String string = propertyUse = property.use == null ? "*" : property.use;
            if (propertyUse.equals(use)) {
                properties.add(property);
                continue;
            }
            if (!propertyUse.equals("*") || this.getProperty(property.transformerName, property.sourceExt, property.targetExt, property.suffix, use, allUseMap) != null) continue;
            properties.add(property);
        }
        return properties;
    }

    private TransformationOptionLimits getOrCreateTransformerOptionLimits(String transformerName, String sourceMimetype, String targetMimetype, String use) {
        TransformationOptionLimits limits;
        DoubleMap<String, String, TransformationOptionLimits> mimetypeLimits;
        Map<String, DoubleMap<String, String, TransformationOptionLimits>> transformerLimits = this.limitsMap.get(use);
        if (transformerLimits == null) {
            transformerLimits = new ConcurrentHashMap<String, DoubleMap<String, String, TransformationOptionLimits>>();
            this.limitsMap.put(use, transformerLimits);
        }
        if ((mimetypeLimits = transformerLimits.get(transformerName)) == null) {
            mimetypeLimits = new DoubleMap("*", "*");
            transformerLimits.put(transformerName, mimetypeLimits);
        }
        if ((limits = mimetypeLimits.getNoWildcards(sourceMimetype, targetMimetype)) == null) {
            limits = mimetypeLimits.get(sourceMimetype, targetMimetype);
            limits = this.newTransformationOptionLimits(transformerName, sourceMimetype, targetMimetype, limits, use);
            mimetypeLimits.put(sourceMimetype, targetMimetype, limits);
        } else {
            this.debug("G", transformerName, sourceMimetype, targetMimetype, use, limits);
        }
        return limits;
    }

    private TransformationOptionLimits newTransformationOptionLimits(String transformerName, String sourceMimetype, String targetMimetype, TransformationOptionLimits wildCardLimits, String use) {
        int origLevel = this.getLevel(transformerName, sourceMimetype);
        TransformationOptionLimits limits = new TransformationOptionLimits();
        for (int level = 0; level < origLevel; ++level) {
            TransformationOptionLimits defaultLimits = level < 2 ? (level == 0 ? this.getOrCreateTransformerOptionLimits("transformer.default", "*", "*", use) : this.getOrCreateTransformerOptionLimits("transformer.default", sourceMimetype, targetMimetype, use)) : (level == 2 ? this.getOrCreateTransformerOptionLimits(transformerName, "*", "*", use) : this.getOrCreateTransformerOptionLimits(transformerName, sourceMimetype, targetMimetype, use));
            defaultLimits.defaultTo(limits);
        }
        if (wildCardLimits != null) {
            wildCardLimits.defaultTo(limits);
        }
        this.debug("N", transformerName, sourceMimetype, targetMimetype, use, limits);
        return limits;
    }

    private int getLevel(String transformerName, String sourceMimetype) {
        boolean defaultMimetypes;
        boolean bl = defaultMimetypes = sourceMimetype == null || sourceMimetype.equals("*");
        int level = transformerName == null || "transformer.default".equals(transformerName) ? (defaultMimetypes ? 0 : 1) : (defaultMimetypes ? 2 : 3);
        return level;
    }

    private void setTransformationLimitsFromProperties(TransformationOptionLimits limits, String value, String suffix) {
        long l = Long.parseLong(value);
        if (suffix == ".maxSourceSizeKBytes") {
            limits.setReadLimitKBytes(-1L);
            limits.setMaxSourceSizeKBytes(l);
        } else if (suffix == ".timeoutMs") {
            limits.setReadLimitTimeMs(-1L);
            limits.setTimeoutMs(l);
        } else if (suffix == ".maxPages") {
            limits.setPageLimit(-1);
            limits.setMaxPages((int)l);
        } else if (suffix == ".readLimitKBytes") {
            limits.setMaxSourceSizeKBytes(-1L);
            limits.setReadLimitKBytes(l);
        } else if (suffix == ".readLimitTimeMs") {
            limits.setTimeoutMs(-1L);
            limits.setReadLimitTimeMs(l);
        } else {
            limits.setMaxPages(-1);
            limits.setPageLimit((int)l);
        }
    }

    private void debug(String msg, String transformerName, String sourceMimetype, String targetMimetype, String use, TransformationOptionLimits limits) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("");
            if (msg != null) {
                int x;
                sb.append(x);
                sb.append(' ');
                sb.append(msg);
                for (x = this.getLevel(transformerName, sourceMimetype); x > -1; --x) {
                    sb.append(' ');
                }
                sb.append(transformerName);
                sb.append('.');
                sb.append(sourceMimetype);
                sb.append('.');
                sb.append(targetMimetype);
                sb.append('.');
                sb.append(use);
                sb.append('=');
                sb.append(limits.getMaxSourceSizeKBytes());
            }
            String line = sb.toString();
            logger.debug((Object)line);
        }
    }

    public TransformationOptionLimits getLimits(ContentTransformer transformer, String sourceMimetype, String targetMimetype, String use) {
        String transformerName;
        String string = transformerName = transformer == null ? "transformer.default" : transformer.getName();
        if (sourceMimetype == null) {
            sourceMimetype = "*";
        }
        if (targetMimetype == null) {
            targetMimetype = "*";
        }
        if (use == null) {
            use = "*";
        }
        this.debug(null, transformerName, sourceMimetype, targetMimetype, use, null);
        String searchUse = this.uses.contains(use) ? use : "*";
        TransformationOptionLimits limits = this.getOrCreateTransformerOptionLimits(transformerName, sourceMimetype, targetMimetype, searchUse);
        this.debug("S", transformerName, sourceMimetype, targetMimetype, use, limits);
        return limits;
    }
}

