/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.LogEntries;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerConfigMBean;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerStatistics;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerConfigMBeanImpl
implements TransformerConfigMBean {
    private static final String NO_TRANSFORMATIONS_TO_REPORT = "No transformations to report";
    private ContentTransformerRegistry transformerRegistry;
    private TransformerDebug transformerDebug;
    private TransformerConfig transformerConfig;
    private MimetypeService mimetypeService;
    private LogEntries transformerLog;
    private LogEntries transformerDebugLog;

    public void setContentTransformerRegistry(ContentTransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setTransformerLog(LogEntries transformerLog) {
        this.transformerLog = transformerLog;
    }

    public void setTransformerDebugLog(LogEntries transformerDebugLog) {
        this.transformerDebugLog = transformerDebugLog;
    }

    @Override
    public String[] getTransformerNames() {
        ArrayList<String> transformerNames = new ArrayList<String>();
        Collection<ContentTransformer> transformers = this.transformerDebug.sortTransformersByName(null);
        for (ContentTransformer transformer : transformers) {
            String name = transformer.getName();
            name = name.startsWith("transformer.") ? name.substring("transformer.".length()) : name;
            transformerNames.add(name);
        }
        return transformerNames.toArray(new String[transformerNames.size()]);
    }

    @Override
    public String[] getExtensionsAndMimetypes() {
        ArrayList<String> extensionsAndMimetypes = new ArrayList<String>();
        for (String mimetype : this.mimetypeService.getMimetypes(null)) {
            String extension = this.mimetypeService.getExtension(mimetype);
            extensionsAndMimetypes.add(extension + " - " + mimetype);
        }
        return extensionsAndMimetypes.toArray(new String[extensionsAndMimetypes.size()]);
    }

    @Override
    public String getTransformationsByTransformer(String simpleTransformerName, String use) {
        use = this.nullDefaultParam(use);
        try {
            return "41".equals(simpleTransformerName) ? this.transformerDebug.transformationsByTransformer(null, true, false, use) : this.transformerDebug.transformationsByTransformer(this.getTransformerNameParam(simpleTransformerName), true, true, use);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String getTransformationsByExtension(String sourceExtension, String targetExtension, String use) {
        use = this.nullDefaultParam(use);
        try {
            if ("41".equals(sourceExtension)) {
                return this.transformerDebug.transformationsByExtension(null, null, true, false, false, null);
            }
            boolean onlyNonDeterministic = false;
            if (sourceExtension != null && sourceExtension.startsWith("00")) {
                onlyNonDeterministic = true;
                sourceExtension = sourceExtension.substring(2);
            }
            return this.transformerDebug.transformationsByExtension(this.nullDefaultLowerParam(sourceExtension), this.nullDefaultLowerParam(targetExtension), true, true, onlyNonDeterministic, use);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String getTransformationStatistics(String simpleTransformerName, String sourceExtension, String targetExtension) {
        try {
            boolean includeSystemWideSummary;
            StringBuilder sb = new StringBuilder();
            String transformerName = this.getTransformerNameParam(simpleTransformerName);
            sourceExtension = this.nullDefaultLowerParam(sourceExtension);
            targetExtension = this.nullDefaultLowerParam(targetExtension);
            Collection<ContentTransformer> transformers = this.transformerDebug.sortTransformersByName(transformerName);
            Collection<String> sourceMimetypes = this.transformerDebug.getSourceMimetypes(sourceExtension);
            Collection<String> targetMimetypes = this.transformerDebug.getTargetMimetypes(sourceExtension, targetExtension, sourceMimetypes);
            boolean bl = includeSystemWideSummary = transformerName == null;
            if (includeSystemWideSummary) {
                this.getTransformationStatistics(sourceExtension, targetExtension, sb, null, sourceMimetypes, targetMimetypes, false);
            }
            for (ContentTransformer transformer : transformers) {
                this.getTransformationStatistics(sourceExtension, targetExtension, sb, transformer, sourceMimetypes, targetMimetypes, includeSystemWideSummary);
            }
            if (sb.length() == 0) {
                sb.append(NO_TRANSFORMATIONS_TO_REPORT);
            }
            return sb.toString();
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    private void getTransformationStatistics(String sourceExtension, String targetExtension, StringBuilder sb, ContentTransformer transformer, Collection<String> sourceMimetypes, Collection<String> targetMimetypes, boolean includeSystemWideSummary) {
        AtomicInteger counter = new AtomicInteger(0);
        int i = sb.length();
        for (String sourceMimetype : sourceMimetypes) {
            for (String targetMimetype : targetMimetypes) {
                this.getTransformationStatistics(sb, transformer, sourceMimetype, targetMimetype, counter, includeSystemWideSummary);
            }
        }
        if (sourceExtension == null && targetExtension == null && counter.get() > 1) {
            StringBuilder sb2 = new StringBuilder();
            this.getTransformationStatistics(sb2, transformer, null, null, counter, includeSystemWideSummary);
            sb2.append('\n');
            sb.insert(i == 0 ? 0 : i + 2, sb2);
        }
    }

    private void getTransformationStatistics(StringBuilder sb, ContentTransformer transformer, String sourceMimetype, String targetMimetype, AtomicInteger counter, boolean includeSystemWideSummary) {
        long count;
        TransformerStatistics statistics = this.transformerConfig.getStatistics(transformer, sourceMimetype, targetMimetype, false);
        if (statistics != null && (count = statistics.getCount()) > 0L) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (counter.incrementAndGet() == 1 && includeSystemWideSummary) {
                sb.append('\n');
            }
            sb.append(statistics.getTransformerName());
            sb.append(' ');
            sb.append(statistics.getSourceExt());
            sb.append(' ');
            sb.append(statistics.getTargetExt());
            sb.append(" count=");
            sb.append(count);
            sb.append(" errors=");
            sb.append(statistics.getErrorCount());
            sb.append(" averageTime=");
            sb.append(statistics.getAverageTime());
            sb.append(" ms");
        }
    }

    @Override
    public String[] getTransformationLog(int n) {
        String[] stringArray;
        String[] entries = this.transformerLog.getEntries(n);
        if (entries.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = NO_TRANSFORMATIONS_TO_REPORT;
        } else {
            stringArray = entries;
        }
        return stringArray;
    }

    @Override
    public String[] getTransformationDebugLog(int n) {
        String[] stringArray;
        String[] entries = this.transformerDebugLog.getEntries(n);
        if (entries.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = NO_TRANSFORMATIONS_TO_REPORT;
        } else {
            stringArray = entries;
        }
        return stringArray;
    }

    @Override
    public String getProperties(boolean listAll) {
        return this.transformerConfig.getProperties(!listAll);
    }

    @Override
    public String setProperties(String propertyNamesAndValues) {
        try {
            String nullPropertyNamesAndValues = this.nullDefaultParam(propertyNamesAndValues);
            int n = nullPropertyNamesAndValues == null ? 0 : this.transformerConfig.setProperties(nullPropertyNamesAndValues);
            return "Properties added or changed: " + n;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String removeProperties(String propertyNames) {
        try {
            propertyNames = this.nullDefaultParam(propertyNames);
            return "Properties removed: " + (propertyNames == null ? 0 : this.transformerConfig.removeProperties(propertyNames));
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String testTransform(String simpleTransformerName, String sourceExtension, String targetExtension, String use) {
        use = this.nullDefaultParam(use);
        try {
            String transformerName = this.getTransformerNameParam(simpleTransformerName);
            return transformerName == null ? this.transformerDebug.testTransform(sourceExtension, targetExtension, use) : this.transformerDebug.testTransform(transformerName, sourceExtension, targetExtension, use);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @Override
    public String[] getContextNames() {
        return new String[]{"", "doclib", "index", "webpreview", "syncRule", "asyncRule"};
    }

    @Override
    public String[] getCustomePropertyNames() {
        String[] lines;
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String line : lines = this.getProperties(false).split("\\n")) {
            int i;
            if (line.isEmpty() || line.startsWith("#") || line.indexOf(" # default=") != -1 || (i = line.indexOf(61)) == 0) continue;
            String propertyName = line.substring(0, i);
            propertyNames.add(propertyName);
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    @Override
    public String[] getTestFileExtensionsAndMimetypes() {
        return this.transformerDebug.getTestFileExtensionsAndMimetypes();
    }

    private String getTransformerNameParam(String simpleTransformerName) {
        String transformerName = (simpleTransformerName = this.nullDefaultParam(simpleTransformerName)) == null ? null : (simpleTransformerName.startsWith("transformer.") ? simpleTransformerName : "transformer." + simpleTransformerName);
        this.transformerRegistry.getTransformer(transformerName);
        return transformerName;
    }

    private String nullDefaultLowerParam(String parameter) {
        if ((parameter = this.nullDefaultParam(parameter)) != null) {
            parameter = parameter.toLowerCase();
        }
        return parameter;
    }

    private String nullDefaultParam(String parameter) {
        if ("String".equals(parameter) || "".equals(parameter) || parameter == null) {
            parameter = null;
        }
        return parameter;
    }

    @Override
    public String help() {
        return "getProperties(listAll)\n   Lists all transformer properties that are set.\n   - listAll if true, list both default and custom values, otherwise includes\n     only custom values\n\nsetProperties(propertyNamesAndValues)\n   Adds or replaces transformer properties.\n   - propertyNamesAndValues to be set. May include comments but these are removed.\n     To clear a custom values, set its value back to the default.\n     To remove a custom property use removeProperties(...)\n\ngetTransformationDebugLog(n)\n   Lists the latest entries in the transformation debug log.\n   - n the number of entries to include. If blank all available entries are listed\n\ngetTransformationLog(n)\n   Lists the latest entries in the transformation log.\n   - n the number of entries to include. If blank all available entries are listed\n\ngetTransformationStatistics(transformerName, sourceExtension, targetExtension)\n   Lists the transformation statistics for the current node.\n   - transformerName to be checked. If blank all transformers are included\n   - sourceExtension to be checked. If blank all source mimetypes are included\n   - targetExtension to be checked. If blank all target mimetypes are included\n\ngetExtensionsAndMimetypes()\n   Lists all configured mimetypes and the primary file extension\n\ngetTransformerNames()\n   Lists the names of all top level transformers\n\ntestTransform(transformerName, sourceExtension, targetExtension, use)\n   Transforms a small test file from one mimetype to another and then shows the \n   debug of the transform, which would indicate if it was successful or even if \n   it was possible.\n   - transformerName to be used. If blank the ContentService is used to select one.\n   - sourceExtension used to identify the mimetype\n   - targetExtension used to identify the mimetype\n   - use or context in which to test the transformation (\"doclib\",\n     \"index\", \"webpreview\", \"syncRule\", \"asyncRule\"...) or blank for\n     the default.\n\nremoveProperties(String propertyNames)\n   Removes transformer properties.\n   - propertyNames to be removed. May include =<value> after the property name.\n     The value is ignored. Only custom properties should be removed.\n\ngetTransformationsByExtension(sourceExtension, targetExtension, use)\n   Lists all possible transformations sorted by source and then target mimetype\n   extension.\n   - sourceExtension to be checked. If blank all source mimetypes are included\n   - targetExtension to be checked. If blank all target mimetypes are included.\n   - use or context in which the transformation will be used (\"doclib\",\n     \"index\", \"webpreview\", \"syncRule\", \"asyncRule\"...) or blank for\n     the default.\n\ngetTransformationsByTransformer(transformerName, use)\n   Lists all possible transformations sorted by Transformer name\n   - transformerName to be checked. If blank all transformers are included\n   - use or context in which the transformation will be used (\"doclib\",\n     \"index\", \"webpreview\", \"syncRule\", \"asyncRule\"...) or blank for\n     the default.\n\ngetCustomePropertyNames()\n   Lists custom (non default) property names\n\ngetContextNames()\n   Lists the names of the contexts or uses\n\ngetTestFileExtensionsAndMimetypes()\n   Lists the extensions of available test files";
    }
}

