/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.DoubleMap;
import org.alfresco.repo.content.transform.TransformerConfigImpl;
import org.alfresco.repo.content.transform.TransformerStatistics;
import org.alfresco.repo.content.transform.TransformerStatisticsImpl;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerConfigStatistics {
    private TransformerConfigImpl transformerConfigImpl;
    private MimetypeService mimetypeService;
    private Map<String, DoubleMap<String, String, TransformerStatistics>> statistics = new HashMap<String, DoubleMap<String, String, TransformerStatistics>>();

    public TransformerConfigStatistics(TransformerConfigImpl transformerConfigImpl, MimetypeService mimetypeService) {
        this.transformerConfigImpl = transformerConfigImpl;
        this.mimetypeService = mimetypeService;
    }

    public TransformerStatistics getStatistics(ContentTransformer transformer, String sourceMimetype, String targetMimetype, boolean createNew) {
        TransformerStatistics transformerStatistics;
        if (sourceMimetype == null) {
            sourceMimetype = "*";
        }
        if (targetMimetype == null) {
            targetMimetype = "*";
        }
        String name = transformer == null ? "SUMMARY" : transformer.getName();
        DoubleMap<String, String, TransformerStatistics> mimetypeStatistics = this.statistics.get(name);
        if (!createNew) {
            TransformerStatistics transformerStatistics2 = mimetypeStatistics == null ? null : mimetypeStatistics.getNoWildcards(sourceMimetype, targetMimetype);
            return transformerStatistics2;
        }
        if (mimetypeStatistics == null) {
            mimetypeStatistics = new DoubleMap("*", "*");
            this.statistics.put(name, mimetypeStatistics);
            transformerStatistics = this.newTransformerStatistics(transformer, "*", "*", null);
            mimetypeStatistics.put("*", "*", transformerStatistics);
        }
        if ("*".equals(sourceMimetype) && "*".equals(targetMimetype)) {
            transformerStatistics = mimetypeStatistics.get("*", "*");
        } else {
            transformerStatistics = mimetypeStatistics.get(sourceMimetype, targetMimetype);
            if (transformerStatistics == null || transformerStatistics.isSummary()) {
                transformerStatistics = this.newTransformerStatistics(transformer, sourceMimetype, targetMimetype, mimetypeStatistics.get("*", "*"));
                mimetypeStatistics.put(sourceMimetype, targetMimetype, transformerStatistics);
            }
        }
        return transformerStatistics;
    }

    private TransformerStatistics newTransformerStatistics(ContentTransformer transformer, String sourceMimetype, String targetMimetype, TransformerStatistics parent) {
        long initialAverageTime = this.transformerConfigImpl.getInitialAverageTime(transformer, sourceMimetype, targetMimetype);
        long initialCount = initialAverageTime <= 0L ? 0L : (long)this.transformerConfigImpl.getInitialCount(transformer, sourceMimetype, targetMimetype);
        long errorTime = this.transformerConfigImpl.getErrorTime(transformer, sourceMimetype, targetMimetype);
        TransformerStatisticsImpl transformerStatistics = new TransformerStatisticsImpl(this.mimetypeService, sourceMimetype, targetMimetype, transformer, parent, errorTime, initialAverageTime, initialCount);
        return transformerStatistics;
    }
}

