/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.DoubleMap;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class TransformerConfigSupported
extends TransformerPropertyNameExtractor {
    private Map<String, SupportedAndUnsupportedTransformations> supported;

    public TransformerConfigSupported(TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        this.setSupported(transformerProperties, mimetypeService);
    }

    private void setSupported(TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        this.supported = new HashMap<String, SupportedAndUnsupportedTransformations>();
        Collection<TransformerSourceTargetSuffixValue> properties = this.getTransformerSourceTargetValues(Collections.singletonList(".supported"), false, false, transformerProperties, mimetypeService);
        for (TransformerSourceTargetSuffixValue property : properties) {
            SupportedAndUnsupportedTransformations supportedBytransformer = this.supported.get(property.transformerName);
            if (supportedBytransformer == null) {
                supportedBytransformer = new SupportedAndUnsupportedTransformations();
                this.supported.put(property.transformerName, supportedBytransformer);
            }
            boolean supported = property.value == null || property.value.equalsIgnoreCase("true");
            supportedBytransformer.put(property.sourceMimetype, property.targetMimetype, supported);
        }
    }

    public boolean isSupportedTransformation(ContentTransformer transformer, String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (sourceMimetype == null) {
            sourceMimetype = "*";
        }
        if (targetMimetype == null) {
            targetMimetype = "*";
        }
        boolean isSupported = true;
        String name = transformer.getName();
        SupportedAndUnsupportedTransformations supportedBytransformer = this.supported.get(name);
        if (supportedBytransformer != null) {
            isSupported = supportedBytransformer.isSupported(sourceMimetype, targetMimetype);
        }
        return isSupported;
    }

    private class SupportedAndUnsupportedTransformations {
        DoubleMap<String, String, Boolean> supportedTransformations;
        boolean supportedSet = false;

        SupportedAndUnsupportedTransformations() {
        }

        public void put(String sourceMimetype, String targetMimetype, boolean supported) {
            if (this.supportedTransformations == null) {
                this.supportedTransformations = new DoubleMap("*", "*");
                if (supported) {
                    this.supportedSet = true;
                }
            }
            this.supportedTransformations.put(sourceMimetype, targetMimetype, supported);
        }

        boolean isSupported(String sourceMimetype, String targetMimetype) {
            Boolean sup;
            boolean isSupported;
            boolean bl = isSupported = !this.supportedSet;
            if (this.supportedTransformations != null && (sup = this.supportedTransformations.get(sourceMimetype, targetMimetype)) != null) {
                isSupported = sup;
            }
            return isSupported;
        }
    }
}

