/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.FailoverContentTransformer;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerWorker;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.LogTee;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ResourceUtils;

public class TransformerDebug {
    private static final String FINISHED_IN = "Finished in ";
    private static final String NO_TRANSFORMERS = "No transformers";
    private final Log logger;
    private final Log info;
    private final NodeService nodeService;
    private final MimetypeService mimetypeService;
    private final ContentTransformerRegistry transformerRegistry;
    private final TransformerConfig transformerConfig;
    private ContentService contentService;

    public TransformerDebug(NodeService nodeService, MimetypeService mimetypeService, ContentTransformerRegistry transformerRegistry, TransformerConfig transformerConfig, Log transformerLog, Log transformerDebugLog) {
        this.nodeService = nodeService;
        this.mimetypeService = mimetypeService;
        this.transformerRegistry = transformerRegistry;
        this.transformerConfig = transformerConfig;
        this.logger = new LogTee(LogFactory.getLog(TransformerDebug.class), transformerDebugLog);
        this.info = new LogTee(LogFactory.getLog(TransformerLog.class), transformerLog);
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void pushAvailable(String fromUrl, String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (this.isEnabled()) {
            this.push(null, fromUrl, sourceMimetype, targetMimetype, -1L, options, Call.AVAILABLE);
        }
    }

    public void pushTransform(ContentTransformer transformer, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options) {
        if (this.isEnabled()) {
            this.push(this.getName(transformer), fromUrl, sourceMimetype, targetMimetype, sourceSize, options, Call.TRANSFORM);
        }
    }

    public void pushMisc() {
        if (this.isEnabled()) {
            this.push(null, null, null, null, -1L, null, Call.AVAILABLE);
        }
    }

    public void pushIsTransformableSize(ContentTransformer transformer) {
        if (this.isEnabled()) {
            ThreadInfo.getIsTransformableStack().push(this.getName(transformer));
        }
    }

    private void push(String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options, Call callType) {
        Deque<Frame> ourStack = ThreadInfo.getStack();
        Frame frame = ourStack.peek();
        if (callType == Call.TRANSFORM && frame != null && frame.callType == Call.AVAILABLE) {
            frame.setTransformerName(transformerName);
            frame.setSourceSize(sourceSize);
            frame.callType = Call.AVAILABLE_AND_TRANSFORM;
        }
        boolean origDebugOutput = ThreadInfo.setDebugOutput(ThreadInfo.getDebugOutput() && sourceSize != 0L);
        frame = new Frame(frame, transformerName, fromUrl, sourceMimetype, targetMimetype, sourceSize, options, callType, origDebugOutput);
        ourStack.push(frame);
        if (callType == Call.TRANSFORM) {
            this.logBasicDetails(frame, sourceSize, options.getUse(), transformerName, ourStack.size() == 1);
        }
    }

    public void unavailableTransformer(ContentTransformer transformer, String sourceMimetype, String targetMimetype, long maxSourceSizeKBytes) {
        Deque<Frame> ourStack;
        Frame frame;
        if (this.isEnabled() && (frame = (ourStack = ThreadInfo.getStack()).peek()) != null) {
            boolean debug;
            Deque<String> isTransformableStack = ThreadInfo.getIsTransformableStack();
            String name = !isTransformableStack.isEmpty() ? isTransformableStack.getFirst() : this.getName(transformer);
            boolean bl = debug = maxSourceSizeKBytes != 0L;
            if (frame.unavailableTransformers == null) {
                frame.unavailableTransformers = new HashSet();
            }
            String priority = this.gePriority(transformer, sourceMimetype, targetMimetype);
            frame.unavailableTransformers.add(new UnavailableTransformer(name, priority, maxSourceSizeKBytes, debug));
        }
    }

    public void availableTransformers(List<ContentTransformer> transformers, long sourceSize, TransformationOptions options, String calledFrom) {
        if (this.isEnabled()) {
            boolean firstLevel;
            Deque<Frame> ourStack = ThreadInfo.getStack();
            Frame frame = ourStack.peek();
            boolean bl = firstLevel = ourStack.size() == 1;
            if (transformers.size() == 0) {
                frame.setFailureReason(NO_TRANSFORMERS);
                if (frame.unavailableTransformers != null && frame.unavailableTransformers.size() != 0) {
                    ThreadInfo.setDebugOutput(true);
                }
            }
            frame.setSourceSize(sourceSize);
            this.logBasicDetails(frame, sourceSize, options.getUse(), calledFrom + (transformers.size() == 0 ? " NO transformers" : ""), firstLevel);
            char c = 'a';
            int longestNameLength = this.getLongestTransformerNameLength(transformers, frame);
            for (ContentTransformer trans : transformers) {
                String name = this.getName(trans);
                int padName = longestNameLength - name.length() + 1;
                long maxSourceSizeKBytes = trans.getMaxSourceSizeKBytes(frame.sourceMimetype, frame.targetMimetype, frame.options);
                String size = maxSourceSizeKBytes > 0L ? "< " + this.fileSize(maxSourceSizeKBytes * 1024L) : "";
                int padSize = 10 - size.length();
                String priority = this.gePriority(trans, frame.sourceMimetype, frame.targetMimetype);
                String string = c == 'a' ? "**" : "  ";
                char c2 = c;
                c = (char)(c + '\u0001');
                this.log(string + c2 + ") " + priority + ' ' + name + this.spaces(padName) + size + this.spaces(padSize) + this.ms(trans.getTransformationTime(frame.sourceMimetype, frame.targetMimetype)));
            }
            if (frame.unavailableTransformers != null) {
                for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                    int pad = longestNameLength - unavailable.name.length();
                    String reason = "> " + this.fileSize(unavailable.maxSourceSizeKBytes * 1024L);
                    if (!unavailable.debug && !this.logger.isTraceEnabled()) continue;
                    char c3 = c;
                    c = (char)(c + 1);
                    this.log("--" + c3 + ") " + unavailable.priority + ' ' + unavailable.name + this.spaces(pad + 1) + reason, unavailable.debug);
                }
            }
        }
    }

    private String gePriority(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        String priority = '[' + (this.isComponentTransformer(transformer) ? "---" : Integer.toString(this.transformerConfig.getPriority(transformer, sourceMimetype, targetMimetype))) + ']';
        priority = this.spaces(5 - priority.length()) + priority;
        return priority;
    }

    public void inactiveTransformer(ContentTransformer transformer) {
        this.log(this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime(null, null)) + " INACTIVE");
    }

    public void activeTransformer(int mimetypePairCount, ContentTransformer transformer, String sourceMimetype, String targetMimetype, long maxSourceSizeKBytes, boolean firstMimetypePair) {
        if (firstMimetypePair) {
            this.log(this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime(sourceMimetype, targetMimetype)));
        }
        String i = Integer.toString(mimetypePairCount);
        String priority = this.gePriority(transformer, sourceMimetype, targetMimetype);
        this.log(this.spaces(5 - i.length()) + mimetypePairCount + ") " + this.getMimetypeExt(sourceMimetype) + this.getMimetypeExt(targetMimetype) + priority + ' ' + this.fileSize(maxSourceSizeKBytes > 0L ? maxSourceSizeKBytes * 1024L : maxSourceSizeKBytes) + (maxSourceSizeKBytes == 0L ? " disabled" : ""));
    }

    public void activeTransformer(String sourceMimetype, String targetMimetype, int transformerCount, ContentTransformer transformer, long maxSourceSizeKBytes, boolean firstTransformer) {
        String mimetypes = firstTransformer ? this.getMimetypeExt(sourceMimetype) + this.getMimetypeExt(targetMimetype) : this.spaces(10);
        char c = (char)(97 + transformerCount);
        String priority = this.gePriority(transformer, sourceMimetype, targetMimetype);
        this.log(mimetypes + "  " + c + ") " + priority + ' ' + this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime(sourceMimetype, targetMimetype)) + ' ' + this.fileSize(maxSourceSizeKBytes > 0L ? maxSourceSizeKBytes * 1024L : maxSourceSizeKBytes) + (maxSourceSizeKBytes == 0L ? " disabled" : ""));
    }

    private int getLongestTransformerNameLength(List<ContentTransformer> transformers, Frame frame) {
        int length;
        int longestNameLength = 0;
        for (ContentTransformer trans : transformers) {
            length = this.getName(trans).length();
            if (longestNameLength >= length) continue;
            longestNameLength = length;
        }
        if (frame != null && frame.unavailableTransformers != null) {
            for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                length = unavailable.name.length();
                if (longestNameLength >= length) continue;
                longestNameLength = length;
            }
        }
        return longestNameLength;
    }

    private void logBasicDetails(Frame frame, long sourceSize, String use, String message, boolean firstLevel) {
        if (frame.fromUrl != null && (firstLevel || frame.id != 1)) {
            this.log(frame.fromUrl, false);
        }
        this.log(frame.sourceMimetype + ' ' + frame.targetMimetype, false);
        String fileName = this.getFileName(frame.options, firstLevel, sourceSize);
        this.log(this.getMimetypeExt(frame.sourceMimetype) + this.getMimetypeExt(frame.targetMimetype) + (fileName != null ? fileName + ' ' : "") + (sourceSize >= 0L ? this.fileSize(sourceSize) + ' ' : "") + (firstLevel && use != null ? "-- " + use + " -- " : "") + message);
    }

    public void popAvailable() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, false);
        }
    }

    public void popTransform() {
        if (this.isEnabled()) {
            this.pop(Call.TRANSFORM, false);
        }
    }

    public void popMisc() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, ThreadInfo.getStack().size() > 1);
        }
    }

    public void popIsTransformableSize() {
        if (this.isEnabled()) {
            ThreadInfo.getIsTransformableStack().pop();
        }
    }

    private void pop(Call callType, boolean suppressFinish) {
        Frame frame;
        Deque<Frame> ourStack = ThreadInfo.getStack();
        if (!ourStack.isEmpty() && ((frame = ourStack.peek()).callType == callType || frame.callType == Call.AVAILABLE_AND_TRANSFORM && callType == Call.AVAILABLE)) {
            boolean firstLevel;
            int size = ourStack.size();
            String ms = this.ms(System.currentTimeMillis() - frame.start);
            this.logInfo(frame, size, ms);
            boolean bl = firstLevel = size == 1;
            if (!suppressFinish && (firstLevel || this.logger.isTraceEnabled())) {
                this.log(FINISHED_IN + ms + (frame.callType == Call.AVAILABLE ? " Transformer NOT called" : "") + (firstLevel ? "\n" : ""), firstLevel);
            }
            TransformerDebug.setDebugOutput(frame.origDebugOutput);
            ourStack.pop();
        }
    }

    private void logInfo(Frame frame, int size, String ms) {
        if (this.info.isDebugEnabled()) {
            String failureReason = frame.getFailureReason();
            boolean firstLevel = size == 1;
            String sourceExt = this.getMimetypeExt(frame.sourceMimetype);
            String targetExt = this.getMimetypeExt(frame.targetMimetype);
            String fileName = this.getFileName(frame.options, firstLevel, frame.sourceSize);
            long sourceSize = frame.getSourceSize();
            String transformerName = frame.getTransformerName();
            String level = null;
            boolean debug = false;
            if (NO_TRANSFORMERS.equals(failureReason)) {
                debug = firstLevel;
                level = "INFO";
                failureReason = NO_TRANSFORMERS;
                if ((debug || this.info.isTraceEnabled()) && frame.unavailableTransformers != null) {
                    level = "WARN";
                    long smallestMaxSourceSizeKBytes = Long.MAX_VALUE;
                    for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                        if (smallestMaxSourceSizeKBytes <= unavailable.maxSourceSizeKBytes || unavailable.maxSourceSizeKBytes <= 0L) continue;
                        smallestMaxSourceSizeKBytes = unavailable.maxSourceSizeKBytes;
                    }
                    smallestMaxSourceSizeKBytes = smallestMaxSourceSizeKBytes == Long.MAX_VALUE ? 0L : smallestMaxSourceSizeKBytes;
                    failureReason = "No transformers as file is > " + this.fileSize(smallestMaxSourceSizeKBytes * 1024L);
                }
            } else if (frame.callType == Call.TRANSFORM) {
                level = failureReason == null || failureReason.length() == 0 ? "INFO" : "ERROR";
                boolean bl = debug = size == 1 || size == 2 && ThreadInfo.getStack().peekLast().callType != Call.TRANSFORM;
            }
            if (level != null) {
                this.infoLog(this.getReference(debug, false), sourceExt, targetExt, level, fileName, sourceSize, transformerName, failureReason, ms, debug);
            }
        }
    }

    private void infoLog(String reference, String sourceExt, String targetExt, String level, String fileName, long sourceSize, String transformerName, String failureReason, String ms, boolean debug) {
        String message = reference + sourceExt + targetExt + (level == null ? "" : level + ' ') + (fileName == null ? "" : fileName) + (sourceSize >= 0L ? ' ' + this.fileSize(sourceSize) : "") + ' ' + ms + (transformerName == null ? "" : ' ' + transformerName) + (failureReason == null ? "" : ' ' + failureReason.trim());
        if (debug) {
            this.info.debug((Object)message);
        } else {
            this.info.trace((Object)message);
        }
    }

    public boolean isEnabled() {
        return this.logger.isDebugEnabled() || this.info.isDebugEnabled() || ThreadInfo.getStringBuilder() != null;
    }

    public static boolean setDebugOutput(boolean debugOutput) {
        return ThreadInfo.setDebugOutput(debugOutput);
    }

    public void debug(String message) {
        if (this.isEnabled() && message != null) {
            this.log(message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isEnabled()) {
            String msg = t.getMessage();
            if (msg != null) {
                int i = msg.indexOf(": \n");
                if (i != -1) {
                    msg = msg.substring(0, i);
                }
                this.log(message + ' ' + msg);
            } else {
                this.log(message);
            }
            Deque<Frame> ourStack = ThreadInfo.getStack();
            if (!ourStack.isEmpty()) {
                Frame frame = ourStack.peek();
                frame.setFailureReason(message + ' ' + this.getRootCauseMessage(t));
            }
        }
    }

    private String getRootCauseMessage(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            t = cause;
            cause = t.getCause();
        }
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.getClass().getSimpleName();
        }
        return message;
    }

    private void log(String message) {
        this.log(message, true);
    }

    private void log(String message, boolean debug) {
        this.log(message, null, debug);
    }

    private void log(String message, Throwable t, boolean debug) {
        StringBuilder sb;
        if (debug && ThreadInfo.getDebugOutput() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getReference(false, false) + message), t);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getReference(false, false) + message), t);
        }
        if (debug && (sb = ThreadInfo.getStringBuilder()) != null) {
            sb.append(this.getReference(false, true));
            sb.append(message);
            if (t != null) {
                sb.append(t.getMessage());
            }
            sb.append('\n');
        }
    }

    public <T extends Throwable> T setCause(T t) {
        return t;
    }

    public StringBuilder getStringBuilder() {
        return ThreadInfo.getStringBuilder();
    }

    public void setStringBuilder(StringBuilder sb) {
        ThreadInfo.setStringBuilder(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformationsByTransformer(String transformerName, boolean toString, boolean format42, String use) {
        if (this.getStringBuilder() != null) {
            return null;
        }
        Collection<ContentTransformer> transformers = format42 || transformerName != null ? this.sortTransformersByName(transformerName) : this.transformerRegistry.getTransformers();
        List sourceMimetypes = format42 ? this.getSourceMimetypes(null) : this.mimetypeService.getMimetypes();
        List targetMimetypes = format42 ? sourceMimetypes : this.mimetypeService.getMimetypes();
        TransformationOptions options = new TransformationOptions();
        options.setUse(use);
        StringBuilder sb = null;
        try {
            if (toString) {
                sb = new StringBuilder();
                this.setStringBuilder(sb);
            }
            this.pushMisc();
            for (ContentTransformer transformer : transformers) {
                try {
                    this.pushMisc();
                    int mimetypePairCount = 0;
                    boolean first = true;
                    for (String sourceMimetype : sourceMimetypes) {
                        for (String targetMimetype : targetMimetypes) {
                            if (!transformer.isTransformable(sourceMimetype, -1L, targetMimetype, options)) continue;
                            long maxSourceSizeKBytes = transformer.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
                            this.activeTransformer(++mimetypePairCount, transformer, sourceMimetype, targetMimetype, maxSourceSizeKBytes, first);
                            first = false;
                        }
                    }
                    if (!first) continue;
                    this.inactiveTransformer(transformer);
                }
                finally {
                    this.popMisc();
                }
            }
        }
        finally {
            this.popMisc();
            this.setStringBuilder(null);
        }
        this.stripFinishedLine(sb);
        return this.stripLeadingNumber(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformationsByExtension(String sourceExtension, String targetExtension, boolean toString, boolean format42, boolean onlyNonDeterministic, String use) {
        if (this.getStringBuilder() != null) {
            return null;
        }
        List<ContentTransformer> transformers = format42 && !onlyNonDeterministic ? this.sortTransformersByName(null) : this.transformerRegistry.getTransformers();
        List sourceMimetypes = format42 || sourceExtension != null ? this.getSourceMimetypes(sourceExtension) : this.mimetypeService.getMimetypes();
        Collection<Object> targetMimetypes = format42 || targetExtension != null ? this.getTargetMimetypes(sourceExtension, targetExtension, sourceMimetypes) : this.mimetypeService.getMimetypes();
        TransformationOptions options = new TransformationOptions();
        options.setUse(use);
        StringBuilder sb = null;
        try {
            if (toString) {
                sb = new StringBuilder();
                this.setStringBuilder(sb);
            }
            this.pushMisc();
            for (String sourceMimetype : sourceMimetypes) {
                for (String string : targetMimetypes) {
                    int priority;
                    ArrayList<ContentTransformer> availableTransformer = new ArrayList<ContentTransformer>();
                    for (ContentTransformer transformer : transformers) {
                        if (!transformer.isTransformable(sourceMimetype, -1L, string, options)) continue;
                        availableTransformer.add(transformer);
                    }
                    final String currSourceMimetype = sourceExtension;
                    final String currTargetMimetype = targetExtension;
                    Collections.sort(availableTransformer, new Comparator<ContentTransformer>(){

                        @Override
                        public int compare(ContentTransformer transformer1, ContentTransformer transformer2) {
                            return TransformerDebug.this.transformerConfig.getPriority(transformer1, currSourceMimetype, currTargetMimetype) - TransformerDebug.this.transformerConfig.getPriority(transformer2, currSourceMimetype, currTargetMimetype);
                        }
                    });
                    int size = availableTransformer.size();
                    int n = priority = size >= 2 ? this.transformerConfig.getPriority((ContentTransformer)availableTransformer.get(0), sourceMimetype, string) : -1;
                    if (onlyNonDeterministic && (size < 2 || priority != this.transformerConfig.getPriority((ContentTransformer)availableTransformer.get(1), sourceMimetype, string))) continue;
                    try {
                        this.pushMisc();
                        int transformerCount = 0;
                        for (ContentTransformer transformer : availableTransformer) {
                            if (onlyNonDeterministic && transformerCount >= 2 && priority != this.transformerConfig.getPriority(transformer, sourceMimetype, string)) continue;
                            long maxSourceSizeKBytes = transformer.getMaxSourceSizeKBytes(sourceMimetype, string, options);
                            this.activeTransformer(sourceMimetype, string, transformerCount, transformer, maxSourceSizeKBytes, transformerCount++ == 0);
                        }
                    }
                    finally {
                        this.popMisc();
                    }
                }
            }
        }
        finally {
            this.popMisc();
            this.setStringBuilder(null);
        }
        this.stripFinishedLine(sb);
        return this.stripLeadingNumber(sb);
    }

    private void stripFinishedLine(StringBuilder sb) {
        int i;
        if (sb != null && (i = sb.lastIndexOf(FINISHED_IN)) != -1) {
            sb.setLength(i);
            i = sb.lastIndexOf("\n", i);
            sb.setLength(i != -1 ? i : 0);
        }
    }

    private String stripLeadingNumber(StringBuilder sb) {
        return sb == null ? null : Pattern.compile("^\\d+\\.", 8).matcher(sb).replaceAll("");
    }

    public Collection<String> getSourceMimetypes(String sourceExtension) {
        Collection sourceMimetypes = this.mimetypeService.getMimetypes(sourceExtension);
        if (sourceMimetypes.isEmpty()) {
            throw new IllegalArgumentException("Unknown source extension " + sourceExtension);
        }
        return sourceMimetypes;
    }

    public Collection<String> getTargetMimetypes(String sourceExtension, String targetExtension, Collection<String> sourceMimetypes) {
        Collection targetMimetypes;
        Collection collection = targetMimetypes = targetExtension == null && sourceExtension == null || targetExtension != null && targetExtension.equals(sourceExtension) ? sourceMimetypes : this.mimetypeService.getMimetypes(targetExtension);
        if (targetMimetypes.isEmpty()) {
            throw new IllegalArgumentException("Unknown target extension " + targetExtension);
        }
        return targetMimetypes;
    }

    private String getReference(boolean firstLevelOnly, boolean overrideFirstLevel) {
        StringBuilder sb = new StringBuilder("");
        Frame frame = null;
        Iterator<Frame> iterator = ThreadInfo.getStack().descendingIterator();
        int lengthOfFirstId = 0;
        boolean firstLevel = true;
        while (iterator.hasNext()) {
            frame = iterator.next();
            if (firstLevel) {
                if (!overrideFirstLevel) {
                    sb.append(frame.getId());
                } else {
                    sb.append("1");
                }
                lengthOfFirstId = sb.length();
                if (firstLevelOnly) {
                    break;
                }
            } else {
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(frame.getId());
            }
            firstLevel = false;
        }
        if (frame != null) {
            if (firstLevelOnly) {
                sb.append(' ');
            } else {
                sb.append(this.spaces(13 - sb.length() + lengthOfFirstId));
            }
        }
        return sb.toString();
    }

    private String getName(ContentTransformer transformer) {
        String name;
        String string = name = transformer instanceof ContentTransformerHelper ? ContentTransformerHelper.getSimpleName(transformer) : transformer.getClass().getSimpleName();
        String type = transformer instanceof ComplexContentTransformer ? "Complex" : (transformer instanceof FailoverContentTransformer ? "Failover" : (transformer instanceof ProxyContentTransformer ? (((ProxyContentTransformer)transformer).getWorker() instanceof RuntimeExecutableContentTransformerWorker ? "Runtime" : "Proxy") : ""));
        boolean componentTransformer = this.isComponentTransformer(transformer);
        StringBuilder sb = new StringBuilder(name);
        if (componentTransformer || type.length() > 0) {
            sb.append("<<");
            sb.append(type);
            if (componentTransformer) {
                sb.append("Component");
            }
            sb.append(">>");
        }
        return sb.toString();
    }

    private boolean isComponentTransformer(ContentTransformer transformer) {
        return !this.transformerRegistry.getTransformers().contains(transformer);
    }

    public String getFileName(TransformationOptions options, boolean firstLevel, long sourceSize) {
        String fileName = null;
        if (options != null) {
            try {
                NodeRef sourceNodeRef = options.getSourceNodeRef();
                fileName = (String)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (fileName == null) {
            if (!firstLevel) {
                fileName = "<<TemporaryFile>>";
            } else if (sourceSize < 0L) {
                // empty if block
            }
        }
        return fileName;
    }

    private String getMimetypeExt(String mimetype) {
        StringBuilder sb = new StringBuilder("");
        if (this.mimetypeService == null) {
            sb.append(mimetype);
        } else {
            String mimetypeExt = this.mimetypeService.getExtension(mimetype);
            sb.append(mimetypeExt);
            sb.append(this.spaces(4 - mimetypeExt.length()));
        }
        sb.append(' ');
        return sb.toString();
    }

    private String spaces(int i) {
        StringBuilder sb = new StringBuilder("");
        while (--i >= 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String ms(long time) {
        return String.format("%,d ms", time);
    }

    public String fileSize(long size) {
        if (size < 0L) {
            return "unlimited";
        }
        if (size == 1L) {
            return "1 byte";
        }
        String[] units = new String[]{"bytes", "KB", "MB", "GB", "TB"};
        long divider = 1L;
        for (int i = 0; i < units.length - 1; ++i) {
            long nextDivider = divider * 1024L;
            if (size < nextDivider) {
                return this.fileSizeFormat(size, divider, units[i]);
            }
            divider = nextDivider;
        }
        return this.fileSizeFormat(size, divider, units[units.length - 1]);
    }

    private String fileSizeFormat(long size, long divider, String unit) {
        size = size * 10L / divider;
        int decimalPoint = (int)size % 10;
        StringBuilder sb = new StringBuilder();
        sb.append(size / 10L);
        if (decimalPoint != 0) {
            sb.append(".");
            sb.append(decimalPoint);
        }
        sb.append(' ');
        sb.append(unit);
        return sb.toString();
    }

    public Collection<ContentTransformer> sortTransformersByName(String transformerName) {
        List<ContentTransformer> transformers = transformerName != null ? Collections.singleton(this.transformerRegistry.getTransformer(transformerName)) : this.transformerRegistry.getAllTransformers();
        TreeMap<String, ContentTransformer> map = new TreeMap<String, ContentTransformer>();
        for (ContentTransformer transformer : transformers) {
            String name = transformer.getName();
            map.put(name, transformer);
        }
        Collection<ContentTransformer> sorted = map.values();
        return sorted;
    }

    public String testTransform(String sourceExtension, String targetExtension, String use) {
        return new TestTransform(){

            @Override
            protected void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) {
                TransformerDebug.this.contentService.transform(reader, writer, options);
            }
        }.run(sourceExtension, targetExtension, use);
    }

    public String testTransform(final String transformerName, String sourceExtension, String targetExtension, String use) {
        final ContentTransformer transformer = this.transformerRegistry.getTransformer(transformerName);
        return new TestTransform(){

            @Override
            protected String isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
                return transformer.isTransformable(sourceMimetype, sourceSize, targetMimetype, options) ? null : transformerName + " does not support this transformation.";
            }

            @Override
            protected void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) {
                transformer.transform(reader, writer, options);
            }
        }.run(sourceExtension, targetExtension, use);
    }

    public String[] getTestFileExtensionsAndMimetypes() {
        ArrayList<String> sourceExtensions = new ArrayList<String>();
        Collection sourceMimetypes = this.mimetypeService.getMimetypes(null);
        for (String sourceMimetype : sourceMimetypes) {
            String sourceExtension = this.mimetypeService.getExtension(sourceMimetype);
            if (this.loadQuickTestFile(sourceExtension) == null) continue;
            sourceExtensions.add(sourceExtension + " - " + sourceMimetype);
        }
        return sourceExtensions.toArray(new String[sourceExtensions.size()]);
    }

    private File loadQuickTestFile(String extension) {
        try {
            URL url = this.getClass().getClassLoader().getResource("quick/quick." + extension);
            if (url == null) {
                return null;
            }
            return ResourceUtils.getFile((URL)url);
        }
        catch (IOException e) {
            return null;
        }
    }

    private abstract class TestTransform {
        private TestTransform() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String run(String sourceExtension, String targetExtension, String use) {
            String targetMimetype = this.getMimetype(targetExtension, false);
            String sourceMimetype = this.getMimetype(sourceExtension, true);
            File sourceFile = TransformerDebug.this.loadQuickTestFile(sourceExtension);
            if (sourceFile == null) {
                throw new IllegalArgumentException("There is no test file with a " + sourceExtension + " extension.");
            }
            FileContentReader reader = new FileContentReader(sourceFile);
            reader.setMimetype(sourceMimetype);
            File tempFile = TempFileProvider.createTempFile((String)("TestTransform_" + sourceExtension + "_"), (String)("." + targetExtension));
            FileContentWriter writer = new FileContentWriter(tempFile);
            writer.setMimetype(targetMimetype);
            long sourceSize = reader.getSize();
            TransformationOptions options = new TransformationOptions();
            options.setUse(use);
            String debug = this.isTransformable(sourceMimetype, sourceSize, targetMimetype, options);
            if (debug == null) {
                StringBuilder sb = new StringBuilder();
                try {
                    TransformerDebug.this.setStringBuilder(sb);
                    this.transform(reader, writer, options);
                }
                catch (AlfrescoRuntimeException e) {
                    sb.append(e.getMessage());
                }
                finally {
                    TransformerDebug.this.setStringBuilder(null);
                }
                debug = sb.toString();
            }
            return debug;
        }

        private String getMimetype(String extension, boolean isSource) {
            Iterator iterator;
            String mimetype = null;
            if (extension != null && (iterator = TransformerDebug.this.mimetypeService.getMimetypes(extension).iterator()).hasNext()) {
                mimetype = (String)iterator.next();
            }
            if (mimetype == null) {
                throw new IllegalArgumentException("Unknown " + (isSource ? "source" : "target") + " extension: " + extension);
            }
            return mimetype;
        }

        protected String isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
            return null;
        }

        protected abstract void transform(ContentReader var1, ContentWriter var2, TransformationOptions var3);
    }

    private class UnavailableTransformer {
        private final String name;
        private final String priority;
        private final long maxSourceSizeKBytes;
        private final transient boolean debug;

        UnavailableTransformer(String name, String priority, long maxSourceSizeKBytes, boolean debug) {
            this.name = name;
            this.priority = priority;
            this.maxSourceSizeKBytes = maxSourceSizeKBytes;
            this.debug = debug;
        }

        public int hashCode() {
            int hashCode = 37 * this.name.hashCode();
            hashCode = (int)((long)hashCode + 37L * this.maxSourceSizeKBytes);
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UnavailableTransformer) {
                UnavailableTransformer that = (UnavailableTransformer)obj;
                return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name) && this.maxSourceSizeKBytes == that.maxSourceSizeKBytes;
            }
            return false;
        }
    }

    private static class Frame {
        private static final AtomicInteger uniqueId = new AtomicInteger(0);
        private int id = -1;
        private final String fromUrl;
        private final String sourceMimetype;
        private final String targetMimetype;
        private final TransformationOptions options;
        private final boolean origDebugOutput;
        private final long start;
        private Call callType;
        private Frame parent;
        private int childId;
        private Set<UnavailableTransformer> unavailableTransformers;
        private String failureReason;
        private long sourceSize;
        private String transformerName;

        private Frame(Frame parent, String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options, Call pushCall, boolean origDebugOutput) {
            this.parent = parent;
            this.fromUrl = fromUrl;
            this.transformerName = transformerName;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.sourceSize = sourceSize;
            this.options = options;
            this.callType = pushCall;
            this.origDebugOutput = origDebugOutput;
            this.start = System.currentTimeMillis();
        }

        private int getId() {
            if (this.id == -1) {
                this.id = this.parent == null ? uniqueId.getAndIncrement() : (this.parent.childId = this.parent.childId + 1);
            }
            return this.id;
        }

        private void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        private String getFailureReason() {
            return this.failureReason;
        }

        private void setSourceSize(long sourceSize) {
            this.sourceSize = sourceSize;
        }

        public long getSourceSize() {
            return this.sourceSize;
        }

        private void setTransformerName(String transformerName) {
            this.transformerName = transformerName;
        }

        public String getTransformerName() {
            return this.transformerName;
        }
    }

    private static class ThreadInfo {
        private static final ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            protected ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };
        private final Deque<Frame> stack = new ArrayDeque<Frame>();
        private final Deque<String> isTransformableStack = new ArrayDeque<String>();
        private boolean debugOutput = true;
        private StringBuilder sb;

        private ThreadInfo() {
        }

        public static Deque<Frame> getStack() {
            return ThreadInfo.threadInfo.get().stack;
        }

        public static boolean getDebugOutput() {
            return ThreadInfo.threadInfo.get().debugOutput;
        }

        public static Deque<String> getIsTransformableStack() {
            return ThreadInfo.threadInfo.get().isTransformableStack;
        }

        public static boolean setDebugOutput(boolean debugOutput) {
            ThreadInfo thisThreadInfo = threadInfo.get();
            boolean orig = thisThreadInfo.debugOutput;
            thisThreadInfo.debugOutput = debugOutput;
            return orig;
        }

        public static StringBuilder getStringBuilder() {
            return ThreadInfo.threadInfo.get().sb;
        }

        public static void setStringBuilder(StringBuilder sb) {
            ThreadInfo.threadInfo.get().sb = sb;
        }
    }

    private static enum Call {
        AVAILABLE,
        TRANSFORM,
        AVAILABLE_AND_TRANSFORM;

    }
}

