/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.Pair;

public class TransformerPropertySetter {
    private static final Pattern LINE_SPLIT = Pattern.compile("^(.*)$", 8);
    private static final Pattern COMMENT = Pattern.compile("(^\\s+)|(\\s*#.*)|(\\s+$)");
    private static Pattern NEWLINE_CORRECTION = Pattern.compile("([^#]\\s*) ((content\\.transformer\\.)|(transformer\\.))");
    private static final Pattern INTEGER = Pattern.compile("^-?\\d+$");
    private final TransformerProperties transformerProperties;
    private final MimetypeService mimetypeService;
    private final ContentTransformerRegistry transformerRegistry;

    public TransformerPropertySetter(TransformerProperties transformerProperties, MimetypeService mimetypeService, ContentTransformerRegistry transformerRegistry) {
        this.transformerProperties = transformerProperties;
        this.mimetypeService = mimetypeService;
        this.transformerRegistry = transformerRegistry;
    }

    public int setProperties(String propertyNamesAndValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> transformerReferences = new HashMap<String, String>();
        HashSet<String> dynamicTransformerNames = new HashSet<String>();
        for (String propertyNameAndValue : this.extractProperties(propertyNamesAndValues, true, transformerReferences, dynamicTransformerNames)) {
            Pair<String, String> pair = this.splitNameAndValue(propertyNameAndValue);
            String propertyName = (String)pair.getFirst();
            String value = (String)pair.getSecond();
            if (map.containsKey(propertyName)) {
                throw new IllegalArgumentException(propertyName + " has been specified more than once");
            }
            if (value.equals(this.transformerProperties.getProperty(propertyName))) continue;
            map.put(propertyName, value);
        }
        this.checkTransformerReferences(transformerReferences, dynamicTransformerNames);
        int size = map.size();
        if (size > 0) {
            this.transformerProperties.setProperties(map);
        }
        return size;
    }

    private void checkTransformerReferences(Map<String, String> transformerReferences, Set<String> dynamicTransformerNames) throws IllegalArgumentException {
        String name;
        HashSet<String> allTransformerNames = new HashSet<String>(dynamicTransformerNames);
        for (ContentTransformer transformer : this.transformerRegistry.getAllTransformers()) {
            name = transformer.getName();
            allTransformerNames.add(name);
        }
        allTransformerNames.add("transformer.default");
        for (String transformerSimpleName : transformerReferences.keySet()) {
            if ("*".equals(transformerSimpleName) || allTransformerNames.contains(name = "transformer." + transformerSimpleName)) continue;
            String line = transformerReferences.get(transformerSimpleName);
            throw this.unexpectedProperty("Transformer " + transformerSimpleName + " does not exist", line);
        }
    }

    public int removeProperties(String propertyNames) {
        HashSet<String> remove = new HashSet<String>();
        HashMap<String, String> transformerReferences = new HashMap<String, String>();
        HashSet<String> dynamicTransformerNames = new HashSet<String>();
        Properties defaultProperties = this.transformerProperties.getDefaultProperties();
        for (String propertyNameAndValue : this.extractProperties(propertyNames, false, transformerReferences, dynamicTransformerNames)) {
            Pair<String, String> pair = this.splitNameAndValue(propertyNameAndValue);
            String propertyName = (String)pair.getFirst();
            if (this.transformerProperties.getProperty(propertyName) == null) {
                throw this.unexpectedProperty("Does not exist", propertyName);
            }
            if (defaultProperties.getProperty(propertyName) != null) {
                throw this.unexpectedProperty("Is a deafult property so may not be removed", propertyName);
            }
            remove.add(propertyName);
        }
        this.transformerProperties.removeProperties(remove);
        return remove.size();
    }

    private List<String> extractProperties(String text, boolean hasValue, Map<String, String> transformerReferences, Set<String> dynamicTransformerNames) {
        ArrayList<String> properties = new ArrayList<String>();
        text = this.fixJConsolesMissingNewlines(text);
        Matcher lineMatcher = LINE_SPLIT.matcher(text);
        while (lineMatcher.find()) {
            String line = lineMatcher.group();
            Matcher commentMatcher = COMMENT.matcher(line);
            if ((line = commentMatcher.replaceAll("")).length() == 0) continue;
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("content.transformer.")) {
                this.checkTransformerProperty(hasValue, line, transformerReferences, dynamicTransformerNames);
                properties.add(line);
                continue;
            }
            if (lowerLine.startsWith("transformer.debug.entries")) {
                this.checkInteger(hasValue, line, "transformer.debug.entries".length());
                properties.add(line);
                continue;
            }
            if (lowerLine.startsWith("transformer.log.entries")) {
                this.checkInteger(hasValue, line, "transformer.log.entries".length());
                properties.add(line);
                continue;
            }
            throw this.unexpectedProperty("Not a transformer property", line);
        }
        return properties;
    }

    String fixJConsolesMissingNewlines(String text) {
        Matcher newlineMatcher = NEWLINE_CORRECTION.matcher(text);
        text = newlineMatcher.replaceAll("$1\n$2");
        return text;
    }

    private void checkTransformerProperty(boolean hasValue, String line, Map<String, String> transformerReferences, Set<String> dynamicTransformerNames) {
        int j = line.indexOf(61);
        String propertyName = j != -1 ? line.substring(0, j) : line;
        TransformerPropertyNameExtractor extractor = new TransformerPropertyNameExtractor(){};
        boolean validPropertyName = false;
        String transformerName = null;
        String suffix = null;
        String separator = null;
        block0: for (String aSuffix : TransformerConfig.ALL_SUFFIXES) {
            if (!propertyName.endsWith(aSuffix)) continue;
            transformerName = propertyName.substring("content.".length(), propertyName.length() - aSuffix.length());
            suffix = aSuffix;
            boolean separatorMatch = false;
            for (String aSeparator : TransformerConfig.SEPARATORS) {
                int i = transformerName.lastIndexOf(aSeparator);
                if (i == -1) continue;
                separatorMatch = true;
                String extensions = transformerName.substring(i + aSeparator.length());
                String[] ext = extractor.splitExt(extensions);
                if (ext.length != 2) continue;
                String firstExpression = ext[0];
                String secondExpression = ext[1];
                if (aSeparator == ".extensions.") {
                    if (extractor.getMatchingExtensionsFromExtensions(firstExpression, this.mimetypeService).size() == 0) {
                        throw this.unexpectedProperty("Invalid source extension " + firstExpression, line);
                    }
                    if (extractor.getMatchingExtensionsFromExtensions(secondExpression, this.mimetypeService).size() == 0) {
                        throw this.unexpectedProperty("Invalid target extension " + secondExpression, line);
                    }
                } else {
                    if (extractor.getMatchingExtensionsFromMimetypes(firstExpression, this.mimetypeService).size() == 0) {
                        throw this.unexpectedProperty("Invalid source mimetype " + firstExpression, line);
                    }
                    if (extractor.getMatchingExtensionsFromMimetypes(secondExpression, this.mimetypeService).size() == 0) {
                        throw this.unexpectedProperty("Invalid target mimetype " + secondExpression, line);
                    }
                }
                transformerName = transformerName.substring(0, i);
                separator = aSeparator;
                validPropertyName = true;
                break block0;
            }
            separator = null;
            if (separatorMatch) continue;
            validPropertyName = true;
            break;
        }
        if (!validPropertyName) {
            throw this.unexpectedProperty("Possible typo in the property name", line);
        }
        this.checkTransformerPropertyValue(hasValue, line, j, transformerName, separator, suffix, transformerReferences, dynamicTransformerNames);
    }

    private void checkTransformerPropertyValue(boolean hasValue, String line, int i, String transformerName, String separator, String suffix, Map<String, String> transformerReferences, Set<String> dynamicTransformerNames) {
        if (".maxSourceSizeKBytes".equals(suffix) || ".timeoutMs".equals(suffix) || ".readLimitKBytes".equals(suffix) || ".readLimitTimeMs".equals(suffix) || ".count".equals(suffix) || ".time".equals(suffix) || ".errorTime".equals(suffix)) {
            this.checkLong(hasValue, line, i);
        } else if (".maxPages".equals(suffix) || ".pageLimit".equals(suffix) || ".thresholdCount".equals(suffix) || ".priority".equals(suffix)) {
            this.checkInteger(hasValue, line, i);
        } else if (".supported".equals(suffix) || ".available".equals(suffix)) {
            this.checkBoolean(hasValue, line, i);
        } else if (".pipeline".equals(suffix) || ".failover".equals(suffix)) {
            dynamicTransformerNames.add(transformerName);
            if (separator != null) {
                throw this.unexpectedProperty("Separator was not expected", line);
            }
            if (".pipeline".equals(suffix)) {
                this.checkPipelineValue(hasValue, line, i, transformerReferences);
            } else {
                this.checkFailoverValue(hasValue, line, i, transformerReferences);
            }
        }
    }

    private void checkInteger(boolean hasValue, String line, int i) {
        String value = this.checkValue(hasValue, line, i);
        if (value != null) {
            if (!INTEGER.matcher(value).find()) {
                throw this.unexpectedProperty("Expected an integer value", line);
            }
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw this.unexpectedProperty("Expected an int value", line);
            }
        }
    }

    private void checkLong(boolean hasValue, String line, int i) {
        String value = this.checkValue(hasValue, line, i);
        if (value != null) {
            if (!INTEGER.matcher(value).find()) {
                throw this.unexpectedProperty("Expected an integer value", line);
            }
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw this.unexpectedProperty("Expected a long value", line);
            }
        }
    }

    private void checkBoolean(boolean hasValue, String line, int i) {
        String value = this.checkValue(hasValue, line, i);
        if (value != null && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw this.unexpectedProperty("Expected true or false value", line);
        }
    }

    private void checkPipelineValue(boolean hasValue, String line, int i, Map<String, String> transformerReferences) {
        String value = this.checkValue(hasValue, line, i);
        if (value != null) {
            String[] transformerNamesAndExtensions = value.split("\\|");
            int count = transformerNamesAndExtensions.length;
            if (count < 2 || count % 2 == 0) {
                throw this.unexpectedProperty("Incomplete pipeline value", line);
            }
            for (int j = 0; j < count; ++j) {
                if (j % 2 == 0) {
                    if (transformerNamesAndExtensions[j].length() <= 0) continue;
                    transformerReferences.put(transformerNamesAndExtensions[j], line);
                    continue;
                }
                TransformerPropertyNameExtractor extractor = new TransformerPropertyNameExtractor(){};
                String extension = transformerNamesAndExtensions[j];
                if (extractor.getMatchingExtensionsFromExtensions(extension, this.mimetypeService).size() != 0) continue;
                throw this.unexpectedProperty("Invalid intermediate extension " + extension, line);
            }
        }
    }

    private void checkFailoverValue(boolean hasValue, String line, int i, Map<String, String> transformerReferences) {
        String value = this.checkValue(hasValue, line, i);
        if (value != null) {
            String[] transformerNames = value.split("\\|");
            int count = transformerNames.length;
            if (count < 2) {
                throw this.unexpectedProperty("Can't failover if there is only on transformer", line);
            }
            for (int j = 0; j < count; ++j) {
                if (transformerNames[j].length() <= 0) continue;
                transformerReferences.put(transformerNames[j], line);
            }
        }
    }

    private String checkValue(boolean hasValue, String line, int i) {
        int l = line.length();
        if (hasValue && (i == -1 || l <= i || line.charAt(i) != '=') || !hasValue && (l < i || i != -1 && l > i && line.charAt(i) != '=')) {
            throw this.unexpectedProperty("Expected a value after an '=' at char " + i, line);
        }
        return hasValue || i != -1 && l > i ? line.substring(i + 1) : null;
    }

    private IllegalArgumentException unexpectedProperty(String context, String line) throws IllegalArgumentException {
        return new IllegalArgumentException("Unexpected property: " + line + "    " + context);
    }

    Pair<String, String> splitNameAndValue(String propertyNameAndValue) {
        int i = propertyNameAndValue.indexOf(61);
        String name = i != -1 ? propertyNameAndValue.substring(0, i) : propertyNameAndValue;
        String value = i != -1 ? propertyNameAndValue.substring(i + 1) : "";
        Pair pair = new Pair((Object)name, (Object)value);
        return pair;
    }
}

