/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerSelector;
import org.alfresco.repo.content.transform.TransformerStatistics;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class TransformerSelectorImpl
implements TransformerSelector {
    private TransformerConfig transformerConfig;
    private ContentTransformerRegistry contentTransformerRegistry;

    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    public void setContentTransformerRegistry(ContentTransformerRegistry contentTransformerRegistry) {
        this.contentTransformerRegistry = contentTransformerRegistry;
    }

    @Override
    public List<ContentTransformer> selectTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.contentTransformerRegistry.getTransformers();
        List<TransformerSortData> possibleTransformers = this.findTransformers(transformers, sourceMimetype, sourceSize, targetMimetype, options);
        return this.sortTransformers(possibleTransformers);
    }

    private List<TransformerSortData> findTransformers(List<ContentTransformer> allTransformers, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        ArrayList<TransformerSortData> transformers = new ArrayList<TransformerSortData>(8);
        for (ContentTransformer transformer : allTransformers) {
            int priority = this.transformerConfig.getPriority(transformer, sourceMimetype, targetMimetype);
            if (priority <= 0 || !transformer.isTransformable(sourceMimetype, sourceSize, targetMimetype, options)) continue;
            transformers.add(new TransformerSortData(transformer, sourceMimetype, targetMimetype, priority));
        }
        return transformers;
    }

    private List<ContentTransformer> sortTransformers(List<TransformerSortData> possibleTransformers) {
        Collections.sort(possibleTransformers);
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(possibleTransformers.size());
        for (TransformerSortData possibleTransformer : possibleTransformers) {
            transformers.add(possibleTransformer.transformer);
        }
        return transformers;
    }

    private class TransformerSortData
    implements Comparable<TransformerSortData> {
        private final ContentTransformer transformer;
        private final int priority;
        private final long averageTime;
        private final long count;

        TransformerSortData(ContentTransformer transformer, String sourceMimetype, String targetMimetype, int priority) {
            this.transformer = transformer;
            this.priority = priority;
            TransformerStatistics stats = TransformerSelectorImpl.this.transformerConfig.getStatistics(transformer, sourceMimetype, targetMimetype, true);
            int threashold = TransformerSelectorImpl.this.transformerConfig.getThresholdCount(transformer, sourceMimetype, targetMimetype);
            this.count = stats.getCount();
            this.averageTime = this.count < (long)threashold ? 0L : stats.getAverageTime();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.averageTime ^ this.averageTime >>> 32);
            result = 31 * result + this.priority;
            return result;
        }

        public boolean equals(Object obj) {
            return this.transformer == ((TransformerSortData)obj).transformer;
        }

        @Override
        public int compareTo(TransformerSortData that) {
            int relativeInt = this.priority - that.priority;
            if (relativeInt != 0) {
                return relativeInt;
            }
            long relativeLong = this.averageTime - that.averageTime;
            int n = relativeLong > 0L ? 1 : (relativeInt = relativeLong < 0L ? -1 : 0);
            if (relativeInt != 0) {
                return relativeInt;
            }
            relativeLong = this.count - that.count;
            relativeInt = relativeLong > 0L ? 1 : (relativeLong < 0L ? -1 : 0);
            return relativeInt;
        }
    }
}

