/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.deployment.DeploymentReceiverTransport;

public class DeploymentClientOutputStream
extends OutputStream {
    private DeploymentReceiverTransport fTransport;
    private String fTicket;
    private String fOutputToken;
    private boolean open = true;

    public DeploymentClientOutputStream(DeploymentReceiverTransport transport, String ticket, String outputToken) {
        this.fTransport = transport;
        this.fTicket = ticket;
        this.fOutputToken = outputToken;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buff = new byte[]{(byte)b};
        this.write(buff);
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.fTransport.finishSend(this.fTicket, this.fOutputToken);
        }
        this.open = false;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fTransport.write(this.fTicket, this.fOutputToken, b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public String getTicket() {
        return this.fTicket;
    }

    public String getOutputToken() {
        return this.fOutputToken;
    }
}

