/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.activities.ibatis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityFeedQueryEntity;
import org.alfresco.repo.domain.activities.ibatis.ActivitiesDAOImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.util.Pair;
import org.apache.ibatis.session.RowBounds;

public class ActivityFeedDAOImpl
extends ActivitiesDAOImpl
implements ActivityFeedDAO {
    private static final int DEFAULT_FETCH_BATCH_SIZE = 150;
    private TenantService tenantService;
    private int fetchBatchSize = 150;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setFetchBatchSize(int fetchBatchSize) {
        this.fetchBatchSize = fetchBatchSize;
    }

    @Override
    public long insertFeedEntry(ActivityFeedEntity activityFeed) throws SQLException {
        this.template.insert("alfresco.activities.insert.insert_activity_feed", (Object)activityFeed);
        Long id = activityFeed.getId();
        return id != null ? id : -1L;
    }

    @Override
    public int deleteFeedEntries(Integer maxIdRange) throws SQLException {
        Long maxId = (Long)this.template.selectOne("alfresco.activities.select_activity_feed_entries_max_id");
        if (maxId == null) {
            return 0;
        }
        Long minId = maxId - (long)maxIdRange.intValue() + 1L;
        if (minId <= 0L) {
            return 0;
        }
        return this.template.delete("alfresco.activities.delete_activity_feed_entries_before_id", (Object)minId);
    }

    @Override
    public int deleteFeedEntries(Date keepDate) throws SQLException {
        return this.template.delete("alfresco.activities.delete_activity_feed_entries_older_than_date", (Object)keepDate);
    }

    @Override
    public int deleteSiteFeedEntries(String siteId) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_site_entries", (Object)params);
    }

    @Override
    public int deleteSiteFeedEntries(String siteId, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        params.setPostDate(keepDate);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_site_entries_older_than_date", (Object)params);
    }

    @Override
    public int deleteUserFeedEntries(String feedUserId, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        params.setPostDate(keepDate);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_feeduser_entries_older_than_date", (Object)params);
    }

    @Override
    public int deleteUserFeedEntries(String feedUserId) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        return this.template.delete("alfresco.activities.delete_activity_feed_for_feeduser_entries", (Object)params);
    }

    @Override
    public List<ActivityFeedEntity> selectUserFeedsToClean(int maxFeedSize) throws SQLException {
        return this.template.selectList("alfresco.activities.select_activity_user_feeds_greater_than_max", (Object)maxFeedSize);
    }

    @Override
    public Long countUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setFeedUserId(feedUserId);
        if (minFeedId > -1L) {
            params.setMinId(minFeedId);
        }
        if (siteId != null) {
            if (excludeThisUser && excludeOtherUsers) {
                return 0L;
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser_and_site", (Object)params);
            }
            if (excludeThisUser && !excludeOtherUsers) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser_others_and_site", (Object)params);
            }
            if (excludeOtherUsers && !excludeThisUser) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser_me_and_site", (Object)params);
            }
        } else {
            if (excludeThisUser && excludeOtherUsers) {
                return 0L;
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser", (Object)params);
            }
            if (excludeThisUser) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser_others", (Object)params);
            }
            if (excludeOtherUsers) {
                return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_feeduser_me", (Object)params);
            }
        }
        throw new AlfrescoRuntimeException("Unexpected: invalid arguments");
    }

    @Override
    public List<ActivityFeedEntity> selectSiteFeedsToClean(int maxFeedSize) throws SQLException {
        return this.template.selectList("alfresco.activities.select_activity_site_feeds_greater_than_max", (Object)maxFeedSize);
    }

    @Override
    public List<ActivityFeedEntity> selectUserFeedEntries(String feedUserId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setFeedUserId(feedUserId);
        if (minFeedId > -1L) {
            params.setMinId(minFeedId);
        }
        int rowLimit = maxFeedSize < 0 ? Integer.MAX_VALUE : maxFeedSize;
        RowBounds rowBounds = new RowBounds(0, rowLimit);
        if (siteId != null) {
            params.setSiteNetwork(siteId);
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select.select_activity_feed_for_feeduser_and_site", (Object)params, rowBounds);
            }
            if (excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_others_and_site", (Object)params, rowBounds);
            }
            if (excludeOtherUsers && !excludeThisUser) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_me_and_site", (Object)params, rowBounds);
            }
        } else {
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser", (Object)params, rowBounds);
            }
            if (excludeThisUser) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_others", (Object)params, rowBounds);
            }
            if (excludeOtherUsers) {
                return this.template.selectList("alfresco.activities.select.select_activity_feed_for_feeduser_me", (Object)params, rowBounds);
            }
        }
        throw new AlfrescoRuntimeException("Unexpected: invalid arguments");
    }

    private PagingResults<ActivityFeedEntity> getPagingResults(PagingRequest pagingRequest, final List<ActivityFeedEntity> feedEntries) {
        boolean hasMoreItems;
        int maxItems = pagingRequest.getMaxItems();
        boolean bl = hasMoreItems = feedEntries.size() > maxItems;
        if (hasMoreItems) {
            feedEntries.remove(feedEntries.size() - 1);
        }
        return new PagingResults<ActivityFeedEntity>(){

            public List<ActivityFeedEntity> getPage() {
                return feedEntries;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return new Pair(null, null);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    private List<ActivityFeedEntity> filterByNetwork(String networkId, String siteId, String sql, ActivityFeedQueryEntity params, PagingRequest pagingRequest) {
        int expectedSkipCount = pagingRequest.getSkipCount();
        int expectedMaxItems = pagingRequest.getMaxItems() == Integer.MAX_VALUE ? pagingRequest.getMaxItems() : pagingRequest.getMaxItems() + 1;
        int skipCount = 0;
        int maxItems = this.fetchBatchSize;
        LinkedList<ActivityFeedEntity> ret = new LinkedList<ActivityFeedEntity>();
        int numMatchingItems = 0;
        int numAddedItems = 0;
        boolean skipping = true;
        List feedEntries = null;
        do {
            RowBounds rowBounds = new RowBounds(skipCount, maxItems);
            feedEntries = this.template.selectList(sql, (Object)params, rowBounds);
            Iterator feedEntriesIt = feedEntries.iterator();
            while (feedEntriesIt.hasNext() && numAddedItems < expectedMaxItems) {
                ActivityFeedEntity activityFeedEntry = (ActivityFeedEntity)feedEntriesIt.next();
                if (siteId == null && !networkId.equals(this.tenantService.getDomain(activityFeedEntry.getSiteNetwork()))) continue;
                ++numMatchingItems;
                if (skipping) {
                    if (numMatchingItems <= expectedSkipCount) continue;
                    skipping = false;
                }
                ret.add(activityFeedEntry);
                ++numAddedItems;
            }
            skipCount += feedEntries.size();
        } while (feedEntries != null && feedEntries.size() > 0 && numAddedItems < expectedMaxItems);
        return ret;
    }

    @Override
    public PagingResults<ActivityFeedEntity> selectPagedUserFeedEntries(String feedUserId, String networkId, String siteId, boolean excludeThisUser, boolean excludeOtherUsers, long minFeedId, PagingRequest pagingRequest) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setFeedUserId(feedUserId);
        if (minFeedId > -1L) {
            params.setMinId(minFeedId);
        }
        if (siteId != null) {
            params.setSiteNetwork(siteId);
            if (excludeThisUser && excludeOtherUsers) {
                return new EmptyPagingResults();
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser_and_site", params, pagingRequest));
            }
            if (excludeThisUser && !excludeOtherUsers) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser_others_and_site", params, pagingRequest));
            }
            if (excludeOtherUsers && !excludeThisUser) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser_me_and_site", params, pagingRequest));
            }
        } else {
            if (excludeThisUser && excludeOtherUsers) {
                return new EmptyPagingResults();
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser", params, pagingRequest));
            }
            if (excludeThisUser) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser_others", params, pagingRequest));
            }
            if (excludeOtherUsers) {
                return this.getPagingResults(pagingRequest, this.filterByNetwork(networkId, siteId, "alfresco.activities.select_activity_feed_for_feeduser_me", params, pagingRequest));
            }
        }
        throw new AlfrescoRuntimeException("Unexpected: invalid arguments");
    }

    @Override
    public Long countSiteFeedEntries(String siteId, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setSiteNetwork(siteId);
        return (Long)this.template.selectOne("alfresco.activities.count_activity_feed_for_site", (Object)params);
    }

    @Override
    public List<ActivityFeedEntity> selectSiteFeedEntries(String siteId, int maxFeedSize) throws SQLException {
        ActivityFeedQueryEntity params = new ActivityFeedQueryEntity();
        params.setSiteNetwork(siteId);
        int rowLimit = maxFeedSize < 0 ? Integer.MAX_VALUE : maxFeedSize;
        RowBounds rowBounds = new RowBounds(0, rowLimit);
        return this.template.selectList("alfresco.activities.select.select_activity_feed_for_site", (Object)params, rowBounds);
    }
}

