/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.avm.AVMLockDAO;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAVMLockDAOImpl
implements AVMLockDAO {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PropertyValueDAO propertyValueDAO;

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    @Override
    public void removeLocks(String avmStore, String dirPathToMatch, Map<String, String> lockDataToMatch) {
        Long avmLocksValueId = null;
        Pair<Long, Serializable> valuePair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)".avm_locks"));
        if (valuePair == null) {
            return;
        }
        avmLocksValueId = (Long)valuePair.getFirst();
        Long avmStoreNameId = null;
        valuePair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)avmStore));
        if (valuePair == null) {
            return;
        }
        avmStoreNameId = (Long)valuePair.getFirst();
        String lockDataStoreKey = null;
        String lockDataStoreValue = null;
        if (lockDataToMatch != null && lockDataToMatch.size() > 0) {
            lockDataStoreKey = "avm-store-name";
            if (lockDataToMatch.size() != 1 || !lockDataToMatch.containsKey(lockDataStoreKey)) {
                throw new AlfrescoRuntimeException("Expected lockData to contain either no entries or only one entry with key: " + lockDataStoreKey);
            }
            lockDataStoreValue = lockDataToMatch.get(lockDataStoreKey);
        }
        int deleted = this.deletePropertyUniqueContexts(avmLocksValueId, avmStoreNameId, dirPathToMatch, lockDataStoreKey, lockDataStoreValue);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + deleted + " unique property contexts: \n" + "   dirPathToMatch:  " + dirPathToMatch + "\n" + "   lockDataToMatch: " + lockDataToMatch));
        }
    }

    protected abstract int deletePropertyUniqueContexts(Long var1, Long var2, String var3, String var4, String var5);
}

