/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.avm.AVMChildEntryEntity;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.avm.AVMMergeLinkEntity;
import org.alfresco.repo.domain.avm.AVMNodeLinksDAO;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchLanguageConversion;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractAVMNodeLinksDAOImpl
implements AVMNodeLinksDAO {
    private static final String CACHE_REGION_AVM_CHILD_ENTRY = "AVMChildEntry";
    private static final String CACHE_REGION_AVM_HISTORY_LINK = "AVMHistoryLink";
    private final AVMChildEntryEntityCallbackDAO avmChildEntryEntityDaoCallback = new AVMChildEntryEntityCallbackDAO();
    private final AVMHistoryLinkEntityCallbackDAO avmHistoryLinkEntityDaoCallback;
    private EntityLookupCache<ChildKey, AVMChildEntryEntity, Pair<Long, Long>> avmChildEntryCache = new EntityLookupCache<ChildKey, AVMChildEntryEntity, Pair<Long, Long>>(this.avmChildEntryEntityDaoCallback);
    private EntityLookupCache<Long, AVMHistoryLinkEntity, AVMHistoryLinkEntity> avmHistoryLinkCache;

    public void setAvmChildEntryCache(SimpleCache<Serializable, Object> avmChildEntryCache) {
        this.avmChildEntryCache = new EntityLookupCache<ChildKey, AVMChildEntryEntity, Pair<Long, Long>>(avmChildEntryCache, CACHE_REGION_AVM_CHILD_ENTRY, this.avmChildEntryEntityDaoCallback);
    }

    public void setAvmHistoryLinkCache(SimpleCache<Serializable, Object> avmHistoryLinkCache) {
        this.avmHistoryLinkCache = new EntityLookupCache<Long, AVMHistoryLinkEntity, AVMHistoryLinkEntity>(avmHistoryLinkCache, CACHE_REGION_AVM_HISTORY_LINK, this.avmHistoryLinkEntityDaoCallback);
    }

    public AbstractAVMNodeLinksDAOImpl() {
        this.avmHistoryLinkEntityDaoCallback = new AVMHistoryLinkEntityCallbackDAO();
        this.avmHistoryLinkCache = new EntityLookupCache<Long, AVMHistoryLinkEntity, AVMHistoryLinkEntity>(this.avmHistoryLinkEntityDaoCallback);
    }

    @Override
    public void createChildEntry(long parentNodeId, String name, long childNodeId) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        AVMChildEntryEntity ceEntity = new AVMChildEntryEntity();
        ceEntity.setParentNodeId(parentNodeId);
        ceEntity.setName(name);
        ceEntity.setChildNodeId(childNodeId);
        Pair<ChildKey, AVMChildEntryEntity> entityPair = this.avmChildEntryCache.getOrCreateByValue(ceEntity);
        entityPair.getSecond();
    }

    @Override
    public AVMChildEntryEntity getChildEntry(long parentNodeId, String name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        Pair<ChildKey, AVMChildEntryEntity> entityPair = this.avmChildEntryCache.getByKey(new ChildKey(parentNodeId, name));
        if (entityPair == null) {
            return null;
        }
        return (AVMChildEntryEntity)entityPair.getSecond();
    }

    @Override
    public List<AVMChildEntryEntity> getChildEntriesByParent(long parentNodeId, String childNamePattern) {
        List<AVMChildEntryEntity> result = null;
        if (childNamePattern == null || childNamePattern.length() == 0) {
            result = this.getChildEntryEntitiesByParent(parentNodeId);
        } else {
            String pattern = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_SQL_LIKE, (String)childNamePattern);
            result = this.getChildEntryEntitiesByParent(parentNodeId, pattern);
        }
        if (result == null) {
            result = new ArrayList<AVMChildEntryEntity>(0);
        }
        return result;
    }

    @Override
    public AVMChildEntryEntity getChildEntry(long parentNodeId, long childNodeId) {
        AVMChildEntryEntity ceEntity = new AVMChildEntryEntity();
        ceEntity.setParentNodeId(parentNodeId);
        ceEntity.setChildNodeId(childNodeId);
        Pair<ChildKey, AVMChildEntryEntity> entityPair = this.avmChildEntryCache.getByValue(ceEntity);
        if (entityPair == null) {
            return null;
        }
        return (AVMChildEntryEntity)entityPair.getSecond();
    }

    @Override
    public List<AVMChildEntryEntity> getChildEntriesByChild(long childNodeId) {
        List<AVMChildEntryEntity> result = this.getChildEntryEntitiesByChild(childNodeId);
        if (result == null) {
            result = new ArrayList<AVMChildEntryEntity>(0);
        }
        return result;
    }

    @Override
    public void updateChildEntry(AVMChildEntryEntity childEntryEntity) {
        ParameterCheck.mandatory((String)"childEntryEntity", (Object)childEntryEntity);
        ParameterCheck.mandatory((String)"childEntryEntity.getParentNodeId()", (Object)childEntryEntity.getParentNodeId());
        ParameterCheck.mandatory((String)"childEntryEntity.getChildId()", (Object)childEntryEntity.getChildId());
        ParameterCheck.mandatory((String)"childEntryEntity.getName()", (Object)childEntryEntity.getName());
        ChildKey key = new ChildKey(childEntryEntity.getParentNodeId(), childEntryEntity.getName());
        int updated = this.avmChildEntryCache.updateValue(key, childEntryEntity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("AVMChildEntry for parent/name (" + key.getParentNodeId() + ", " + key.getName() + ") no longer exists");
        }
    }

    @Override
    public void deleteChildEntry(AVMChildEntryEntity childEntryEntity) {
        ParameterCheck.mandatory((String)"childEntryEntity", (Object)childEntryEntity);
        ParameterCheck.mandatory((String)"childEntryEntity.getParentNodeId()", (Object)childEntryEntity.getParentNodeId());
        ParameterCheck.mandatory((String)"childEntryEntity.getName()", (Object)childEntryEntity.getName());
        ChildKey key = new ChildKey(childEntryEntity.getParentNodeId(), childEntryEntity.getName());
        Pair<ChildKey, AVMChildEntryEntity> entityPair = this.avmChildEntryCache.getByKey(key);
        if (entityPair == null) {
            return;
        }
        int deleted = this.avmChildEntryCache.deleteByKey(key);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMChildEntry for parent/name (" + key.getParentNodeId() + ", " + key.getName() + ") no longer exists");
        }
    }

    @Override
    public void deleteChildEntriesByParent(long parentNodeId) {
        List<AVMChildEntryEntity> ceEntities = this.getChildEntriesByParent(parentNodeId, null);
        if (ceEntities.size() == 0) {
            return;
        }
        for (AVMChildEntryEntity ceEntity : ceEntities) {
            this.deleteChildEntry(ceEntity);
        }
    }

    protected abstract List<AVMChildEntryEntity> getChildEntryEntitiesByParent(long var1);

    protected abstract List<AVMChildEntryEntity> getChildEntryEntitiesByParent(long var1, String var3);

    protected abstract List<AVMChildEntryEntity> getChildEntryEntitiesByChild(long var1);

    protected abstract AVMChildEntryEntity getChildEntryEntity(long var1, String var3);

    protected abstract AVMChildEntryEntity getChildEntryEntity(long var1, long var3);

    protected abstract AVMChildEntryEntity getChildEntryEntity(AVMChildEntryEntity var1);

    protected abstract void createChildEntryEntity(AVMChildEntryEntity var1);

    protected abstract int updateChildEntryEntity(AVMChildEntryEntity var1);

    protected abstract int deleteChildEntryEntity(long var1, String var3);

    protected abstract int deleteChildEntryEntity(long var1, long var3);

    protected abstract int deleteChildEntryEntities(long var1);

    @Override
    public void createMergeLink(long mergeFromNodeId, long mergeToNodeId) {
        this.createMergeLinkEntity(mergeFromNodeId, mergeToNodeId);
    }

    @Override
    public void deleteMergeLink(long mergeFromNodeId, long mergeToNodeId) {
        AVMMergeLinkEntity mlEntity = this.getMergeLinkByTo(mergeToNodeId);
        if (mlEntity == null) {
            return;
        }
        int deleted = this.deleteMergeLinkEntity(mergeFromNodeId, mergeToNodeId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMMergeLink (" + mergeFromNodeId + ", " + mergeToNodeId + ") no longer exists");
        }
    }

    @Override
    public AVMMergeLinkEntity getMergeLinkByTo(long mergeToNodeId) {
        return this.getMergeLinkEntityByTo(mergeToNodeId);
    }

    @Override
    public List<AVMMergeLinkEntity> getMergeLinksByFrom(long mergeFromNodeId) {
        return this.getMergeLinkEntitiesByFrom(mergeFromNodeId);
    }

    protected abstract void createMergeLinkEntity(long var1, long var3);

    protected abstract int deleteMergeLinkEntity(long var1, long var3);

    protected abstract AVMMergeLinkEntity getMergeLinkEntityByTo(long var1);

    protected abstract List<AVMMergeLinkEntity> getMergeLinkEntitiesByFrom(long var1);

    @Override
    public void createHistoryLink(long ancestorNodeId, long descendentNodeId) {
        AVMHistoryLinkEntity hlEntity = new AVMHistoryLinkEntity(ancestorNodeId, descendentNodeId);
        this.avmHistoryLinkCache.getOrCreateByValue(hlEntity);
    }

    @Override
    public void deleteHistoryLink(long ancestorNodeId, long descendentNodeId) {
        AVMHistoryLinkEntity hlEntity = new AVMHistoryLinkEntity(ancestorNodeId, descendentNodeId);
        Pair<Long, AVMHistoryLinkEntity> entityPair = this.avmHistoryLinkCache.getByValue(hlEntity);
        if (entityPair == null) {
            return;
        }
        int deleted = this.avmHistoryLinkCache.deleteByValue(hlEntity);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMHistoryLinkEntity (" + ancestorNodeId + ", " + descendentNodeId + ") no longer exists");
        }
    }

    @Override
    public AVMHistoryLinkEntity getHistoryLinkByDescendent(long descendentNodeId) {
        Pair<Long, AVMHistoryLinkEntity> entityPair = this.avmHistoryLinkCache.getByKey(descendentNodeId);
        if (entityPair == null) {
            return null;
        }
        return (AVMHistoryLinkEntity)entityPair.getSecond();
    }

    @Override
    public List<AVMHistoryLinkEntity> getHistoryLinksByAncestor(long ancestorNodeId) {
        return this.getHistoryLinkEntitiesByAncestor(ancestorNodeId);
    }

    protected abstract void createHistoryLinkEntity(long var1, long var3);

    protected abstract int deleteHistoryLinkEntity(long var1, long var3);

    protected abstract AVMHistoryLinkEntity getHistoryLinkEntity(long var1, long var3);

    protected abstract AVMHistoryLinkEntity getHistoryLinkEntityByDescendent(long var1);

    protected abstract List<AVMHistoryLinkEntity> getHistoryLinkEntitiesByAncestor(long var1);

    private class AVMHistoryLinkEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, AVMHistoryLinkEntity, AVMHistoryLinkEntity> {
        private AVMHistoryLinkEntityCallbackDAO() {
        }

        private final Pair<Long, AVMHistoryLinkEntity> convertEntityToPair(AVMHistoryLinkEntity hlEntity) {
            if (hlEntity == null) {
                return null;
            }
            return new Pair((Object)hlEntity.getDescendentNodeId(), (Object)hlEntity);
        }

        @Override
        public AVMHistoryLinkEntity getValueKey(AVMHistoryLinkEntity value) {
            return value;
        }

        @Override
        public Pair<Long, AVMHistoryLinkEntity> createValue(AVMHistoryLinkEntity value) {
            AbstractAVMNodeLinksDAOImpl.this.createHistoryLinkEntity(value.getAncestorNodeId(), value.getDescendentNodeId());
            return this.convertEntityToPair(value);
        }

        @Override
        public Pair<Long, AVMHistoryLinkEntity> findByKey(Long key) {
            AVMHistoryLinkEntity entity = AbstractAVMNodeLinksDAOImpl.this.getHistoryLinkEntityByDescendent(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AVMHistoryLinkEntity> findByValue(AVMHistoryLinkEntity value) {
            AVMHistoryLinkEntity entity = AbstractAVMNodeLinksDAOImpl.this.getHistoryLinkEntity(value.getAncestorNodeId(), value.getDescendentNodeId());
            return this.convertEntityToPair(entity);
        }

        @Override
        public int updateValue(Long key, AVMHistoryLinkEntity value) {
            throw new UnsupportedOperationException("updateValue(Long, AVMHistoryLinkEntity");
        }

        @Override
        public int deleteByKey(Long key) {
            AVMHistoryLinkEntity entity = AbstractAVMNodeLinksDAOImpl.this.getHistoryLinkEntityByDescendent(key);
            return AbstractAVMNodeLinksDAOImpl.this.deleteHistoryLinkEntity(entity.getAncestorNodeId(), entity.getDescendentNodeId());
        }

        @Override
        public int deleteByValue(AVMHistoryLinkEntity value) {
            return AbstractAVMNodeLinksDAOImpl.this.deleteHistoryLinkEntity(value.getAncestorNodeId(), value.getDescendentNodeId());
        }
    }

    private class AVMChildEntryEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<ChildKey, AVMChildEntryEntity, Pair<Long, Long>> {
        private AVMChildEntryEntityCallbackDAO() {
        }

        private final Pair<ChildKey, AVMChildEntryEntity> convertEntityToPair(AVMChildEntryEntity ceEntity) {
            if (ceEntity == null) {
                return null;
            }
            return new Pair((Object)new ChildKey(ceEntity.getParentNodeId(), ceEntity.getName()), (Object)ceEntity);
        }

        @Override
        public Pair<Long, Long> getValueKey(AVMChildEntryEntity value) {
            return new Pair((Object)value.getParentNodeId(), (Object)value.getChildId());
        }

        @Override
        public Pair<ChildKey, AVMChildEntryEntity> createValue(AVMChildEntryEntity value) {
            AbstractAVMNodeLinksDAOImpl.this.createChildEntryEntity(value);
            return this.convertEntityToPair(value);
        }

        @Override
        public Pair<ChildKey, AVMChildEntryEntity> findByKey(ChildKey key) {
            AVMChildEntryEntity entity = AbstractAVMNodeLinksDAOImpl.this.getChildEntryEntity((long)key.getParentNodeId(), key.getName());
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<ChildKey, AVMChildEntryEntity> findByValue(AVMChildEntryEntity value) {
            AVMChildEntryEntity entity = AbstractAVMNodeLinksDAOImpl.this.getChildEntryEntity((long)value.getParentNodeId(), value.getChildId());
            return this.convertEntityToPair(entity);
        }

        @Override
        public int updateValue(ChildKey key, AVMChildEntryEntity value) {
            return AbstractAVMNodeLinksDAOImpl.this.updateChildEntryEntity(value);
        }

        @Override
        public int deleteByKey(ChildKey key) {
            return AbstractAVMNodeLinksDAOImpl.this.deleteChildEntryEntity((long)key.getParentNodeId(), key.getName());
        }

        @Override
        public int deleteByValue(AVMChildEntryEntity value) {
            return AbstractAVMNodeLinksDAOImpl.this.deleteChildEntryEntity((long)value.getParentNodeId(), value.getChildId());
        }
    }

    private static class ChildKey
    implements Serializable {
        private static final long serialVersionUID = 848161072437569305L;
        private Long parentNodeId;
        private String name;

        public ChildKey(Long parentNodeId, String name) {
            this.parentNodeId = parentNodeId;
            this.name = name;
        }

        public Long getParentNodeId() {
            return this.parentNodeId;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChildKey)) {
                return false;
            }
            ChildKey o = (ChildKey)other;
            return this.parentNodeId.equals(o.getParentNodeId()) && this.name.equalsIgnoreCase(o.getName());
        }

        public int hashCode() {
            return this.parentNodeId.hashCode() + this.name.toLowerCase().hashCode();
        }
    }
}

