/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions.ibatis;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.domain.permissions.AbstractAclCrudDAOImpl;
import org.alfresco.repo.domain.permissions.Ace;
import org.alfresco.repo.domain.permissions.AceContextEntity;
import org.alfresco.repo.domain.permissions.AceEntity;
import org.alfresco.repo.domain.permissions.AclChangeSetEntity;
import org.alfresco.repo.domain.permissions.AclEntity;
import org.alfresco.repo.domain.permissions.AclMemberEntity;
import org.alfresco.repo.domain.permissions.AuthorityAliasEntity;
import org.alfresco.repo.domain.permissions.AuthorityEntity;
import org.alfresco.repo.domain.permissions.PermissionEntity;
import org.alfresco.repo.security.permissions.ACEType;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.Assert;

public class AclCrudDAOImpl
extends AbstractAclCrudDAOImpl {
    private static final String INSERT_ACL = "alfresco.permissions.insert.insert_Acl";
    private static final String SELECT_ACL_BY_ID = "alfresco.permissions.select_AclById";
    private static final String SELECT_ACLS_THAT_INHERIT_FROM_ACL = "alfresco.permissions.select_AclsThatInheritFromAcl";
    private static final String SELECT_LATEST_ACL_BY_GUID = "alfresco.permissions.select_LatestAclByGuid";
    private static final String SELECT_ADM_NODES_BY_ACL = "alfresco.permissions.select_ADMNodesByAclId";
    private static final String SELECT_AVM_NODES_BY_ACL = "alfresco.permissions.select_AVMNodesByAclId";
    private static final String UPDATE_ACL = "alfresco.permissions.update_Acl";
    private static final String DELETE_ACL = "alfresco.permissions.delete_Acl";
    private static final String INSERT_ACL_MEMBER = "alfresco.permissions.insert.insert_AclMember";
    private static final String SELECT_ACL_MEMBERS_BY_ACL = "alfresco.permissions.select_AclMembersByAclId";
    private static final String SELECT_ACL_MEMBERS_BY_AUTHORITY = "alfresco.permissions.select_AclMembersByAuthorityName";
    private static final String UPDATE_ACL_MEMBER = "alfresco.permissions.update_AclMember";
    private static final String DELETE_ACL_MEMBERS_LIST = "alfresco.permissions.delete_AclMembersList";
    private static final String DELETE_ACL_MEMBERS_BY_ACL = "alfresco.permissions.delete_AclMembersByAclId";
    private static final String INSERT_ACL_CHANGESET = "alfresco.permissions.insert.insert_AclChangeSet";
    private static final String UPDATE_ACL_CHANGESET = "alfresco.permissions.update_AclChangeSet";
    private static final String SELECT_ACL_CHANGESET_BY_ID = "alfresco.permissions.select_AclChangeSetById";
    private static final String DELETE_ACL_CHANGESET = "alfresco.permissions.delete_AclChangeSet";
    private static final String INSERT_ACE = "alfresco.permissions.insert.insert_Ace";
    private static final String SELECT_ACE_BY_ID = "alfresco.permissions.select_AceById";
    private static final String SELECT_ACES_BY_AUTHORITY = "alfresco.permissions.select_AcesByAuthorityId";
    private static final String SELECT_ACES_AND_AUTHORIES_BY_ACL = "alfresco.permissions.select_AcesAndAuthoritiesByAclId";
    private static final String SELECT_ACE_WITH_NO_CONTEXT = "alfresco.permissions.select_AceWithNoContext";
    private static final String DELETE_ACES_LIST = "alfresco.permissions.delete_AcesList";
    private static final String INSERT_ACE_CONTEXT = "alfresco.permissions.insert.insert_AceContext";
    private static final String SELECT_ACE_CONTEXT_BY_ID = "alfresco.permissions.select_AceContextById";
    private static final String DELETE_ACE_CONTEXT = "alfresco.permissions.delete_AceContext";
    private static final String INSERT_PERMISSION = "alfresco.permissions.insert.insert_Permission";
    private static final String SELECT_PERMISSION_BY_ID = "alfresco.permissions.select_PermissionById";
    private static final String SELECT_PERMISSION_BY_TYPE_AND_NAME = "alfresco.permissions.select_PermissionByTypeAndName";
    private static final String UPDATE_PERMISSION = "alfresco.permissions.update_Permission";
    private static final String DELETE_PERMISSION = "alfresco.permissions.delete_Permission";
    private static final String INSERT_AUTHORITY = "alfresco.permissions.insert.insert_Authority";
    private static final String SELECT_AUTHORITY_BY_ID = "alfresco.permissions.select_AuthorityById";
    private static final String SELECT_AUTHORITY_BY_NAME = "alfresco.permissions.select_AuthorityByName";
    private static final String UPDATE_AUTHORITY = "alfresco.permissions.update_Authority";
    private static final String DELETE_AUTHORITY = "alfresco.permissions.delete_Authority";
    private static final String INSERT_AUTHORITY_ALIAS = "alfresco.permissions.insert.insert_AuthorityAlias";
    private static final String DELETE_AUTHORITY_ALIAS = "alfresco.permissions.delete_AuthorityAlias";
    private static final String SELECT_CHANGE_SET_LAST = "alfresco.permissions.select_ChangeSetLast";
    private static final String SELECT_CHANGE_SET_MAX_COMMIT_TIME = "alfresco.permissions.select_ChangeSetMaxCommitTime";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected AclEntity createAclEntity(AclEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_ACL, (Object)entity);
        return entity;
    }

    @Override
    protected AclEntity getAclEntity(long aclEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return (AclEntity)this.template.selectOne(SELECT_ACL_BY_ID, params);
    }

    @Override
    protected List<Long> getAclEntitiesThatInheritFromAcl(long aclEntityId) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(2);
        params.put("id", Long.valueOf(aclEntityId));
        params.put("bool", Boolean.valueOf(true));
        return this.template.selectList(SELECT_ACLS_THAT_INHERIT_FROM_ACL, params);
    }

    @Override
    protected Long getLatestAclEntityByGuid(String aclGuid) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("name", aclGuid);
        params.put("bool", true);
        return (Long)this.template.selectOne(SELECT_LATEST_ACL_BY_GUID, params);
    }

    @Override
    protected List<Long> getADMNodeEntityIdsByAcl(long aclEntityId, int maxResults) {
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.selectList(SELECT_ADM_NODES_BY_ACL, params, new RowBounds(0, maxResults));
    }

    @Override
    protected List<Long> getAVMNodeEntityIdsByAcl(long aclEntityId, int maxResults) {
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.selectList(SELECT_AVM_NODES_BY_ACL, params, new RowBounds(0, maxResults));
    }

    @Override
    protected int updateAclEntity(AclEntity updatedAclEntity) {
        updatedAclEntity.incrementVersion();
        return this.template.update(UPDATE_ACL, (Object)updatedAclEntity);
    }

    @Override
    protected int deleteAclEntity(long aclEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.delete(DELETE_ACL, params);
    }

    @Override
    protected AclMemberEntity createAclMemberEntity(AclMemberEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_ACL_MEMBER, (Object)entity);
        return entity;
    }

    @Override
    protected List<AclMemberEntity> getAclMemberEntitiesByAcl(long aclEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.selectList(SELECT_ACL_MEMBERS_BY_ACL, params);
    }

    @Override
    protected List<AclMemberEntity> getAclMemberEntitiesByAuthority(String authorityName) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("name", authorityName);
        return this.template.selectList(SELECT_ACL_MEMBERS_BY_AUTHORITY, params);
    }

    @Override
    protected int updateAclMemberEntity(AclMemberEntity updatedAclMemberEntity) {
        updatedAclMemberEntity.incrementVersion();
        return this.template.update(UPDATE_ACL_MEMBER, (Object)updatedAclMemberEntity);
    }

    @Override
    protected int deleteAclMemberEntities(List<Long> aclMemberEntityIds) {
        return this.template.delete(DELETE_ACL_MEMBERS_LIST, aclMemberEntityIds);
    }

    @Override
    protected int deleteAclMemberEntitiesByAcl(long aclEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.delete(DELETE_ACL_MEMBERS_BY_ACL, params);
    }

    @Override
    protected Long createAclChangeSetEntity() {
        AclChangeSetEntity entity = new AclChangeSetEntity();
        this.template.insert(INSERT_ACL_CHANGESET, (Object)entity);
        return entity.getId();
    }

    @Override
    protected AclChangeSetEntity getAclChangeSetEntity(Long aclChangeSetEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclChangeSetEntityId);
        return (AclChangeSetEntity)this.template.selectOne(SELECT_ACL_CHANGESET_BY_ID, params);
    }

    @Override
    protected int deleteAclChangeSetEntity(Long aclChangeSetEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclChangeSetEntityId);
        return this.template.delete(DELETE_ACL_CHANGESET, params);
    }

    @Override
    protected int updateChangeSetEntity(Long id, long commitTimeMs) {
        AclChangeSetEntity entity = new AclChangeSetEntity();
        entity.setId(id);
        entity.setCommitTimeMs(commitTimeMs);
        return this.template.update(UPDATE_ACL_CHANGESET, (Object)entity);
    }

    @Override
    protected long createAceEntity(AceEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_ACE, (Object)entity);
        Long id = entity.getId();
        return id != null ? id : -1L;
    }

    @Override
    protected AceEntity getAceEntity(long aceEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aceEntityId);
        return (AceEntity)this.template.selectOne(SELECT_ACE_BY_ID, params);
    }

    @Override
    protected AceEntity getAceEntity(long permissionId, long authorityId, boolean allowed, ACEType type) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(4);
        params.put("id1", Long.valueOf(permissionId));
        params.put("id2", Long.valueOf(authorityId));
        params.put("bool", Boolean.valueOf(allowed));
        params.put("int", Integer.valueOf(type.getId()));
        return (AceEntity)this.template.selectOne(SELECT_ACE_WITH_NO_CONTEXT, params);
    }

    @Override
    protected List<Ace> getAceEntitiesByAuthority(long authorityEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", authorityEntityId);
        return this.template.selectList(SELECT_ACES_BY_AUTHORITY, params);
    }

    @Override
    protected List<Map<String, Object>> getAceAndAuthorityEntitiesByAcl(long aclEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aclEntityId);
        return this.template.selectList(SELECT_ACES_AND_AUTHORIES_BY_ACL, params);
    }

    @Override
    protected int deleteAceEntities(List<Long> aceEntityIds) {
        return this.template.delete(DELETE_ACES_LIST, aceEntityIds);
    }

    @Override
    protected long createAceContextEntity(AceContextEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_ACE_CONTEXT, (Object)entity);
        Long id = entity.getId();
        return id != null ? id : -1L;
    }

    @Override
    protected AceContextEntity getAceContextEntity(long aceContextEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aceContextEntityId);
        return (AceContextEntity)this.template.selectOne(SELECT_ACE_CONTEXT_BY_ID, params);
    }

    @Override
    protected int deleteAceContextEntity(long aceContextEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", aceContextEntityId);
        return this.template.delete(DELETE_ACE_CONTEXT, params);
    }

    @Override
    protected PermissionEntity createPermissionEntity(PermissionEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_PERMISSION, (Object)entity);
        return entity;
    }

    @Override
    protected PermissionEntity getPermissionEntity(long permissionEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", permissionEntityId);
        return (PermissionEntity)this.template.selectOne(SELECT_PERMISSION_BY_ID, params);
    }

    @Override
    protected PermissionEntity getPermissionEntity(long qnameId, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", qnameId);
        params.put("name", name);
        return (PermissionEntity)this.template.selectOne(SELECT_PERMISSION_BY_TYPE_AND_NAME, params);
    }

    @Override
    protected int updatePermissionEntity(PermissionEntity permissionEntity) {
        permissionEntity.incrementVersion();
        return this.template.update(UPDATE_PERMISSION, (Object)permissionEntity);
    }

    @Override
    protected int deletePermissionEntity(long permissionEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", permissionEntityId);
        return this.template.delete(DELETE_PERMISSION, params);
    }

    @Override
    protected AuthorityEntity createAuthorityEntity(AuthorityEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_AUTHORITY, (Object)entity);
        return entity;
    }

    @Override
    protected AuthorityEntity getAuthorityEntity(long authorityEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", authorityEntityId);
        return (AuthorityEntity)this.template.selectOne(SELECT_AUTHORITY_BY_ID, params);
    }

    @Override
    protected AuthorityEntity getAuthorityEntity(String authorityName) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("name", authorityName);
        AuthorityEntity result = null;
        List authorities = this.template.selectList(SELECT_AUTHORITY_BY_NAME, params);
        for (AuthorityEntity found : authorities) {
            if (!found.getAuthority().equals(authorityName)) continue;
            result = found;
            break;
        }
        return result;
    }

    @Override
    protected int updateAuthorityEntity(AuthorityEntity authorityEntity) {
        authorityEntity.incrementVersion();
        return this.template.update(UPDATE_AUTHORITY, (Object)authorityEntity);
    }

    @Override
    protected int deleteAuthorityEntity(long authorityEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", authorityEntityId);
        return this.template.delete(DELETE_AUTHORITY, params);
    }

    @Override
    protected long createAuthorityAliasEntity(AuthorityAliasEntity entity) {
        entity.setVersion(0L);
        this.template.insert(INSERT_AUTHORITY_ALIAS, (Object)entity);
        Long id = entity.getId();
        return id != null ? id : -1L;
    }

    @Override
    protected int deleteAuthorityAliasEntity(long authorityAliasEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", authorityAliasEntityId);
        return this.template.delete(DELETE_AUTHORITY_ALIAS, params);
    }

    @Override
    protected Long selectMaxChangeSetCommitTime() {
        return (Long)this.template.selectOne(SELECT_CHANGE_SET_MAX_COMMIT_TIME);
    }

    @Override
    protected Long selectMaxChangeSetIdBeforeCommitTime(long maxCommitTime) {
        Assert.notNull((Object)maxCommitTime, (String)"maxCommitTime");
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("commit_time_ms", maxCommitTime);
        List sets = this.template.selectList(SELECT_CHANGE_SET_LAST, params, new RowBounds(0, 1));
        if (sets.size() > 0) {
            return (Long)sets.get(0);
        }
        return null;
    }
}

