/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceCheck {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.admin");
    private static final String MSG_DB_CONNECTION = "Using database URL '%s' with user '%s'.";
    private static final String MSG_DB_VERSION = "Connected to database %s version %s";
    private static final String ERR_DB_CONNECTION = "Database connection failed: %s";

    public DataSourceCheck(String dbUrl, String dbUsername, DataSource dataSource) {
        logger.info((Object)String.format(MSG_DB_CONNECTION, dbUrl, dbUsername));
        Connection con = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData meta = con.getMetaData();
            logger.info((Object)String.format(MSG_DB_VERSION, meta.getDatabaseProductName(), meta.getDatabaseProductVersion()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ERR_DB_CONNECTION, e.getMessage()), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }
}

