/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.download.DownloadService;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DownloadsCleanupJob
implements Job {
    private static final String KEY_DOWNLOAD_SERVICE = "downloadService";
    private static final String KEY_TENANT_ADMIN_SERVICE = "tenantAdminService";
    private static final String KEY_MAX_AGE = "maxAgeInMinutes";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        final DownloadService downloadService = (DownloadService)jobData.get((Object)KEY_DOWNLOAD_SERVICE);
        TenantAdminService tenantAdminService = (TenantAdminService)jobData.get((Object)KEY_TENANT_ADMIN_SERVICE);
        int maxAgeInMinutes = Integer.parseInt((String)jobData.get((Object)KEY_MAX_AGE));
        final DateTime before = new DateTime().minusMinutes(maxAgeInMinutes);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                downloadService.deleteDownloads(before.toDate());
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (tenantAdminService != null && tenantAdminService.isEnabled()) {
            List<Tenant> tenants = tenantAdminService.getAllTenants();
            for (Tenant tenant : tenants) {
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        downloadService.deleteDownloads(before.toDate());
                        return null;
                    }
                }, (String)tenant.getTenantDomain());
            }
        }
    }
}

