/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.namespace.QName;

class ChainedExporter
implements Exporter {
    private Exporter[] exporters;

    ChainedExporter(Exporter[] exporters) {
        ArrayList<Exporter> exporterList = new ArrayList<Exporter>();
        for (Exporter exporter : exporters) {
            if (exporter == null) continue;
            exporterList.add(exporter);
        }
        this.exporters = exporterList.toArray(new Exporter[exporterList.size()]);
    }

    @Override
    public void start(ExporterContext context) {
        for (Exporter exporter : this.exporters) {
            exporter.start(context);
        }
    }

    @Override
    public void startNamespace(String prefix, String uri) {
        for (Exporter exporter : this.exporters) {
            exporter.startNamespace(prefix, uri);
        }
    }

    @Override
    public void endNamespace(String prefix) {
        for (Exporter exporter : this.exporters) {
            exporter.endNamespace(prefix);
        }
    }

    @Override
    public void startNode(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.startNode(nodeRef);
        }
    }

    @Override
    public void endNode(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endNode(nodeRef);
        }
    }

    @Override
    public void startAspects(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.startAspects(nodeRef);
        }
    }

    @Override
    public void endAspects(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endAspects(nodeRef);
        }
    }

    @Override
    public void startAspect(NodeRef nodeRef, QName aspect) {
        for (Exporter exporter : this.exporters) {
            exporter.startAspect(nodeRef, aspect);
        }
    }

    @Override
    public void endAspect(NodeRef nodeRef, QName aspect) {
        for (Exporter exporter : this.exporters) {
            exporter.endAspect(nodeRef, aspect);
        }
    }

    @Override
    public void startACL(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.startACL(nodeRef);
        }
    }

    @Override
    public void permission(NodeRef nodeRef, AccessPermission permission) {
        for (Exporter exporter : this.exporters) {
            exporter.permission(nodeRef, permission);
        }
    }

    @Override
    public void endACL(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endACL(nodeRef);
        }
    }

    @Override
    public void startProperties(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.startProperties(nodeRef);
        }
    }

    @Override
    public void endProperties(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endProperties(nodeRef);
        }
    }

    @Override
    public void startProperty(NodeRef nodeRef, QName property) {
        for (Exporter exporter : this.exporters) {
            exporter.startProperty(nodeRef, property);
        }
    }

    @Override
    public void endProperty(NodeRef nodeRef, QName property) {
        for (Exporter exporter : this.exporters) {
            exporter.endProperty(nodeRef, property);
        }
    }

    @Override
    public void startValueCollection(NodeRef nodeRef, QName property) {
        for (Exporter exporter : this.exporters) {
            exporter.startValueCollection(nodeRef, property);
        }
    }

    @Override
    public void endValueCollection(NodeRef nodeRef, QName property) {
        for (Exporter exporter : this.exporters) {
            exporter.endValueCollection(nodeRef, property);
        }
    }

    @Override
    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        for (Exporter exporter : this.exporters) {
            exporter.value(nodeRef, property, value, index);
        }
    }

    @Override
    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        for (Exporter exporter : this.exporters) {
            exporter.content(nodeRef, property, content, contentData, index);
        }
    }

    @Override
    public void startAssoc(NodeRef nodeRef, QName assoc) {
        for (Exporter exporter : this.exporters) {
            exporter.startAssoc(nodeRef, assoc);
        }
    }

    @Override
    public void endAssoc(NodeRef nodeRef, QName assoc) {
        for (Exporter exporter : this.exporters) {
            exporter.endAssoc(nodeRef, assoc);
        }
    }

    @Override
    public void startAssocs(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.startAssocs(nodeRef);
        }
    }

    @Override
    public void endAssocs(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endAssocs(nodeRef);
        }
    }

    @Override
    public void startReference(NodeRef nodeRef, QName childName) {
        for (Exporter exporter : this.exporters) {
            exporter.startReference(nodeRef, childName);
        }
    }

    @Override
    public void endReference(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endReference(nodeRef);
        }
    }

    @Override
    public void startValueMLText(NodeRef nodeRef, Locale locale, boolean isNull) {
        for (Exporter exporter : this.exporters) {
            exporter.startValueMLText(nodeRef, locale, isNull);
        }
    }

    @Override
    public void endValueMLText(NodeRef nodeRef) {
        for (Exporter exporter : this.exporters) {
            exporter.endValueMLText(nodeRef);
        }
    }

    @Override
    public void warning(String warning) {
        for (Exporter exporter : this.exporters) {
            exporter.warning(warning);
        }
    }

    @Override
    public void end() {
        for (Exporter exporter : this.exporters) {
            exporter.end();
        }
    }
}

