/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.exporter.ChainedExporter;
import org.alfresco.repo.exporter.ExporterCrawler;
import org.alfresco.repo.exporter.URLExporter;
import org.alfresco.repo.exporter.ViewXMLExporter;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.cmr.view.ReferenceType;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.xml.sax.ContentHandler;

public class ExporterComponent
implements ExporterService {
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private DescriptorService descriptorService;
    private AuthenticationService authenticationService;
    private PermissionService permissionService;
    private int indentSize = 2;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void exportView(OutputStream viewWriter, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"View Writer", (Object)viewWriter);
        Exporter xmlExporter = this.createXMLExporter(viewWriter, parameters.getReferenceType());
        this.exportView(xmlExporter, parameters, progress);
    }

    @Override
    public void exportView(ExportPackageHandler exportHandler, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"Stream Handler", (Object)exportHandler);
        exportHandler.startExport();
        OutputStream dataFile = exportHandler.createDataStream();
        Exporter xmlExporter = this.createXMLExporter(dataFile, parameters.getReferenceType());
        URLExporter urlExporter = new URLExporter(xmlExporter, exportHandler);
        this.exportView(urlExporter, parameters, progress);
        exportHandler.endExport();
    }

    @Override
    public void exportView(Exporter exporter, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"Exporter", (Object)exporter);
        ChainedExporter chainedExporter = new ChainedExporter(new Exporter[]{exporter, progress});
        DefaultCrawler crawler = new DefaultCrawler();
        crawler.export(parameters, chainedExporter);
    }

    private Exporter createXMLExporter(OutputStream viewWriter, ReferenceType referenceType) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(this.indentSize);
        format.setEncoding("UTF-8");
        try {
            XMLWriter writer = new XMLWriter(viewWriter, format);
            ViewXMLExporter exporter = new ViewXMLExporter(this.namespaceService, this.nodeService, this.searchService, this.dictionaryService, this.permissionService, (ContentHandler)writer);
            exporter.setReferenceType(referenceType);
            return exporter;
        }
        catch (UnsupportedEncodingException e) {
            throw new ExporterException("Failed to create XML Writer for export", e);
        }
        catch (Exception e) {
            throw new ExporterException("Failed to create XML Writer for export", e);
        }
    }

    private class ExporterContextImpl
    implements ExporterContext {
        private NodeRef[] exportList;
        private NodeRef[] parentList;
        private String exportedBy;
        private Date exportedDate;
        private String exporterVersion;
        private Map<Integer, Set<NodeRef>> nodesWithSecondaryLinks = new HashMap<Integer, Set<NodeRef>>();
        private Map<Integer, Set<NodeRef>> nodesWithAssociations = new HashMap<Integer, Set<NodeRef>>();
        private int index = 0;

        public ExporterContextImpl(ExporterCrawlerParameters parameters) {
            String currentUserName = ExporterComponent.this.authenticationService.getCurrentUserName();
            this.exportedBy = currentUserName == null ? "unknown" : currentUserName;
            this.exportedDate = new Date(System.currentTimeMillis());
            NodeRef[] nodeRefArray = this.exportList = parameters.getExportFrom() == null ? null : parameters.getExportFrom().getNodeRefs();
            if (this.exportList == null) {
                NodeRef exportOf;
                this.exportList = new NodeRef[1];
                this.exportList[0] = exportOf = this.getNodeRef(parameters.getExportFrom());
            }
            this.parentList = new NodeRef[this.exportList.length];
            for (int i = 0; i < this.exportList.length; ++i) {
                this.parentList[i] = this.getParent(this.exportList[i], parameters.isCrawlSelf());
            }
            this.exporterVersion = ExporterComponent.this.descriptorService.getServerDescriptor().getVersion();
        }

        @Override
        public boolean canRetrieve() {
            return this.index < this.exportList.length;
        }

        @Override
        public int setNextValue() {
            return ++this.index;
        }

        @Override
        public void resetContext() {
            this.index = 0;
        }

        @Override
        public String getExportedBy() {
            return this.exportedBy;
        }

        @Override
        public Date getExportedDate() {
            return this.exportedDate;
        }

        @Override
        public String getExporterVersion() {
            return this.exporterVersion;
        }

        @Override
        public NodeRef getExportOf() {
            if (this.canRetrieve()) {
                return this.exportList[this.index];
            }
            return null;
        }

        @Override
        public NodeRef getExportParent() {
            if (this.canRetrieve()) {
                return this.parentList[this.index];
            }
            return null;
        }

        @Override
        public NodeRef[] getExportList() {
            return this.exportList;
        }

        @Override
        public NodeRef[] getExportParentList() {
            return this.parentList;
        }

        public void recordAssociation(NodeRef nodeRef) {
            Set<NodeRef> nodes = this.nodesWithAssociations.get(this.index);
            if (nodes == null) {
                nodes = new HashSet<NodeRef>();
                this.nodesWithAssociations.put(this.index, nodes);
            }
            nodes.add(nodeRef);
        }

        public Set<NodeRef> getNodesWithAssociations() {
            Set<NodeRef> nodes = this.nodesWithAssociations.get(this.index);
            if (nodes != null) {
                return nodes;
            }
            return null;
        }

        public void recordSecondaryLink(NodeRef nodeRef) {
            Set<NodeRef> nodes = this.nodesWithSecondaryLinks.get(this.index);
            if (nodes == null) {
                nodes = new HashSet<NodeRef>();
                this.nodesWithSecondaryLinks.put(this.index, nodes);
            }
            nodes.add(nodeRef);
        }

        public Set<NodeRef> getNodesWithSecondaryLinks() {
            Set<NodeRef> nodes = this.nodesWithSecondaryLinks.get(this.index);
            if (nodes != null) {
                return nodes;
            }
            return null;
        }

        private NodeRef getNodeRef(Location location) {
            String path;
            NodeRef nodeRef;
            ParameterCheck.mandatory((String)"Location", (Object)location);
            NodeRef nodeRef2 = nodeRef = location == null ? null : location.getNodeRef();
            if (nodeRef == null) {
                nodeRef = ExporterComponent.this.nodeService.getRootNode(location.getStoreRef());
            }
            String string = path = location == null ? null : location.getPath();
            if (path != null && path.length() > 0) {
                List nodeRefs = ExporterComponent.this.searchService.selectNodes(nodeRef, path, null, (NamespacePrefixResolver)ExporterComponent.this.namespaceService, false);
                if (nodeRefs.size() == 0) {
                    throw new ImporterException("Path " + path + " within node " + nodeRef + " does not exist - the path must resolve to a valid location");
                }
                if (nodeRefs.size() > 1) {
                    throw new ImporterException("Path " + path + " within node " + nodeRef + " found too many locations - the path must resolve to one location");
                }
                nodeRef = (NodeRef)nodeRefs.get(0);
            }
            return nodeRef;
        }

        private NodeRef getParent(NodeRef exportOf, boolean exportSelf) {
            NodeRef parent = null;
            if (exportSelf) {
                NodeRef rootNode = ExporterComponent.this.nodeService.getRootNode(exportOf.getStoreRef());
                if (rootNode.equals((Object)exportOf)) {
                    parent = exportOf;
                } else {
                    ChildAssociationRef parentRef = ExporterComponent.this.nodeService.getPrimaryParent(exportOf);
                    parent = parentRef.getParentRef();
                }
            } else {
                parent = exportOf;
            }
            return parent;
        }
    }

    private class DefaultCrawler
    implements ExporterCrawler {
        private ExporterContextImpl context;

        private DefaultCrawler() {
        }

        @Override
        public void export(ExporterCrawlerParameters parameters, Exporter exporter) {
            this.context = new ExporterContextImpl(parameters);
            exporter.start(this.context);
            while (this.context.canRetrieve()) {
                NodeRef nodeRef = this.context.getExportOf();
                if (parameters.isCrawlSelf()) {
                    this.walkStartNamespaces(parameters, exporter);
                    boolean rootNode = ExporterComponent.this.nodeService.getRootNode(nodeRef.getStoreRef()).equals((Object)nodeRef);
                    this.walkNode(nodeRef, parameters, exporter, rootNode);
                    this.walkEndNamespaces(parameters, exporter);
                } else if (parameters.isCrawlChildNodes()) {
                    List childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
                    for (ChildAssociationRef childAssoc : childAssocs) {
                        this.walkStartNamespaces(parameters, exporter);
                        this.walkNode(childAssoc.getChildRef(), parameters, exporter, false);
                        this.walkEndNamespaces(parameters, exporter);
                    }
                }
                this.context.setNextValue();
            }
            this.context.resetContext();
            while (this.context.canRetrieve()) {
                Set<NodeRef> nodesWithAssociations;
                Set<NodeRef> nodesWithSecondaryLinks = this.context.getNodesWithSecondaryLinks();
                if (nodesWithSecondaryLinks != null) {
                    for (NodeRef nodeWithAssociations : nodesWithSecondaryLinks) {
                        this.walkStartNamespaces(parameters, exporter);
                        this.walkNodeSecondaryLinks(nodeWithAssociations, parameters, exporter);
                        this.walkEndNamespaces(parameters, exporter);
                    }
                }
                if ((nodesWithAssociations = this.context.getNodesWithAssociations()) != null) {
                    for (NodeRef nodeWithAssociations : nodesWithAssociations) {
                        this.walkStartNamespaces(parameters, exporter);
                        this.walkNodeAssociations(nodeWithAssociations, parameters, exporter);
                        this.walkEndNamespaces(parameters, exporter);
                    }
                }
                this.context.setNextValue();
            }
            exporter.end();
        }

        private void walkStartNamespaces(ExporterCrawlerParameters parameters, Exporter exporter) {
            Collection prefixes = ExporterComponent.this.namespaceService.getPrefixes();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                String uri = ExporterComponent.this.namespaceService.getNamespaceURI(prefix);
                exporter.startNamespace(prefix, uri);
            }
        }

        private void walkEndNamespaces(ExporterCrawlerParameters parameters, Exporter exporter) {
            Collection prefixes = ExporterComponent.this.namespaceService.getPrefixes();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                exporter.endNamespace(prefix);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void walkNode(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter, boolean exportAsRef) {
            List associations;
            QName type = ExporterComponent.this.nodeService.getType(nodeRef);
            if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), type.getNamespaceURI())) {
                return;
            }
            if (parameters.getIncludedPaths() != null) {
                String nodePathPrefixString = ExporterComponent.this.nodeService.getPath(nodeRef).toPrefixString((NamespacePrefixResolver)ExporterComponent.this.namespaceService);
                if (!this.isIncludedPath(parameters.getIncludedPaths(), nodePathPrefixString)) {
                    return;
                }
            }
            if (exportAsRef) {
                exporter.startReference(nodeRef, null);
            } else {
                exporter.startNode(nodeRef);
            }
            exporter.startAspects(nodeRef);
            Set aspects = ExporterComponent.this.nodeService.getAspects(nodeRef);
            for (QName aspect : aspects) {
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), aspect.getNamespaceURI()) || this.isExcludedAspect(parameters.getExcludeAspects(), aspect)) continue;
                exporter.startAspect(nodeRef, aspect);
                exporter.endAspect(nodeRef, aspect);
            }
            exporter.endAspects(nodeRef);
            AccessStatus readPermission = ExporterComponent.this.permissionService.hasPermission(nodeRef, "ReadPermissions");
            if (ExporterComponent.this.authenticationService.isCurrentUserTheSystemUser() || readPermission.equals((Object)AccessStatus.ALLOWED)) {
                Set permissions = ExporterComponent.this.permissionService.getAllSetPermissions(nodeRef);
                boolean inheritPermissions = ExporterComponent.this.permissionService.getInheritParentPermissions(nodeRef);
                if (permissions.size() > 0 || !inheritPermissions) {
                    exporter.startACL(nodeRef);
                    for (AccessPermission permission : permissions) {
                        if (!permission.isSetDirectly()) continue;
                        exporter.permission(nodeRef, permission);
                    }
                    exporter.endACL(nodeRef);
                }
            }
            exporter.startProperties(nodeRef);
            boolean aware = MLPropertyInterceptor.setMLAware(true);
            Map properties = ExporterComponent.this.nodeService.getProperties(nodeRef);
            MLPropertyInterceptor.setMLAware(aware);
            for (QName property : properties.keySet()) {
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), property.getNamespaceURI()) || this.isExcludedAspectProperty(parameters.getExcludeAspects(), property)) continue;
                Object value = properties.get(property);
                if (!parameters.isCrawlNullProperties() && value == null) continue;
                exporter.startProperty(nodeRef, property);
                if (value instanceof Collection) {
                    exporter.startValueCollection(nodeRef, property);
                    boolean bl = false;
                    for (Object valueInCollection : (Collection)value) {
                        void var13_16;
                        this.walkProperty(nodeRef, property, valueInCollection, (int)var13_16, parameters, exporter);
                        ++var13_16;
                    }
                    exporter.endValueCollection(nodeRef, property);
                } else if (value instanceof MLText) {
                    MLText mLText = (MLText)value;
                    Set locales = mLText.getLocales();
                    Iterator i$ = locales.iterator();
                    while (i$.hasNext()) {
                        Locale locale;
                        String localeValue = mLText.getValue(locale = (Locale)i$.next());
                        exporter.startValueMLText(nodeRef, locale, localeValue == null);
                        this.walkProperty(nodeRef, property, localeValue, -1, parameters, exporter);
                        exporter.endValueMLText(nodeRef);
                    }
                } else {
                    this.walkProperty(nodeRef, property, value, -1, parameters, exporter);
                }
                exporter.endProperty(nodeRef, property);
            }
            exporter.endProperties(nodeRef);
            if (parameters.isCrawlChildNodes()) {
                HashMap<QName, ArrayList<ChildAssociationRef>> assocTypes = new HashMap<QName, ArrayList<ChildAssociationRef>>();
                List childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
                for (ChildAssociationRef childAssociationRef : childAssocs) {
                    QName childAssocType = childAssociationRef.getTypeQName();
                    if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssocType.getNamespaceURI()) || this.isExcludedChildAssoc(parameters.getExcludeChildAssocs(), childAssocType) || this.isExcludedAspectAssociation(parameters.getExcludeAspects(), childAssocType)) continue;
                    if (!childAssociationRef.isPrimary()) {
                        this.context.recordSecondaryLink(nodeRef);
                        continue;
                    }
                    if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssociationRef.getQName().getNamespaceURI())) continue;
                    ArrayList<ChildAssociationRef> assocRefs = (ArrayList<ChildAssociationRef>)assocTypes.get(childAssocType);
                    if (assocRefs == null) {
                        assocRefs = new ArrayList<ChildAssociationRef>();
                        assocTypes.put(childAssocType, assocRefs);
                    }
                    assocRefs.add(childAssociationRef);
                }
                if (assocTypes.size() > 0) {
                    exporter.startAssocs(nodeRef);
                    for (Map.Entry entry : assocTypes.entrySet()) {
                        List assocRefs = (List)entry.getValue();
                        if (assocRefs.size() <= 0) continue;
                        exporter.startAssoc(nodeRef, (QName)entry.getKey());
                        for (ChildAssociationRef assocRef : assocRefs) {
                            this.walkNode(assocRef.getChildRef(), parameters, exporter, false);
                        }
                        exporter.endAssoc(nodeRef, (QName)entry.getKey());
                    }
                    exporter.endAssocs(nodeRef);
                }
            }
            if (parameters.isCrawlAssociations() && (associations = ExporterComponent.this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)).size() > 0) {
                this.context.recordAssociation(nodeRef);
            }
            if (exportAsRef) {
                exporter.endReference(nodeRef);
            } else {
                exporter.endNode(nodeRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void walkProperty(NodeRef nodeRef, QName property, Object value, int index, ExporterCrawlerParameters parameters, Exporter exporter) {
            PropertyDefinition propDef = ExporterComponent.this.dictionaryService.getProperty(property);
            DataTypeDefinition dataTypeDef = propDef == null ? null : propDef.getDataType();
            QName valueDataType = null;
            if (dataTypeDef == null || dataTypeDef.getName().equals((Object)DataTypeDefinition.ANY)) {
                DataTypeDefinition dataTypeDefinition = dataTypeDef = value == null ? null : ExporterComponent.this.dictionaryService.getDataType(value.getClass());
                if (dataTypeDef != null) {
                    valueDataType = dataTypeDef.getName();
                }
            } else {
                valueDataType = dataTypeDef.getName();
            }
            if (valueDataType == null || !valueDataType.equals((Object)DataTypeDefinition.CONTENT)) {
                try {
                    exporter.value(nodeRef, property, value, index);
                }
                catch (TypeConversionException e) {
                    exporter.warning("Value of property " + property + " could not be converted to xml string");
                    exporter.value(nodeRef, property, value == null ? null : value.toString(), index);
                }
            } else {
                ContentReader reader = ExporterComponent.this.contentService.getReader(nodeRef, property);
                if (!parameters.isCrawlContent() || reader == null || !reader.exists()) {
                    ContentData contentData = (ContentData)value;
                    ContentData noContentURL = null;
                    noContentURL = contentData == null ? new ContentData("", null, 0L, "UTF-8") : new ContentData("", contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
                    exporter.content(nodeRef, property, null, noContentURL, index);
                    exporter.warning("Skipped content for property " + property + " on node " + nodeRef);
                } else {
                    InputStream inputStream = reader.getContentInputStream();
                    try {
                        exporter.content(nodeRef, property, inputStream, reader.getContentData(), index);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new ExporterException("Failed to export node content for node " + nodeRef, e);
                        }
                    }
                }
            }
        }

        private void walkNodeSecondaryLinks(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter) {
            HashMap<QName, ArrayList<ChildAssociationRef>> assocTypes = new HashMap<QName, ArrayList<ChildAssociationRef>>();
            List childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssociationRef : childAssocs) {
                QName childAssocType = childAssociationRef.getTypeQName();
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssocType.getNamespaceURI()) || this.isExcludedChildAssoc(parameters.getExcludeChildAssocs(), childAssocType) || this.isExcludedAspectAssociation(parameters.getExcludeAspects(), childAssocType) || childAssociationRef.isPrimary() || !this.isWithinExport(childAssociationRef.getChildRef(), parameters)) continue;
                ArrayList<ChildAssociationRef> assocRefs = (ArrayList<ChildAssociationRef>)assocTypes.get(childAssocType);
                if (assocRefs == null) {
                    assocRefs = new ArrayList<ChildAssociationRef>();
                    assocTypes.put(childAssocType, assocRefs);
                }
                assocRefs.add(childAssociationRef);
            }
            if (assocTypes.size() > 0) {
                exporter.startReference(nodeRef, null);
                exporter.startAssocs(nodeRef);
                for (Map.Entry entry : assocTypes.entrySet()) {
                    List assocRefs = (List)entry.getValue();
                    if (assocRefs.size() <= 0) continue;
                    exporter.startAssoc(nodeRef, (QName)entry.getKey());
                    for (ChildAssociationRef assocRef : assocRefs) {
                        exporter.startReference(assocRef.getChildRef(), assocRef.getQName());
                        exporter.endReference(assocRef.getChildRef());
                    }
                    exporter.endAssoc(nodeRef, (QName)entry.getKey());
                }
                exporter.endAssocs(nodeRef);
                exporter.endReference(nodeRef);
            }
        }

        private void walkNodeAssociations(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter) {
            HashMap<QName, ArrayList<AssociationRef>> assocTypes = new HashMap<QName, ArrayList<AssociationRef>>();
            List assocs = ExporterComponent.this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef associationRef : assocs) {
                QName assocType = associationRef.getTypeQName();
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), assocType.getNamespaceURI()) || !this.isWithinExport(associationRef.getTargetRef(), parameters)) continue;
                ArrayList<AssociationRef> assocRefs = (ArrayList<AssociationRef>)assocTypes.get(assocType);
                if (assocRefs == null) {
                    assocRefs = new ArrayList<AssociationRef>();
                    assocTypes.put(assocType, assocRefs);
                }
                assocRefs.add(associationRef);
            }
            if (assocTypes.size() > 0) {
                exporter.startReference(nodeRef, null);
                exporter.startAssocs(nodeRef);
                for (Map.Entry entry : assocTypes.entrySet()) {
                    List assocRefs = (List)entry.getValue();
                    if (assocRefs.size() <= 0) continue;
                    exporter.startAssoc(nodeRef, (QName)entry.getKey());
                    for (AssociationRef assocRef : assocRefs) {
                        exporter.startReference(assocRef.getTargetRef(), null);
                        exporter.endReference(assocRef.getTargetRef());
                    }
                    exporter.endAssoc(nodeRef, (QName)entry.getKey());
                }
                exporter.endAssocs(nodeRef);
                exporter.endReference(nodeRef);
            }
        }

        private boolean isExcludedURI(String[] excludeNamespaceURIs, String uri) {
            for (String excludedURI : excludeNamespaceURIs) {
                if (!uri.equals(excludedURI)) continue;
                return true;
            }
            return false;
        }

        private boolean isIncludedPath(String[] includedPaths, String path) {
            for (String includePath : includedPaths) {
                if (!includePath.startsWith(path) && !path.startsWith(includePath)) continue;
                return true;
            }
            return false;
        }

        private boolean isExcludedAspect(QName[] excludeAspects, QName aspectQName) {
            if (aspectQName.equals((Object)ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) || aspectQName.equals((Object)ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                return true;
            }
            for (QName excludeAspect : excludeAspects) {
                if (!aspectQName.equals((Object)excludeAspect)) continue;
                return true;
            }
            return false;
        }

        private boolean isExcludedChildAssoc(QName[] excludeChildAssocs, QName childAssocQName) {
            for (QName excludeChildAssoc : excludeChildAssocs) {
                if (!childAssocQName.equals((Object)excludeChildAssoc)) continue;
                return true;
            }
            return false;
        }

        private boolean isExcludedAspectProperty(QName[] excludeAspects, QName propertyQName) {
            PropertyDefinition propDef = ExporterComponent.this.dictionaryService.getProperty(propertyQName);
            if (propDef == null) {
                return false;
            }
            ClassDefinition classDef = propDef.getContainerClass();
            if (classDef == null || !classDef.isAspect()) {
                return false;
            }
            return this.isExcludedAspect(excludeAspects, classDef.getName());
        }

        private boolean isExcludedAspectAssociation(QName[] excludeAspects, QName associationQName) {
            AssociationDefinition assocDef = ExporterComponent.this.dictionaryService.getAssociation(associationQName);
            if (assocDef == null) {
                return false;
            }
            ClassDefinition classDef = assocDef.getSourceClass();
            if (classDef == null || !classDef.isAspect()) {
                return false;
            }
            return this.isExcludedAspect(excludeAspects, classDef.getName());
        }

        private boolean isWithinExport(NodeRef nodeRef, ExporterCrawlerParameters parameters) {
            boolean isWithin = false;
            block0: for (NodeRef exportRoot : this.context.getExportList()) {
                if (nodeRef.equals((Object)exportRoot) && parameters.isCrawlSelf()) {
                    isWithin = true;
                    continue;
                }
                Path nodePath = ExporterComponent.this.nodeService.getPath(nodeRef);
                for (int i = nodePath.size() - 1; i >= 0; --i) {
                    Path.ChildAssocElement pathElement = (Path.ChildAssocElement)nodePath.get(i);
                    if (!pathElement.getRef().getChildRef().equals((Object)exportRoot)) continue;
                    isWithin = true;
                    continue block0;
                }
            }
            return isWithin;
        }
    }
}

