/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;

public class CommentServiceImpl
implements CommentService {
    private static Log logger = LogFactory.getLog(CommentServiceImpl.class);
    private static final QName FORUM_TO_TOPIC_ASSOC_QNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments");
    private static final String COMMENTS_TOPIC_NAME = "Comments";
    private static final String CANNED_QUERY_GET_CHILDREN = "commentsGetChildrenCannedQueryFactory";
    private NodeService nodeService;
    private ContentService contentService;
    private ActivityService activityService;
    private SiteService siteService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    @Override
    public NodeRef getDiscussableAncestor(NodeRef descendantNodeRef) {
        NodeRef discussableNode;
        NodeRef forumNode;
        NodeRef topicNode;
        NodeRef result = null;
        if (this.nodeService.getType(descendantNodeRef).equals((Object)ForumModel.TYPE_POST) && this.nodeService.getType(topicNode = this.nodeService.getPrimaryParent(descendantNodeRef).getParentRef()).equals((Object)ForumModel.TYPE_TOPIC) && this.nodeService.getType(forumNode = this.nodeService.getPrimaryParent(topicNode).getParentRef()).equals((Object)ForumModel.TYPE_FORUM) && this.nodeService.hasAspect(discussableNode = this.nodeService.getPrimaryParent(forumNode).getParentRef(), ForumModel.ASPECT_DISCUSSABLE)) {
            result = discussableNode;
        }
        return result;
    }

    @Override
    public PagingResults<NodeRef> listComments(NodeRef discussableNode, PagingRequest paging) {
        NodeRef commentsFolder = this.getShareCommentsTopic(discussableNode);
        if (commentsFolder != null) {
            ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
            sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)false));
            GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
            GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(commentsFolder, null, null, null, null, sort, paging);
            CannedQueryResults results = cq.execute();
            return results;
        }
        return new EmptyPagingResults();
    }

    @Override
    public NodeRef getShareCommentsTopic(NodeRef discussableNode) {
        NodeRef firstForumNode;
        List topics;
        List fora;
        NodeRef result = null;
        if (this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE) && !(fora = this.nodeService.getChildAssocs(discussableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)ForumModel.ASSOC_DISCUSSION, true)).isEmpty() && !(topics = this.nodeService.getChildAssocs(firstForumNode = ((ChildAssociationRef)fora.get(0)).getChildRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)FORUM_TO_TOPIC_ASSOC_QNAME, true)).isEmpty()) {
            NodeRef firstTopicNode;
            result = firstTopicNode = ((ChildAssociationRef)topics.get(0)).getChildRef();
        }
        return result;
    }

    private String getSiteId(final NodeRef nodeRef) {
        String siteId = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return CommentServiceImpl.this.siteService.getSiteShortName(nodeRef);
            }
        });
        return siteId;
    }

    private JSONObject getActivityData(String siteId, NodeRef nodeRef) {
        if (siteId != null) {
            JSONObject json = new JSONObject();
            json.put((Object)"title", (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            try {
                StringBuilder sb = new StringBuilder("document-details?nodeRef=");
                sb.append(URLEncoder.encode(nodeRef.toString(), "UTF-8"));
                json.put((Object)"page", (Object)sb.toString());
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)"Unable to urlencode page for create comment activity");
            }
            return json;
        }
        logger.warn((Object)("Unable to determine site in which node " + nodeRef + " resides."));
        return null;
    }

    private void postActivity(String siteId, String activityType, JSONObject activityData) {
        if (activityData != null) {
            this.activityService.postActivity(activityType, siteId, "comments", activityData.toString());
        }
    }

    @Override
    public NodeRef createComment(NodeRef discussableNode, String title, String comment, boolean suppressRollups) {
        if (comment == null) {
            throw new IllegalArgumentException("Must provide a non-null comment");
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE)) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        if (!this.nodeService.hasAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP) && !suppressRollups) {
            this.nodeService.addAspect(discussableNode, ForumModel.ASPECT_COMMENTS_ROLLUP, null);
        }
        NodeRef forumNode = ((ChildAssociationRef)this.nodeService.getChildAssocs(discussableNode, (QNamePattern)ForumModel.ASSOC_DISCUSSION, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion")).get(0)).getChildRef();
        List existingTopics = this.nodeService.getChildAssocs(forumNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)COMMENTS_TOPIC_NAME));
        NodeRef topicNode = null;
        if (existingTopics.isEmpty()) {
            HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
            props.put(ContentModel.PROP_NAME, COMMENTS_TOPIC_NAME);
            topicNode = this.nodeService.createNode(forumNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)COMMENTS_TOPIC_NAME), ForumModel.TYPE_TOPIC, props).getChildRef();
        } else {
            topicNode = ((ChildAssociationRef)existingTopics.get(0)).getChildRef();
        }
        NodeRef postNode = this.nodeService.createNode(topicNode, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ForumModel.TYPE_POST).getChildRef();
        this.nodeService.setProperty(postNode, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        this.nodeService.setProperty(postNode, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        ContentWriter writer = this.contentService.getWriter(postNode, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(comment);
        String siteId = this.getSiteId(discussableNode);
        JSONObject activityData = this.getActivityData(siteId, discussableNode);
        this.postActivity(siteId, "org.alfresco.comments.comment-created", activityData);
        return postNode;
    }

    @Override
    public void updateComment(NodeRef commentNodeRef, String title, String comment) {
        QName nodeType = this.nodeService.getType(commentNodeRef);
        if (!nodeType.equals((Object)ForumModel.TYPE_POST)) {
            throw new IllegalArgumentException("Node to update is not a comment node.");
        }
        ContentWriter writer = this.contentService.getWriter(commentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.putContent(comment);
        if (title != null) {
            this.nodeService.setProperty(commentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        }
        String siteId = this.getSiteId(commentNodeRef);
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        if (discussableNodeRef != null) {
            JSONObject activityData = this.getActivityData(siteId, discussableNodeRef);
            this.postActivity(siteId, "org.alfresco.comments.comment-updated", activityData);
        } else {
            logger.warn((Object)("Unable to determine discussable node for the comment with nodeRef " + commentNodeRef + ", not posting an activity"));
        }
    }

    @Override
    public void deleteComment(NodeRef commentNodeRef) {
        QName nodeType = this.nodeService.getType(commentNodeRef);
        if (!nodeType.equals((Object)ForumModel.TYPE_POST)) {
            throw new IllegalArgumentException("Node to delete is not a comment node.");
        }
        String siteId = this.getSiteId(commentNodeRef);
        NodeRef discussableNodeRef = this.getDiscussableAncestor(commentNodeRef);
        JSONObject activityData = null;
        if (discussableNodeRef != null) {
            activityData = this.getActivityData(siteId, discussableNodeRef);
        }
        this.nodeService.deleteNode(commentNodeRef);
        if (activityData != null) {
            this.postActivity(siteId, "org.alfresco.comments.comment-deleted", activityData);
        } else {
            logger.warn((Object)("Unable to determine discussable node for the comment with nodeRef " + commentNodeRef + ", not posting an activity"));
        }
    }
}

