/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.Importer;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultContentHandler
implements ImportContentHandler,
ErrorHandler {
    private ImportContentHandler targetHandler = null;
    private Importer importer = null;

    public DefaultContentHandler(ImportContentHandler targetHandler) {
        ParameterCheck.mandatory((String)"targetHandler", (Object)targetHandler);
        this.targetHandler = targetHandler;
    }

    @Override
    public void setImporter(Importer importer) {
        this.importer = importer;
        this.targetHandler.setImporter(importer);
    }

    @Override
    public InputStream importStream(String content) {
        return this.targetHandler.importStream(content);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.targetHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.importer.start();
        this.targetHandler.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() throws SAXException {
        try {
            this.targetHandler.endDocument();
        }
        finally {
            this.importer.end();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.targetHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.targetHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.targetHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.targetHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.targetHandler.skippedEntity(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.targetHandler.error(exception);
        }
        finally {
            this.importer.error(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.targetHandler.error(exception);
        }
        finally {
            this.importer.error(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.targetHandler.warning(exception);
    }
}

