/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.jscript.AVMNode;
import org.alfresco.repo.jscript.AVMScriptStore;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.util.WCMUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.util.ParameterCheck;

public final class AVM
extends BaseScopableProcessorExtension {
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public Scriptable getStores() {
        List<AVMStoreDescriptor> stores = this.services.getAVMService().getStores();
        Object[] results = new Object[stores.size()];
        int i = 0;
        for (AVMStoreDescriptor store : stores) {
            results[i++] = new AVMScriptStore(this.services, store, this.getScope());
        }
        return Context.getCurrentContext().newArray(this.getScope(), results);
    }

    public AVMScriptStore lookupStore(String store) {
        ParameterCheck.mandatoryString((String)"Store", (String)store);
        AVMScriptStore avmStore = null;
        AVMStoreDescriptor descriptor = this.services.getAVMService().getStore(store);
        if (descriptor != null) {
            avmStore = new AVMScriptStore(this.services, descriptor, this.getScope());
        }
        return avmStore;
    }

    public AVMNode lookupStoreRoot(String store) {
        AVMNode rootNode = null;
        if (store != null && store.length() != 0) {
            String rootPath = store + ':' + AVM.getWebappsFolderPath();
            AVMNodeDescriptor nodeDesc = this.services.getAVMService().lookup(-1, rootPath);
            if (nodeDesc != null) {
                rootNode = new AVMNode(AVMNodeConverter.ToNodeRef(-1, rootPath), this.services, this.getScope());
            }
        }
        return rootNode;
    }

    public AVMNode lookupNode(String path) {
        AVMNodeDescriptor nodeDesc;
        AVMNode node = null;
        if (path != null && path.length() != 0 && (nodeDesc = this.services.getAVMService().lookup(-1, path)) != null) {
            node = new AVMNode(AVMNodeConverter.ToNodeRef(-1, path), this.services, this.getScope());
        }
        return node;
    }

    public List<AVMNode> getModifiedItems(String storeId, String username, String webapp) {
        ParameterCheck.mandatoryString((String)"Store ID", (String)storeId);
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        ParameterCheck.mandatoryString((String)"Webapp", (String)webapp);
        SandboxService sbService = this.services.getSandboxService();
        String userStoreId = AVM.userSandboxStore(storeId, username);
        List<AssetInfo> assets = sbService.listChangedWebApp(userStoreId, webapp, false);
        ArrayList<AVMNode> items = new ArrayList<AVMNode>(assets.size());
        for (AssetInfo asset : assets) {
            items.add(new AVMNode(asset.getAvmPath(), -1, this.services, this.getScope()));
        }
        return items;
    }

    public static String stagingStore(String storeId) {
        return WCMUtil.buildStagingStoreName(storeId);
    }

    public static String userSandboxStore(String storeId, String username) {
        return WCMUtil.buildUserMainStoreName(storeId, username);
    }

    public String websiteStagingUrl(String storeId) {
        return this.services.getPreviewURIService().getPreviewURI(storeId, null);
    }

    public String websiteUserSandboxUrl(String storeId, String username) {
        ParameterCheck.mandatoryString((String)"Store ID", (String)storeId);
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        return this.websiteStagingUrl(AVM.userSandboxStore(storeId, username));
    }

    public String assetUrl(String storeId, String assetPath) {
        return this.services.getPreviewURIService().getPreviewURI(storeId, assetPath);
    }

    public String assetUrl(String avmPath) {
        ParameterCheck.mandatoryString((String)"AVM Path", (String)avmPath);
        String[] s = avmPath.split(":");
        if (s.length != 2) {
            throw new IllegalArgumentException("Expected exactly one ':' in " + avmPath);
        }
        return this.assetUrl(s[0], s[1]);
    }

    public static String getWebappsFolderPath() {
        return "/www/avm_webapps";
    }
}

