/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.alfresco.repo.jscript.Behaviour;
import org.alfresco.repo.policy.BaseBehaviour;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ScriptBehaviour
extends BaseBehaviour {
    private ServiceRegistry serviceRegistry;
    private ScriptLocation location;

    public ScriptBehaviour() {
    }

    public ScriptBehaviour(ServiceRegistry serviceRegistry, ScriptLocation location) {
        this(serviceRegistry, location, Behaviour.NotificationFrequency.EVERY_EVENT);
    }

    public ScriptBehaviour(ServiceRegistry serviceRegistry, ScriptLocation location, Behaviour.NotificationFrequency frequency) {
        super(frequency);
        ParameterCheck.mandatory((String)"Location", (Object)location);
        ParameterCheck.mandatory((String)"ServiceRegistry", (Object)serviceRegistry);
        this.location = location;
        this.serviceRegistry = serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setLocation(ScriptLocation location) {
        this.location = location;
    }

    public String toString() {
        return "JavaScript behaviour[location = " + this.location.toString() + "]";
    }

    @Override
    public synchronized <T> T getInterface(Class<T> policy) {
        ParameterCheck.mandatory((String)"Policy class", policy);
        Object proxy = this.proxies.get(policy);
        if (proxy == null) {
            Method[] policyIFMethods = policy.getMethods();
            if (policyIFMethods.length != 1) {
                throw new PolicyException("Policy interface " + policy.getCanonicalName() + " must have only one method");
            }
            JavaScriptInvocationHandler handler = new JavaScriptInvocationHandler(this);
            proxy = Proxy.newProxyInstance(policy.getClassLoader(), new Class[]{policy}, (InvocationHandler)handler);
            this.proxies.put(policy, proxy);
        }
        return (T)proxy;
    }

    private static class JavaScriptInvocationHandler
    implements InvocationHandler {
        private ScriptBehaviour behaviour;

        private JavaScriptInvocationHandler(ScriptBehaviour behaviour) {
            this.behaviour = behaviour;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                if (Proxy.isProxyClass(args[0].getClass())) {
                    return this.equals(Proxy.getInvocationHandler(args[0]));
                }
                return false;
            }
            if (this.behaviour.isEnabled()) {
                try {
                    this.behaviour.disable();
                    Object object = this.invokeScript(method, args);
                    return object;
                }
                finally {
                    this.behaviour.enable();
                }
            }
            return null;
        }

        private Object invokeScript(Method method, Object[] args) {
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("behaviour", new Behaviour(this.behaviour.serviceRegistry, method.getName(), args));
            return this.behaviour.serviceRegistry.getScriptService().executeScript(this.behaviour.location, model);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof JavaScriptInvocationHandler)) {
                return false;
            }
            JavaScriptInvocationHandler other = (JavaScriptInvocationHandler)obj;
            return this.behaviour.location.equals(other.behaviour.location);
        }

        public int hashCode() {
            return 37 * this.behaviour.location.hashCode();
        }

        public String toString() {
            return "JavaScriptBehaviour[location=" + this.behaviour.location.toString() + "]";
        }
    }
}

