/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.BasePropertyDecorator;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class CategoryPropertyDecorator
extends BasePropertyDecorator {
    private static Log logger = LogFactory.getLog(CategoryPropertyDecorator.class);

    @Override
    public JSONAware decorate(QName propertyName, NodeRef nodeRef, Serializable value) {
        Collection collection = (Collection)((Object)value);
        JSONArray array = new JSONArray();
        for (NodeRef obj : collection) {
            try {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"name", (Object)this.nodeService.getProperty(obj, ContentModel.PROP_NAME));
                jsonObj.put((Object)"path", (Object)this.getPath(obj));
                jsonObj.put((Object)"nodeRef", (Object)obj.toString());
                array.add((Object)jsonObj);
            }
            catch (InvalidNodeRefException e) {
                logger.warn((Object)("Category with nodeRef " + obj.toString() + " does not exist."));
            }
        }
        return array;
    }

    public String getPath(NodeRef nodeRef) {
        String displayPath = this.nodeService.getPath(nodeRef).toDisplayPath(this.nodeService, this.permissionService);
        return displayPath.replaceFirst("/categories/General", "");
    }
}

