/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.lock.LockServicePolicies;
import org.alfresco.repo.lock.LockUtils;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.lock.mem.LockableAspectInterceptor;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.springframework.util.Assert;

public class LockServiceImpl
implements LockService,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeUpdateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyNodePolicy,
VersionServicePolicies.OnCreateVersionPolicy,
TransactionListener {
    public static final int MAX_EPHEMERAL_LOCK_SECONDS = 172800;
    private static final String KEY_IGNORE_NODES = "lockService.ignoreNodes";
    private static final Object KEY_MODIFIED_NODES = "lockService.lockedNode";
    private NodeService nodeService;
    private TenantService tenantService;
    private AuthenticationService authenticationService;
    private SearchService searchService;
    private BehaviourFilter behaviourFilter;
    private LockStore lockStore;
    private PolicyComponent policyComponent;
    private LockableAspectInterceptor lockableAspectInterceptor;
    private ClassPolicyDelegate<LockServicePolicies.BeforeLock> beforeLock;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setLockableAspectInterceptor(LockableAspectInterceptor lockableAspectInterceptor) {
        this.lockableAspectInterceptor = lockableAspectInterceptor;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        this.beforeLock = this.policyComponent.registerClassPolicy(LockServicePolicies.BeforeLock.class);
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeUpdateNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeUpdateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, ContentModel.ASPECT_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
    }

    private List<QName> getInvokeClasses(NodeRef nodeRef) {
        ArrayList<QName> result = new ArrayList<QName>(10);
        result.add(this.nodeService.getType(nodeRef));
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            result.add(aspect);
        }
        return result;
    }

    private void invokeBeforeLock(NodeRef nodeRef, LockType lockType) {
        if (!this.nodeService.exists(nodeRef)) {
            return;
        }
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<LockServicePolicies.BeforeLock> policies = this.beforeLock.getList(invokeClass);
            for (LockServicePolicies.BeforeLock policy : policies) {
                policy.beforeLock(nodeRef, lockType);
            }
        }
    }

    private void addToIgnoreSet(NodeRef nodeRef) {
        HashSet<NodeRef> ignoreNodeRefs = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs == null) {
            ignoreNodeRefs = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_IGNORE_NODES, ignoreNodeRefs);
        }
        ignoreNodeRefs.add(nodeRef);
    }

    private void removeFromIgnoreSet(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            ignoreNodeRefs.remove(nodeRef);
        }
    }

    private boolean ignore(NodeRef nodeRef) {
        Set ignoreNodeRefs = (Set)AlfrescoTransactionSupport.getResource(KEY_IGNORE_NODES);
        if (ignoreNodeRefs != null) {
            return ignoreNodeRefs.contains(nodeRef);
        }
        return false;
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType) {
        this.lock(nodeRef, lockType, 0);
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire) {
        this.lock(nodeRef, lockType, timeToExpire, Lifetime.PERSISTENT);
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime) {
        this.lock(nodeRef, lockType, timeToExpire, lifetime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, Lifetime lifetime, String additionalInfo) {
        this.invokeBeforeLock(nodeRef, lockType);
        if (additionalInfo != null && !lifetime.equals((Object)Lifetime.EPHEMERAL)) {
            throw new IllegalArgumentException("additionalInfo may only be provided for ephemeral locks.");
        }
        if (lifetime.equals((Object)Lifetime.EPHEMERAL) && timeToExpire > 172800) {
            throw new IllegalArgumentException("Attempt to create ephemeral lock for " + timeToExpire + " seconds - exceeds maximum allowed time.");
        }
        nodeRef = this.tenantService.getName(nodeRef);
        String userName = this.getUserName();
        if (lockType == null) {
            lockType = LockType.WRITE_LOCK;
        }
        Pair<LockState, LockStatus> statusAndState = this.getLockStateAndStatus(nodeRef, userName);
        LockState currentLockInfo = (LockState)statusAndState.getFirst();
        LockStatus currentLockStatus = (LockStatus)((Object)statusAndState.getSecond());
        if (LockStatus.LOCKED.equals((Object)currentLockStatus)) {
            throw new UnableToAquireLockException(nodeRef);
        }
        if (LockStatus.NO_LOCK.equals((Object)currentLockStatus) || LockStatus.LOCK_EXPIRED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus)) {
            Date expiryDate = this.makeExpiryDate(timeToExpire);
            if (lifetime == Lifetime.PERSISTENT) {
                this.lockableAspectInterceptor.disableForThread();
                try {
                    this.ensureLockAspect(nodeRef);
                    this.persistLockProps(nodeRef, lockType, lifetime, userName, expiryDate);
                }
                finally {
                    this.lockableAspectInterceptor.enableForThread();
                }
            } else if (lifetime == Lifetime.EPHEMERAL) {
                LockState lock = LockState.createLock(nodeRef, lockType, userName, expiryDate, lifetime, additionalInfo);
                this.lockStore.set(nodeRef, lock);
                TransactionalResourceHelper.getMap(KEY_MODIFIED_NODES).put(nodeRef, currentLockInfo);
                AlfrescoTransactionSupport.bindListener(this);
            } else {
                throw new IllegalStateException(((Object)((Object)lifetime)).getClass().getSimpleName() + " is not a valid value: " + lifetime.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistLockProps(NodeRef nodeRef, LockType lockType, Lifetime lifetime, String userName, Date expiryDate) {
        this.addToIgnoreSet(nodeRef);
        try {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)userName));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)lockType.toString()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME, (Serializable)((Object)lifetime.toString()));
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE, (Serializable)expiryDate);
        }
        finally {
            this.removeFromIgnoreSet(nodeRef);
        }
    }

    private Date makeExpiryDate(int timeToExpire) {
        Date expiryDate = null;
        if (timeToExpire > 0) {
            expiryDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiryDate);
            calendar.add(13, timeToExpire);
            expiryDate = calendar.getTime();
        }
        return expiryDate;
    }

    @Override
    public void lock(NodeRef nodeRef, LockType lockType, int timeToExpire, boolean lockChildren) throws UnableToAquireLockException {
        this.lock(nodeRef, lockType, timeToExpire);
        if (lockChildren) {
            List childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.lock(childAssocRef.getChildRef(), lockType, timeToExpire, lockChildren);
            }
        }
    }

    @Override
    public void lock(Collection<NodeRef> nodeRefs, LockType lockType, int timeToExpire) throws UnableToAquireLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.lock(nodeRef, lockType, timeToExpire);
        }
    }

    @Override
    public void unlock(NodeRef nodeRef) throws UnableToReleaseLockException {
        this.unlock(nodeRef, false, false);
    }

    @Override
    public void unlock(NodeRef nodeRef, boolean lockChildren) throws UnableToReleaseLockException {
        this.unlock(nodeRef, lockChildren, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void unlock(NodeRef nodeRef, boolean unlockChildren, boolean allowCheckedOut) throws UnableToReleaseLockException {
        lockState = this.getLockState(nodeRef = this.tenantService.getName(nodeRef));
        if (lockState.isLockInfo()) {
            if (!allowCheckedOut && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
                throw new UnableToReleaseLockException(nodeRef, UnableToReleaseLockException.CAUSE.CHECKED_OUT);
            }
            lifetime = lockState.getLifetime();
            if (lifetime == Lifetime.PERSISTENT) {
                this.addToIgnoreSet(nodeRef);
                this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                this.lockableAspectInterceptor.disableForThread();
                try {
                    if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) ** GOTO lbl23
                    this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                    this.lockableAspectInterceptor.enableForThread();
                    this.removeFromIgnoreSet(nodeRef);
                }
            } else if (lifetime == Lifetime.EPHEMERAL) {
                this.lockStore.set(nodeRef, LockState.createUnlocked(nodeRef));
            } else {
                throw new IllegalStateException("Unhandled Lifetime value: " + (Object)lifetime);
            }
        }
lbl23:
        // 5 sources

        if (unlockChildren) {
            childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                this.unlock(childAssocRef.getChildRef(), unlockChildren);
            }
        }
    }

    @Override
    public void unlock(Collection<NodeRef> nodeRefs) throws UnableToReleaseLockException {
        for (NodeRef nodeRef : nodeRefs) {
            this.unlock(nodeRef);
        }
    }

    @Override
    public LockStatus getLockStatus(NodeRef nodeRef) {
        nodeRef = this.tenantService.getName(nodeRef);
        return this.getLockStatus(nodeRef, this.getUserName());
    }

    @Override
    public LockStatus getLockStatus(NodeRef nodeRef, String userName) {
        Pair<LockState, LockStatus> stateAndStatus = this.getLockStateAndStatus(nodeRef, userName);
        LockStatus lockStatus = (LockStatus)((Object)stateAndStatus.getSecond());
        return lockStatus;
    }

    private Pair<LockState, LockStatus> getLockStateAndStatus(NodeRef nodeRef, String userName) {
        LockState lockState = this.getLockState(nodeRef);
        String lockOwner = lockState.getOwner();
        Date expiryDate = lockState.getExpires();
        LockStatus status = LockUtils.lockStatus(userName, lockOwner, expiryDate);
        return new Pair((Object)lockState, (Object)status);
    }

    @Override
    public LockType getLockType(NodeRef nodeRef) {
        String lockTypeString;
        LockType result = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeString = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
            result = LockType.valueOf(lockTypeString);
        }
        return result;
    }

    private void ensureLockAspect(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
    }

    @Override
    public void checkForLock(NodeRef nodeRef) throws NodeLockedException {
        String userName = this.getUserName();
        if ((nodeRef = this.tenantService.getName(nodeRef)) != null && userName != null) {
            String effectiveUserName = AuthenticationUtil.getRunAsUser();
            if (!this.ignore(nodeRef) && !this.tenantService.getBaseNameUser(effectiveUserName).equals(AuthenticationUtil.getSystemUserName())) {
                try {
                    LockStatus currentLockStatus = this.getLockStatus(nodeRef, userName);
                    LockType lockType = this.getLockType(nodeRef);
                    if (LockType.WRITE_LOCK.equals((Object)lockType) && LockStatus.LOCKED.equals((Object)currentLockStatus)) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.READ_ONLY_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                    if (LockType.NODE_LOCK.equals((Object)lockType) && (LockStatus.LOCKED.equals((Object)currentLockStatus) || LockStatus.LOCK_OWNER.equals((Object)currentLockStatus))) {
                        throw new NodeLockedException(nodeRef);
                    }
                }
                catch (AspectMissingException exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        LockType lockType = this.getLockType(childAssocRef.getParentRef());
        if (lockType != null) {
            switch (lockType) {
                case WRITE_LOCK: 
                case READ_ONLY_LOCK: {
                    this.checkForLock(childAssocRef.getParentRef());
                    break;
                }
            }
        }
    }

    @Override
    public void beforeUpdateNode(NodeRef nodeRef) {
        this.checkForLock(nodeRef);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.checkForLock(nodeRef);
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    @Override
    public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        nodeDetails.addAspect(ContentModel.ASPECT_LOCKABLE);
    }

    private String getUserName() {
        return this.authenticationService.getCurrentUserName();
    }

    @Deprecated
    public List<NodeRef> getLocks(StoreRef storeRef) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private List<NodeRef> getLocks(StoreRef storeRef, String query) {
        ArrayList<NodeRef> result = new ArrayList();
        try (ResultSet resultSet = null;){
            resultSet = this.searchService.query(storeRef, "lucene", query);
            result = resultSet.getNodeRefs();
        }
        return result;
    }

    @Deprecated
    public List<NodeRef> getLocks(StoreRef storeRef, LockType lockType) {
        return this.getLocks(storeRef, "ASPECT:\"" + ContentModel.ASPECT_LOCKABLE.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_OWNER.getLocalName() + ":\"" + this.getUserName() + "\"" + " +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_LOCK_TYPE.getLocalName() + ":\"" + lockType.toString() + "\"");
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef nodeRef = oldChildAssocRef.getChildRef();
        this.checkForLock(nodeRef);
    }

    @Override
    public void suspendLocks() {
        this.getBehaviourFilter().disableBehaviour(ContentModel.ASPECT_LOCKABLE);
    }

    @Override
    public void enableLocks() {
        this.getBehaviourFilter().enableBehaviour(ContentModel.ASPECT_LOCKABLE);
    }

    @Override
    public String getAdditionalInfo(NodeRef nodeRef) {
        LockState lockState = this.getLockState(nodeRef);
        String additionalInfo = lockState.getAdditionalInfo();
        return additionalInfo;
    }

    @Override
    public LockState getLockState(NodeRef nodeRef) {
        LockState lockState = this.lockStore.get(nodeRef);
        if (lockState == null) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                String lockOwner = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
                Date expiryDate = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE);
                String lockTypeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
                LockType lockType = lockTypeStr != null ? LockType.valueOf(lockTypeStr) : null;
                String lifetimeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME));
                Lifetime lifetime = lifetimeStr != null ? Lifetime.valueOf(lifetimeStr) : null;
                lockState = LockState.createLock(nodeRef, lockType, lockOwner, expiryDate, lifetime, null);
            } else {
                lockState = LockState.createUnlocked(nodeRef);
            }
        }
        Assert.notNull((Object)lockState);
        return lockState;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
        Map lockedNodes = TransactionalResourceHelper.getMap(KEY_MODIFIED_NODES);
        for (LockState lockInfo : lockedNodes.values()) {
            this.lockStore.set(lockInfo.getNodeRef(), lockInfo);
        }
    }
}

