/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class NodeRefPropertyMethodInterceptor
implements MethodInterceptor {
    private boolean filterOnGet = true;
    private boolean filterOnSet = true;
    private transient DictionaryService dictionaryService;
    private transient NodeService nodeService;

    public boolean isFilterOnGet() {
        return this.filterOnGet;
    }

    public void setFilterOnGet(boolean filterOnGet) {
        this.filterOnGet = filterOnGet;
    }

    public boolean isFilterOnSet() {
        return this.filterOnSet;
    }

    public void setFilterOnSet(boolean filterOnSet) {
        this.filterOnSet = filterOnSet;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        Object[] in = new Object[args.length];
        System.arraycopy(args, 0, in, 0, args.length);
        invocation.getStaticPart();
        try {
            if (methodName.equals("addAspect")) {
                if (this.filterOnSet) {
                    NodeRef nodeRef = (NodeRef)args[0];
                    QName aspectType = (QName)args[1];
                    Map newProperties = (Map)args[2];
                    if (newProperties == null) {
                        args[2] = newProperties;
                        Object object = invocation.proceed();
                        return object;
                    }
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[2] = convertedProperties;
                    Object i$ = invocation.proceed();
                    return i$;
                }
                Object nodeRef = invocation.proceed();
                return nodeRef;
            }
            if (methodName.equals("createNode") && args.length == 5) {
                if (this.filterOnSet) {
                    NodeRef parentRef = (NodeRef)args[0];
                    QName assocTypeQName = (QName)args[1];
                    QName assocQName = (QName)args[2];
                    QName nodeTypeQName = (QName)args[3];
                    Map newProperties = (Map)args[4];
                    if (newProperties == null) {
                        args[4] = newProperties;
                        Object entry = invocation.proceed();
                        return entry;
                    }
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[4] = newProperties;
                    Object i$ = invocation.proceed();
                    return i$;
                }
                Object parentRef = invocation.proceed();
                return parentRef;
            }
            if (methodName.equals("getProperty")) {
                if (this.filterOnGet) {
                    NodeRef nodeRef = (NodeRef)args[0];
                    QName propertyQName = (QName)args[1];
                    Serializable value = (Serializable)invocation.proceed();
                    Serializable nodeTypeQName = this.getValue(propertyQName, value);
                    return nodeTypeQName;
                }
                Object nodeRef = invocation.proceed();
                return nodeRef;
            }
            if (methodName.equals("getProperties")) {
                if (this.filterOnGet) {
                    NodeRef nodeRef = (NodeRef)args[0];
                    Map properties = (Map)invocation.proceed();
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(properties.size() * 2);
                    for (Map.Entry entry : properties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        Serializable convertedValue = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, convertedValue);
                    }
                    HashMap<QName, Serializable> i$ = convertedProperties;
                    return i$;
                }
                Object nodeRef = invocation.proceed();
                return nodeRef;
            }
            if (methodName.equals("setProperties")) {
                if (this.filterOnSet) {
                    NodeRef nodeRef = (NodeRef)args[0];
                    Map newProperties = (Map)args[1];
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[1] = convertedProperties;
                    Object object = invocation.proceed();
                    return object;
                }
                Object nodeRef = invocation.proceed();
                return nodeRef;
            }
            if (methodName.equals("setProperty")) {
                if (this.filterOnSet) {
                    NodeRef nodeRef = (NodeRef)args[0];
                    QName propertyQName = (QName)args[1];
                    Serializable value = (Serializable)args[2];
                    value = this.getValue(propertyQName, value);
                    args[2] = value;
                    Object object = invocation.proceed();
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            System.arraycopy(in, 0, args, 0, in.length);
        }
    }

    private Serializable getValue(QName propertyQName, Serializable inboundValue) {
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyQName);
        if (propertyDef == null) {
            return inboundValue;
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) {
            if (inboundValue instanceof Collection) {
                HashSet<NodeRef> categories = new HashSet<NodeRef>();
                Collection in = (Collection)((Object)inboundValue);
                ArrayList<NodeRef> out = new ArrayList<NodeRef>(in.size());
                for (Object o : in) {
                    Serializable value = (Serializable)o;
                    if (value == null) {
                        out.add(null);
                        continue;
                    }
                    try {
                        NodeRef test = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)value);
                        if (!this.getNodeService().exists(test)) continue;
                        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) {
                            QName type = this.getNodeService().getType(test);
                            if (!this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY) || categories.contains(test)) continue;
                            out.add(test);
                            categories.add(test);
                            continue;
                        }
                        out.add(test);
                    }
                    catch (TypeConversionException e) {}
                }
                return out;
            }
            if (inboundValue == null) {
                return inboundValue;
            }
            try {
                NodeRef test = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)inboundValue);
                if (this.getNodeService().exists(test)) {
                    if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) {
                        QName type = this.getNodeService().getType(test);
                        if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY)) {
                            return test;
                        }
                        return null;
                    }
                    return test;
                }
                return null;
            }
            catch (TypeConversionException e) {
                return null;
            }
        }
        return inboundValue;
    }
}

