/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.policy.AssociationPolicy;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.CachedPolicyFactory;
import org.alfresco.repo.policy.ClassFeatureBehaviourBinding;
import org.alfresco.repo.policy.PolicyList;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public class AssociationPolicyDelegate<P extends AssociationPolicy> {
    private DictionaryService dictionary;
    private CachedPolicyFactory<ClassFeatureBehaviourBinding, P> factory;

    AssociationPolicyDelegate(DictionaryService dictionary, Class<P> policyClass, BehaviourIndex<ClassFeatureBehaviourBinding> index) {
        Collection<BehaviourDefinition> definitions = index.getAll();
        for (BehaviourDefinition definition : definitions) {
            definition.getBehaviour().getInterface(policyClass);
        }
        this.factory = new CachedPolicyFactory<ClassFeatureBehaviourBinding, P>(policyClass, index);
        this.dictionary = dictionary;
    }

    private void checkAssocType(QName assocTypeQName) throws IllegalArgumentException {
        AssociationDefinition assocDef = this.dictionary.getAssociation(assocTypeQName);
        if (assocDef == null) {
            throw new IllegalArgumentException("Association " + assocTypeQName + " has not been defined in the data dictionary");
        }
    }

    public P get(QName classQName, QName assocTypeQName) {
        return this.get(null, classQName, assocTypeQName);
    }

    public P get(NodeRef nodeRef, QName classQName, QName assocTypeQName) {
        this.checkAssocType(assocTypeQName);
        return (P)((AssociationPolicy)this.factory.create(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, assocTypeQName)));
    }

    public Collection<P> getList(QName classQName, QName assocTypeQName) {
        return this.getList(null, classQName, assocTypeQName);
    }

    public Collection<P> getList(NodeRef nodeRef, QName classQName, QName assocTypeQName) {
        this.checkAssocType(assocTypeQName);
        return this.factory.createList(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, assocTypeQName));
    }

    public P get(Set<QName> classQNames, QName assocTypeQName) {
        return this.get(null, classQNames, assocTypeQName);
    }

    public P get(NodeRef nodeRef, Set<QName> classQNames, QName assocTypeQName) {
        this.checkAssocType(assocTypeQName);
        return (P)((AssociationPolicy)this.factory.toPolicy(this.getList(nodeRef, classQNames, assocTypeQName)));
    }

    public Collection<P> getList(Set<QName> classQNames, QName assocTypeQName) {
        return this.getList(null, classQNames, assocTypeQName);
    }

    public Collection<P> getList(NodeRef nodeRef, Set<QName> classQNames, QName assocTypeQName) {
        this.checkAssocType(assocTypeQName);
        HashSet<Object> policies = new HashSet<Object>();
        for (QName classQName : classQNames) {
            AssociationPolicy policy = (AssociationPolicy)this.factory.create(new ClassFeatureBehaviourBinding(this.dictionary, nodeRef, classQName, assocTypeQName));
            if (policy instanceof PolicyList) {
                policies.addAll(((PolicyList)((Object)policy)).getPolicies());
                continue;
            }
            policies.add(policy);
        }
        return policies;
    }
}

