/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.preference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class PreferenceServiceImpl
implements PreferenceService {
    private static final Log log = LogFactory.getLog(PreferenceServiceImpl.class);
    private static final String SHARE_SITES_PREFERENCE_KEY = "org.alfresco.share.sites.favourites.";
    private static final int SHARE_SITES_PREFERENCE_KEY_LEN = "org.alfresco.share.sites.favourites.".length();
    private static final String EXT_SITES_PREFERENCE_KEY = "org.alfresco.ext.sites.favourites.";
    private NodeService nodeService;
    private ContentService contentService;
    private PersonService personService;
    private PermissionService permissionService;
    private AuthenticationContext authenticationContext;
    private AuthorityService authorityService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public Map<String, Serializable> getPreferences(String userName) {
        return this.getPreferences(userName, null);
    }

    private JSONObject getPreferencesObject(String userName) throws JSONException {
        boolean isSystem;
        JSONObject jsonPrefs = null;
        NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Cannot get preferences for " + userName + " because he/she does not exist.");
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean bl = isSystem = AuthenticationUtil.isRunAsUserTheSystemUser() || this.authenticationContext.isSystemUserName(currentUserName);
        if (isSystem || userName.equals(currentUserName) || this.personService.getUserIdentifier(userName).equals(this.personService.getUserIdentifier(currentUserName)) || this.authorityService.isAdminAuthority(currentUserName)) {
            ContentReader reader;
            if (this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES) && (reader = this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES)) != null) {
                jsonPrefs = new JSONObject(reader.getContentString());
            }
        } else {
            throw new AccessDeniedException("The current user " + currentUserName + " does not have sufficient permissions to get the preferences of the user " + userName);
        }
        return jsonPrefs;
    }

    @Override
    public Serializable getPreference(String userName, String preferenceName) {
        String preferenceValue = null;
        try {
            JSONObject jsonPrefs = this.getPreferencesObject(userName);
            if (jsonPrefs != null && jsonPrefs.has(preferenceName)) {
                preferenceValue = jsonPrefs.getString(preferenceName);
            }
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Can not get preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
        }
        return preferenceValue;
    }

    @Override
    public Map<String, Serializable> getPreferences(String userName, String preferenceFilter) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getPreferences(" + userName + ", " + preferenceFilter + ")"));
        }
        TreeMap<String, Serializable> preferences = new TreeMap<String, Serializable>();
        try {
            JSONObject jsonPrefs = this.getPreferencesObject(userName);
            if (jsonPrefs != null) {
                Iterator keys = jsonPrefs.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Serializable value = (Serializable)jsonPrefs.get(key);
                    if (key.startsWith(SHARE_SITES_PREFERENCE_KEY)) {
                        StringBuilder sb;
                        String siteId;
                        int idx;
                        if (key.endsWith(".favourited")) {
                            idx = key.indexOf(".favourited");
                            siteId = key.substring(SHARE_SITES_PREFERENCE_KEY_LEN, idx);
                            sb = new StringBuilder(SHARE_SITES_PREFERENCE_KEY);
                            sb.append(siteId);
                            key = sb.toString();
                        } else if (key.endsWith(".createdAt")) {
                            idx = key.indexOf(".createdAt");
                            siteId = key.substring(SHARE_SITES_PREFERENCE_KEY_LEN, idx);
                            sb = new StringBuilder(EXT_SITES_PREFERENCE_KEY);
                            sb.append(siteId);
                            sb.append(".createdAt");
                            key = sb.toString();
                        } else if (preferences.containsKey(key)) continue;
                    }
                    if (preferenceFilter != null && preferenceFilter.length() != 0 && !this.matchPreferenceNames(key, preferenceFilter)) continue;
                    preferences.put(key, value);
                }
            }
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Can not get preferences for " + userName + " because there was an error parsing the JSON data.", (Throwable)exception);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("result = " + preferences));
        }
        return preferences;
    }

    @Override
    public PagingResults<Pair<String, Serializable>> getPagedPreferences(String userName, String preferenceFilter, PagingRequest pagingRequest) {
        final Map<String, Serializable> prefs = this.getPreferences(userName, preferenceFilter);
        int totalSize = prefs.size();
        int skipCount = pagingRequest.getSkipCount();
        int maxItems = pagingRequest.getMaxItems();
        int end = maxItems == Integer.MAX_VALUE ? totalSize : skipCount + maxItems;
        int pageSize = maxItems == Integer.MAX_VALUE ? totalSize : Math.max(maxItems, totalSize - skipCount);
        final boolean hasMoreItems = end < totalSize;
        final ArrayList<Pair> page = new ArrayList<Pair>(pageSize);
        Iterator<Map.Entry<String, Serializable>> it = prefs.entrySet().iterator();
        for (int counter = 0; counter < end && it.hasNext(); ++counter) {
            Map.Entry<String, Serializable> pref = it.next();
            if (counter < skipCount) continue;
            if (counter > end - 1) break;
            page.add(new Pair((Object)pref.getKey(), (Object)pref.getValue()));
        }
        return new PagingResults<Pair<String, Serializable>>(){

            public List<Pair<String, Serializable>> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return hasMoreItems;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = prefs.size();
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    private boolean matchPreferenceNames(String name, String matchTo) {
        boolean result = true;
        name = name.replace(".", "+");
        String[] nameArr = name.split("\\+");
        String[] matchToArr = (matchTo = matchTo.replace(".", "+")).split("\\+");
        if (matchToArr.length > nameArr.length) {
            return false;
        }
        int index = 0;
        for (String matchToElement : matchToArr) {
            if (!matchToElement.equals(nameArr[index])) {
                result = false;
                break;
            }
            ++index;
        }
        return result;
    }

    @Override
    public void setPreferences(final String userName, final Map<String, Serializable> preferences) {
        final NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Cannot update preferences for " + userName + " because he/she does not exist.");
        }
        if (!this.userCanWritePreferences(userName, personNodeRef)) {
            throw new AccessDeniedException("The current user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have sufficient permissions to update the preferences of the user " + userName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!PreferenceServiceImpl.this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES)) {
                    PreferenceServiceImpl.this.nodeService.addAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES, null);
                }
                try {
                    JSONObject jsonPrefs = new JSONObject();
                    ContentReader reader = PreferenceServiceImpl.this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
                    if (reader != null) {
                        jsonPrefs = new JSONObject(reader.getContentString());
                    }
                    for (Map.Entry entry : preferences.entrySet()) {
                        Object value;
                        String key = (String)entry.getKey();
                        if (key.startsWith(PreferenceServiceImpl.SHARE_SITES_PREFERENCE_KEY)) {
                            String siteId = key.substring(SHARE_SITES_PREFERENCE_KEY_LEN);
                            StringBuilder sb = new StringBuilder(PreferenceServiceImpl.SHARE_SITES_PREFERENCE_KEY);
                            sb.append(siteId);
                            sb.append(".favourited");
                            String testKey = sb.toString();
                            if (jsonPrefs.has(testKey)) {
                                jsonPrefs.remove(testKey);
                            }
                            sb = new StringBuilder(PreferenceServiceImpl.SHARE_SITES_PREFERENCE_KEY);
                            sb.append(siteId);
                            sb.append(".createdAt");
                            testKey = sb.toString();
                            if (jsonPrefs.has(testKey)) {
                                jsonPrefs.remove(testKey);
                            }
                        }
                        if ((value = (Serializable)entry.getValue()) != null && value.equals("CURRENT_DATE")) {
                            Date date = new Date();
                            value = ISO8601DateFormat.format((Date)date);
                        }
                        jsonPrefs.put(key, value);
                    }
                    ContentWriter contentWriter = PreferenceServiceImpl.this.contentService.getWriter(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES, true);
                    contentWriter.setEncoding("UTF-8");
                    contentWriter.setMimetype("text/plain");
                    contentWriter.putContent(jsonPrefs.toString());
                }
                catch (JSONException exception) {
                    throw new AlfrescoRuntimeException("Can not update preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
                }
                return null;
            }
        }, (String)"System");
    }

    @Override
    public void clearPreferences(String userName) {
        this.clearPreferences(userName, null);
    }

    @Override
    public void clearPreferences(final String userName, final String preferenceFilter) {
        final NodeRef personNodeRef = this.personService.getPerson(userName);
        if (personNodeRef == null) {
            throw new AlfrescoRuntimeException("Cannot update preferences for " + userName + " because he/she does not exist.");
        }
        if (!this.userCanWritePreferences(userName, personNodeRef)) {
            throw new AccessDeniedException("The current user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have sufficient permissions to update the preferences of the user " + userName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (PreferenceServiceImpl.this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PREFERENCES)) {
                    try {
                        JSONObject jsonPrefs = new JSONObject();
                        if (preferenceFilter != null && preferenceFilter.length() != 0) {
                            ContentReader reader = PreferenceServiceImpl.this.contentService.getReader(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES);
                            if (reader != null) {
                                jsonPrefs = new JSONObject(reader.getContentString());
                            }
                            ArrayList<String> removeKeys = new ArrayList<String>(10);
                            Iterator keys = jsonPrefs.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                if (preferenceFilter != null && preferenceFilter.length() != 0 && !PreferenceServiceImpl.this.matchPreferenceNames(key, preferenceFilter)) continue;
                                removeKeys.add(key);
                            }
                            for (String removeKey : removeKeys) {
                                jsonPrefs.remove(removeKey);
                            }
                        }
                        ContentWriter contentWriter = PreferenceServiceImpl.this.contentService.getWriter(personNodeRef, ContentModel.PROP_PREFERENCE_VALUES, true);
                        contentWriter.setEncoding("UTF-8");
                        contentWriter.setMimetype("text/plain");
                        contentWriter.putContent(jsonPrefs.toString());
                    }
                    catch (JSONException exception) {
                        throw new AlfrescoRuntimeException("Can not update preferences for " + userName + " because there was an error pasing the JSON data.", (Throwable)exception);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    private boolean userCanWritePreferences(String userName, NodeRef personNodeRef) {
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        return userName.equals(currentUserName) || this.personService.getUserIdentifier(userName).equals(this.personService.getUserIdentifier(currentUserName)) || this.authenticationContext.isSystemUserName(currentUserName) || this.permissionService.hasPermission(personNodeRef, "Write") == AccessStatus.ALLOWED;
    }

    public static class PageDetails {
        private boolean hasMoreItems = false;
        private int pageSize;
        private int skipCount;
        private int maxItems;
        private int end;

        public PageDetails(int pageSize, boolean hasMoreItems, int skipCount, int maxItems, int end) {
            this.hasMoreItems = hasMoreItems;
            this.pageSize = pageSize;
            this.skipCount = skipCount;
            this.maxItems = maxItems;
            this.end = end;
        }

        public int getSkipCount() {
            return this.skipCount;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean hasMoreItems() {
            return this.hasMoreItems;
        }

        public int getPageSize() {
            return this.pageSize;
        }
    }
}

