/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.publishing.ChannelTypePublishingOperations;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractChannelType
implements ChannelType,
ChannelTypePublishingOperations {
    private NodeService nodeService;
    private ChannelService channelService;
    private MetadataEncryptor encryptor;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
        channelService.register(this);
    }

    protected ChannelService getChannelService() {
        return this.channelService;
    }

    public void setEncryptor(MetadataEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    protected MetadataEncryptor getEncryptor() {
        return this.encryptor;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public String getTitle() {
        String title = I18NUtil.getMessage((String)("publishing.channel-type." + this.getId() + ".title"));
        return title == null ? this.getId() : title;
    }

    @Override
    public int getMaximumStatusLength() {
        return 0;
    }

    @Override
    public ChannelType.AuthUrlPair getAuthorisationUrls(Channel channel, String callbackUrl) {
        return new ChannelType.AuthUrlPair(null, callbackUrl);
    }

    @Override
    public final ChannelType.AuthStatus acceptAuthorisationCallback(Channel channel, Map<String, String[]> callbackHeaders, Map<String, String[]> callbackParams) {
        ParameterCheck.mandatory((String)"channel", (Object)channel);
        ParameterCheck.mandatory((String)"callbackHeaders", callbackHeaders);
        ParameterCheck.mandatory((String)"callbackParams", callbackParams);
        if (!this.getId().equals(channel.getChannelType().getId())) {
            throw new IllegalArgumentException("Supplied channel is of the incorrect type. Expected " + this.getId() + "; Received " + channel.getChannelType().getId());
        }
        ChannelType.AuthStatus result = this.internalAcceptAuthorisation(channel, callbackHeaders, callbackParams);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(PublishingModel.PROP_AUTHORISATION_COMPLETE, Boolean.valueOf(ChannelType.AuthStatus.AUTHORISED.equals((Object)result)));
        this.channelService.updateChannel(channel, props);
        return result;
    }

    protected ChannelType.AuthStatus internalAcceptAuthorisation(Channel channel, Map<String, String[]> callbackHeaders, Map<String, String[]> callbackParams) {
        ChannelType.AuthStatus result = ChannelType.AuthStatus.UNAUTHORISED;
        String[] username = callbackParams.get("username");
        String[] password = callbackParams.get("password");
        if (username != null && password != null) {
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(PublishingModel.PROP_CHANNEL_USERNAME, (Serializable)((Object)username[0]));
            props.put(PublishingModel.PROP_CHANNEL_PASSWORD, (Serializable)((Object)password[0]));
            this.channelService.updateChannel(channel, props);
            result = ChannelType.AuthStatus.AUTHORISED;
        }
        return result;
    }

    @Override
    public Resource getIcon(String sizeSuffix) {
        String className = this.getClass().getCanonicalName();
        className = className.replaceAll("\\.", "\\/");
        StringBuilder iconPath = new StringBuilder(className);
        iconPath.append(sizeSuffix).append('.').append(this.getIconFileExtension());
        ClassPathResource resource = new ClassPathResource(iconPath.toString());
        return resource.exists() ? resource : null;
    }

    public String getIconFileExtension() {
        return "png";
    }

    @Override
    public Set<QName> getSupportedContentTypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        return Collections.emptySet();
    }

    @Override
    public void sendStatusUpdate(Channel channel, String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void publish(NodeRef nodeToPublish, Map<QName, Serializable> channelProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unpublish(NodeRef nodeToUnpublish, Map<QName, Serializable> channelProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNodeUrl(NodeRef node) {
        String url = null;
        if (node != null && this.nodeService.exists(node) && this.nodeService.hasAspect(node, PublishingModel.ASPECT_ASSET)) {
            url = (String)((Object)this.nodeService.getProperty(node, PublishingModel.PROP_ASSET_URL));
        }
        return url;
    }
}

