/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.QName;

public class NodeSnapshotTransferImpl
implements NodeSnapshot {
    private final TransferManifestNormalNode transferNode;

    public NodeSnapshotTransferImpl(TransferManifestNormalNode transferNode) {
        this.transferNode = transferNode;
    }

    public List<ChildAssociationRef> getAllParentAssocs() {
        if (this.transferNode == null) {
            return Collections.emptyList();
        }
        return this.transferNode.getParentAssocs();
    }

    @Override
    public Set<QName> getAspects() {
        if (this.transferNode == null) {
            return Collections.emptySet();
        }
        return this.transferNode.getAspects();
    }

    @Override
    public NodeRef getNodeRef() {
        if (this.transferNode == null) {
            return null;
        }
        return this.transferNode.getNodeRef();
    }

    public List<AssociationRef> getOutboundPeerAssociations() {
        if (this.transferNode == null) {
            return Collections.emptyList();
        }
        return this.transferNode.getTargetAssocs();
    }

    public ChildAssociationRef getPrimaryParentAssoc() {
        if (this.transferNode == null) {
            return null;
        }
        return this.transferNode.getPrimaryParentAssoc();
    }

    public Path getPrimaryPath() {
        if (this.transferNode == null) {
            return null;
        }
        return this.transferNode.getParentPath();
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        if (this.transferNode == null) {
            return Collections.emptyMap();
        }
        return this.transferNode.getProperties();
    }

    @Override
    public QName getType() {
        if (this.transferNode == null) {
            return null;
        }
        return this.transferNode.getType();
    }

    @Override
    public String getVersion() {
        return (String)((Object)this.getProperties().get(ContentModel.PROP_VERSION_LABEL));
    }

    public TransferManifestNormalNode getTransferNode() {
        return this.transferNode;
    }
}

