/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;

public class PublishContentActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "publish-content";
    public static final String PARAM_PUBLISH_CHANNEL_NAME = "publishChannelName";
    public static final String PARAM_PUBLISH_CHANNEL_ID = "publishChannelId";
    public static final String PARAM_UNPUBLISH = "unpublish";
    public static final String PARAM_STATUS_UPDATE = "statusUpdate";
    public static final String PARAM_INCLUDE_LINK_IN_STATUS_UPDATE = "includeLinkInStatusUpdate";
    public static final String PARAM_NODE_TO_LINK_STATUS_UPDATE_TO = "nodeToLinkStatusUpdateTo";
    public static final String PARAM_STATUS_UPDATE_CHANNEL_NAMES = "statusUpdateChannelNames";
    public static final String PARAM_STATUS_UPDATE_CHANNEL_IDS = "statusUpdateChannelIds";
    public static final String PARAM_SCHEDULED_TIME = "scheduledTime";
    public static final String PARAM_COMMENT = "comment";
    private static final String MSG_CHANNEL_NOT_FOUND = "publishing.channelNotFound";
    private static final String MSG_NEITHER_CHANNEL_NAME_NOR_ID_SPECIFIED = "publishing.neitherNameNorIdSpecified";
    private PublishingService publishingService;
    private ChannelService channelService;
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void setPublishingService(PublishingService publishingService) {
        this.publishingService = publishingService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        PublishingDetails details;
        Channel publishChannel;
        Boolean isUnpublish = (Boolean)action.getParameterValue(PARAM_UNPUBLISH);
        boolean unpublish = isUnpublish != null && isUnpublish != false;
        String publishChannelId = (String)((Object)action.getParameterValue(PARAM_PUBLISH_CHANNEL_ID));
        String publishChannelName = (String)((Object)action.getParameterValue(PARAM_PUBLISH_CHANNEL_NAME));
        String statusUpdate = (String)((Object)action.getParameterValue(PARAM_STATUS_UPDATE));
        List<String> statusUpdateChannelNames = this.buildStringList(action.getParameterValue(PARAM_STATUS_UPDATE_CHANNEL_NAMES));
        List<String> statusUpdateChannelIds = this.buildStringList(action.getParameterValue(PARAM_STATUS_UPDATE_CHANNEL_IDS));
        Boolean includeLinkInStatusUpdate = (Boolean)action.getParameterValue(PARAM_INCLUDE_LINK_IN_STATUS_UPDATE);
        boolean appendLink = includeLinkInStatusUpdate == null || includeLinkInStatusUpdate != false;
        Date scheduledTime = (Date)action.getParameterValue(PARAM_SCHEDULED_TIME);
        String comment = (String)((Object)action.getParameterValue(PARAM_COMMENT));
        Channel channel = publishChannel = publishChannelId == null ? this.channelService.getChannelByName(publishChannelName) : this.channelService.getChannelById(publishChannelId);
        if (publishChannel != null) {
            Channel statusUpdateChannel;
            details = this.publishingService.createPublishingDetails();
            details.setPublishChannelId(publishChannel.getId());
            List<NodeRef> nodes = this.setNodes(actionedUponNodeRef, unpublish, details);
            if (statusUpdateChannelNames != null) {
                for (String statusUpdateChannelName : statusUpdateChannelNames) {
                    statusUpdateChannel = this.channelService.getChannelByName(statusUpdateChannelName);
                    if (statusUpdateChannel == null) continue;
                    details.addStatusUpdateChannels(statusUpdateChannel.getId());
                }
            }
            if (statusUpdateChannelIds != null) {
                for (String statusUpdateChannelId : statusUpdateChannelIds) {
                    statusUpdateChannel = this.channelService.getChannelById(statusUpdateChannelId);
                    if (statusUpdateChannel == null) continue;
                    details.addStatusUpdateChannels(statusUpdateChannel.getId());
                }
            }
            if (!unpublish && !details.getStatusUpdateChannels().isEmpty()) {
                details.setStatusMessage(statusUpdate);
                if (appendLink) {
                    NodeRef nodeToLinkTo = (NodeRef)action.getParameterValue(PARAM_NODE_TO_LINK_STATUS_UPDATE_TO);
                    if (nodeToLinkTo == null && nodes.size() == 1) {
                        nodeToLinkTo = nodes.get(0);
                    }
                    if (nodeToLinkTo != null && nodes.contains(nodeToLinkTo)) {
                        details.setStatusNodeToLinkTo(nodeToLinkTo);
                    }
                }
            }
            if (scheduledTime != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(scheduledTime);
                details.setSchedule(cal);
            }
        } else {
            throw new AlfrescoRuntimeException(MSG_CHANNEL_NOT_FOUND, new Object[]{publishChannelId == null ? publishChannelName : publishChannelId});
        }
        details.setComment(comment);
        this.publishingService.scheduleNewEvent(details);
    }

    private List<NodeRef> setNodes(NodeRef actionedUponNodeRef, boolean unpublish, PublishingDetails details) {
        ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
        QName nodeType = this.nodeService.getType(actionedUponNodeRef);
        if (this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_FOLDER)) {
            List children = this.nodeService.getChildAssocs(actionedUponNodeRef);
            for (ChildAssociationRef childRef : children) {
                NodeRef child = childRef.getChildRef();
                if (!this.dictionaryService.isSubClass(this.nodeService.getType(child), ContentModel.TYPE_CONTENT)) continue;
                nodes.add(child);
            }
        } else {
            nodes.add(actionedUponNodeRef);
        }
        if (unpublish) {
            details.addNodesToUnpublish(nodes);
        } else {
            details.addNodesToPublish(nodes);
        }
        return nodes;
    }

    private List<String> buildStringList(Serializable parameterValue) {
        List<Object> result = null;
        if (parameterValue != null && String.class.isAssignableFrom(parameterValue.getClass())) {
            String[] split = ((String)((Object)parameterValue)).split(",");
            result = Arrays.asList(split);
        } else if (parameterValue != null && Iterable.class.isAssignableFrom(parameterValue.getClass())) {
            result = new ArrayList();
            Iterable iter = (Iterable)((Object)parameterValue);
            for (Object obj : iter) {
                if (obj == null || !String.class.isAssignableFrom(obj.getClass())) continue;
                result.add((String)obj);
            }
        }
        return result;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_PUBLISH_CHANNEL_NAME, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_PUBLISH_CHANNEL_NAME), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_PUBLISH_CHANNEL_ID, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_PUBLISH_CHANNEL_ID), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_UNPUBLISH, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_UNPUBLISH), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_STATUS_UPDATE, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_STATUS_UPDATE), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_INCLUDE_LINK_IN_STATUS_UPDATE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_INCLUDE_LINK_IN_STATUS_UPDATE), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_STATUS_UPDATE_CHANNEL_NAMES, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_STATUS_UPDATE_CHANNEL_NAMES), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_STATUS_UPDATE_CHANNEL_IDS, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_STATUS_UPDATE_CHANNEL_IDS), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_SCHEDULED_TIME, DataTypeDefinition.DATETIME, false, this.getParamDisplayLabel(PARAM_SCHEDULED_TIME), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_NODE_TO_LINK_STATUS_UPDATE_TO, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_NODE_TO_LINK_STATUS_UPDATE_TO), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_COMMENT, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_COMMENT), false));
    }

    @Override
    protected void checkMandatoryProperties(ParameterizedItem ruleItem, ParameterizedItemDefinition ruleItemDefinition) {
        super.checkMandatoryProperties(ruleItem, ruleItemDefinition);
        String publishChannelName = (String)((Object)ruleItem.getParameterValue(PARAM_PUBLISH_CHANNEL_NAME));
        String publishChannelId = (String)((Object)ruleItem.getParameterValue(PARAM_PUBLISH_CHANNEL_ID));
        if (publishChannelId == null && publishChannelName == null) {
            throw new RuleServiceException(MSG_NEITHER_CHANNEL_NAME_NOR_ID_SPECIFIED);
        }
    }
}

