/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.facebook;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.facebook.FacebookPublishingHelper;
import org.alfresco.repo.publishing.facebook.FacebookPublishingModel;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.springframework.social.connect.Connection;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;

public class FacebookChannelType
extends AbstractChannelType {
    public static final String ID = "facebook";
    public static final String DEFAULT_REDIRECT_URI = "http://www.alfresco.com/stand-alone-auth-return.html";
    private FacebookPublishingHelper publishingHelper;
    private String redirectUri = "http://www.alfresco.com/stand-alone-auth-return.html";

    public void setPublishingHelper(FacebookPublishingHelper facebookPublishingHelper) {
        this.publishingHelper = facebookPublishingHelper;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Override
    public boolean canPublish() {
        return false;
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return true;
    }

    @Override
    public boolean canUnpublish() {
        return false;
    }

    @Override
    public QName getChannelNodeType() {
        return FacebookPublishingModel.TYPE_DELIVERY_CHANNEL;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void sendStatusUpdate(Channel channel, String status) {
        Connection<Facebook> connection = this.publishingHelper.getFacebookConnectionForChannel(channel.getNodeRef());
        connection.updateStatus(status);
    }

    @Override
    public String getNodeUrl(NodeRef node) {
        return null;
    }

    @Override
    public ChannelType.AuthUrlPair getAuthorisationUrls(Channel channel, String callbackUrl) {
        ParameterCheck.mandatory((String)"channel", (Object)channel);
        if (!ID.equals(channel.getChannelType().getId())) {
            throw new IllegalArgumentException("Invalid channel type: " + channel.getChannelType().getId());
        }
        NodeRef channelRef = channel.getNodeRef();
        StringBuilder authStateBuilder = new StringBuilder(channelRef.getStoreRef().getProtocol()).append('.').append(channelRef.getStoreRef().getIdentifier()).append('.').append(channelRef.getId());
        OAuth2Operations oauthOperations = this.publishingHelper.getConnectionFactory().getOAuthOperations();
        OAuth2Parameters params = new OAuth2Parameters();
        params.setRedirectUri(this.redirectUri);
        params.setScope("publish_stream,offline_access,user_photos,user_videos");
        params.setState(authStateBuilder.toString());
        String authRequestUrl = oauthOperations.buildAuthorizeUrl(GrantType.IMPLICIT_GRANT, params);
        return new ChannelType.AuthUrlPair(authRequestUrl, this.redirectUri);
    }

    @Override
    protected ChannelType.AuthStatus internalAcceptAuthorisation(Channel channel, Map<String, String[]> callbackHeaders, Map<String, String[]> callbackParams) {
        ChannelType.AuthStatus authorised = ChannelType.AuthStatus.UNAUTHORISED;
        String accessToken = null;
        if (callbackParams.containsKey("access_token")) {
            accessToken = callbackParams.get("access_token")[0];
        } else if (callbackParams.containsKey("code")) {
            OAuth2Operations oauthOps = this.publishingHelper.getConnectionFactory().getOAuthOperations();
            AccessGrant grant = oauthOps.exchangeForAccess(callbackParams.get("code")[0], this.redirectUri, null);
            accessToken = grant.getAccessToken();
        }
        if (accessToken != null) {
            Map<QName, Serializable> channelProps = new HashMap<QName, Serializable>();
            channelProps.put(PublishingModel.PROP_OAUTH2_TOKEN, (Serializable)((Object)accessToken));
            channelProps = this.getEncryptor().encrypt(channelProps);
            this.getChannelService().updateChannel(channel, channelProps);
            authorised = ChannelType.AuthStatus.AUTHORISED;
        }
        return authorised;
    }
}

