/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeRenderingEngine
extends AbstractRenderingEngine {
    private static Log logger = LogFactory.getLog(CompositeRenderingEngine.class);
    public static final String NAME = "compositeRenderingEngine";
    private ActionService actionService;

    @Override
    protected void executeRenditionImpl(Action action, NodeRef sourceNode) {
        this.checkSourceNodeExists(sourceNode);
        if (!(action instanceof CompositeRenditionDefinition)) {
            String msg = "This method requires that the RenditionDefinition be of type CompositeRenditionDefinition";
            logger.warn((Object)msg);
            throw new RenditionServiceException(msg);
        }
        CompositeRenditionDefinition compositeDefinition = (CompositeRenditionDefinition)action;
        ChildAssociationRef renditionAssoc = this.executeCompositeRendition(compositeDefinition, sourceNode);
        compositeDefinition.setParameterValue("result", (Serializable)renditionAssoc);
    }

    private ChildAssociationRef executeCompositeRendition(CompositeRenditionDefinition definition, NodeRef sourceNode) {
        NodeRef source = sourceNode;
        ChildAssociationRef result = null;
        QName assocType = definition.getRenditionAssociationType();
        NodeRef parent = definition.getRenditionParent();
        for (RenditionDefinition subDefinition : definition.getActions()) {
            ChildAssociationRef nextResult = this.executeSubDefinition(source, subDefinition, parent, assocType);
            if (result != null) {
                this.nodeService.removeChild(parent, result.getChildRef());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removeChild parentRef:" + parent + ", childRef;" + result.getChildRef()));
                }
            }
            result = nextResult;
            source = nextResult.getChildRef();
        }
        return result;
    }

    private ChildAssociationRef executeSubDefinition(NodeRef source, RenditionDefinition subDefinition, NodeRef parent, QName assocType) {
        subDefinition.setRenditionParent(parent);
        subDefinition.setRenditionAssociationType(assocType);
        subDefinition.setParameterValue("is-component-rendition", Boolean.valueOf(true));
        this.actionService.executeAction(subDefinition, source);
        ChildAssociationRef newResult = (ChildAssociationRef)subDefinition.getParameterValue("result");
        return newResult;
    }

    @Override
    protected void render(AbstractRenderingEngine.RenderingContext data) {
        throw new RenditionServiceException("This method should never be caleld!");
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }
}

