/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.util.Collection;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.rendition.executer.AbstractTransformationRenderingEngine;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class ImageRenderingEngine
extends AbstractTransformationRenderingEngine {
    public static final String NAME = "imageRenderingEngine";
    public static final String PARAM_RESIZE_WIDTH = "xsize";
    public static final String PARAM_RESIZE_HEIGHT = "ysize";
    public static final String PARAM_IS_PERCENT_RESIZE = "isAbsolute";
    public static final String PARAM_MAINTAIN_ASPECT_RATIO = "maintainAspectRatio";
    public static final String PARAM_RESIZE_TO_THUMBNAIL = "resizeToThumbnail";
    public static final String PARAM_ALLOW_ENLARGEMENT = "allowEnlargement";
    public static final String PARAM_COMMAND_OPTIONS = "commandOptions";
    public static final String PARAM_AUTO_ORIENTATION = "autoOrientation";

    @Override
    protected TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext context) {
        return this.getTransformOptionsImpl(new ImageTransformationOptions(), context);
    }

    @Override
    protected TransformationOptions getTransformOptionsImpl(TransformationOptions options, AbstractRenderingEngine.RenderingContext context) {
        options.setSourceNodeRef(context.getSourceNode());
        ImageTransformationOptions imageTransformationOptions = (ImageTransformationOptions)options;
        String commandOptions = context.getCheckedParam(PARAM_COMMAND_OPTIONS, String.class);
        ImageResizeOptions imageResizeOptions = this.getImageResizeOptions(context);
        boolean autoOrient = context.getParamWithDefault(PARAM_AUTO_ORIENTATION, true);
        imageTransformationOptions.setResizeOptions(imageResizeOptions);
        imageTransformationOptions.setAutoOrient(autoOrient);
        if (commandOptions != null) {
            imageTransformationOptions.setCommandOptions(commandOptions);
        }
        return super.getTransformOptionsImpl(options, context);
    }

    @Override
    protected String getTargetMimeType(AbstractRenderingEngine.RenderingContext context) {
        String sourceMimeType = context.makeContentReader().getMimetype();
        return context.getParamWithDefault("mime-type", sourceMimeType);
    }

    private ImageResizeOptions getImageResizeOptions(AbstractRenderingEngine.RenderingContext context) {
        int newHeight = context.getIntegerParam(PARAM_RESIZE_WIDTH, -1);
        int newWidth = context.getIntegerParam(PARAM_RESIZE_HEIGHT, -1);
        if (newHeight == -1 && newWidth == -1) {
            return null;
        }
        boolean isPercentResize = context.getParamWithDefault(PARAM_IS_PERCENT_RESIZE, false);
        boolean maintainAspectRatio = context.getParamWithDefault(PARAM_MAINTAIN_ASPECT_RATIO, false);
        boolean allowEnlargement = context.getParamWithDefault(PARAM_ALLOW_ENLARGEMENT, true);
        ImageResizeOptions imageResizeOptions = new ImageResizeOptions();
        imageResizeOptions.setMaintainAspectRatio(maintainAspectRatio);
        imageResizeOptions.setWidth(newHeight);
        imageResizeOptions.setHeight(newWidth);
        imageResizeOptions.setPercentResize(isPercentResize);
        imageResizeOptions.setAllowEnlargement(allowEnlargement);
        return imageResizeOptions;
    }

    @Override
    protected void checkParameterValues(Action action) {
        this.checkNumericalParameterIsPositive(action, PARAM_RESIZE_WIDTH);
        this.checkNumericalParameterIsPositive(action, PARAM_RESIZE_HEIGHT);
        this.checkNumericalParameterIsPositive(action, "crop_height");
        this.checkNumericalParameterIsPositive(action, "crop_width");
        String mimeTypeParam = (String)((Object)action.getParameterValue("mime-type"));
        if (mimeTypeParam != null && !mimeTypeParam.startsWith("image")) {
            StringBuilder msg = new StringBuilder();
            msg.append("Parameter ").append("mime-type").append(" had illegal non-image MIME type: ").append(mimeTypeParam);
            throw new IllegalArgumentException(msg.toString());
        }
    }

    private void checkNumericalParameterIsPositive(Action action, String numericalParamName) {
        Number param = (Number)action.getParameterValue(numericalParamName);
        if (param != null && param.longValue() <= 0L) {
            StringBuilder msg = new StringBuilder();
            msg.append("Parameter ").append(numericalParamName).append(" had illegal non-positive value: ").append(param.intValue());
            throw new IllegalArgumentException(msg.toString());
        }
    }

    private void checkTargetMimeType(AbstractRenderingEngine.RenderingContext context) {
        String targetMimeType = this.getTargetMimeType(context);
        if (targetMimeType == null || !targetMimeType.startsWith("image")) {
            StringBuilder msg = new StringBuilder();
            msg.append("Target has illegal non-image MIME type: ").append(targetMimeType).append(". ").append("Use image as a source or configure target parameter \"").append("mime-type").append("\"");
            throw new IllegalArgumentException(msg.toString());
        }
    }

    @Override
    protected void render(AbstractRenderingEngine.RenderingContext context) {
        this.checkTargetMimeType(context);
        super.render(context);
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl(PARAM_AUTO_ORIENTATION, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_AUTO_ORIENTATION)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_WIDTH, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_RESIZE_WIDTH)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_HEIGHT, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_RESIZE_HEIGHT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_IS_PERCENT_RESIZE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_IS_PERCENT_RESIZE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_MAINTAIN_ASPECT_RATIO, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_MAINTAIN_ASPECT_RATIO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_RESIZE_TO_THUMBNAIL, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_RESIZE_TO_THUMBNAIL)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ALLOW_ENLARGEMENT, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_ALLOW_ENLARGEMENT)));
        paramList.add(new ParameterDefinitionImpl("crop_gravity", DataTypeDefinition.TEXT, false, this.getParamDisplayLabel("crop_gravity")));
        paramList.add(new ParameterDefinitionImpl("crop_height", DataTypeDefinition.INT, false, this.getParamDisplayLabel("crop_height")));
        paramList.add(new ParameterDefinitionImpl("crop_width", DataTypeDefinition.INT, false, this.getParamDisplayLabel("crop_width")));
        paramList.add(new ParameterDefinitionImpl("crop_x", DataTypeDefinition.INT, false, this.getParamDisplayLabel("crop_x")));
        paramList.add(new ParameterDefinitionImpl("crop_y", DataTypeDefinition.INT, false, this.getParamDisplayLabel("crop_y")));
        paramList.add(new ParameterDefinitionImpl("percent_crop", DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel("percent_crop")));
        paramList.add(new ParameterDefinitionImpl(PARAM_COMMAND_OPTIONS, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_COMMAND_OPTIONS)));
        return paramList;
    }
}

