/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.XMLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLTFunctions {
    private static final Log log = LogFactory.getLog(XSLTFunctions.class);
    private FileFolderService fileService;
    private ContentService contentService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;

    public Document parseXMLDocument(NodeRef root, String repoPath) throws IOException, SAXException, FileNotFoundException {
        String[] pathElements = this.breakDownPath(repoPath);
        FileInfo file = this.fileService.resolveNamePath(root, Arrays.asList(pathElements));
        return XMLUtil.parse(file.getNodeRef(), this.contentService);
    }

    public Map<String, Document> parseXMLDocuments(String typeName, NodeRef rootNode, String repoPath) throws IOException, SAXException {
        TreeMap<String, Document> result = new TreeMap<String, Document>();
        String[] pathElements = this.breakDownPath(repoPath);
        try {
            FileInfo file = this.fileService.resolveNamePath(rootNode, Arrays.asList(pathElements));
            if (file.isFolder()) {
                QName typeQName = QName.createQName((String)typeName, (NamespacePrefixResolver)this.namespaceService);
                HashSet<QName> types = new HashSet<QName>(this.dictionaryService.getSubTypes(typeQName, true));
                types.add(typeQName);
                List children = this.nodeService.getChildAssocs(file.getNodeRef(), types);
                for (ChildAssociationRef child : children) {
                    String name = (String)((Object)this.nodeService.getProperty(child.getChildRef(), ContentModel.PROP_NAME));
                    Document doc = XMLUtil.parse(child.getChildRef(), this.contentService);
                    result.put(name, doc);
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Unexpected exception caught in call to parseXMLDocuments", (Throwable)ex);
        }
        return result;
    }

    private String[] breakDownPath(String repoPath) {
        if (repoPath.startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        String[] pathElements = repoPath.split("/");
        return pathElements;
    }

    public String encodeQuotes(String text) throws IOException, SAXException {
        if (text == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < text.length(); ++i) {
            String enc = null;
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '\u00e4': {
                    enc = "&auml;";
                    break;
                }
                case '\u00c4': {
                    enc = "&Auml;";
                    break;
                }
                case '\u00f6': {
                    enc = "&ouml;";
                    break;
                }
                case '\u00d6': {
                    enc = "&Ouml;";
                    break;
                }
                case '\u00fc': {
                    enc = "&uuml;";
                    break;
                }
                case '\u00dc': {
                    enc = "&Uuml;";
                    break;
                }
                case '\u00df': {
                    enc = "&szlig;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = text.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return text;
        }
        return sb.toString();
    }

    public void setFileService(FileFolderService fileService) {
        this.fileService = fileService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

