/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class OnMoveNodeRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnMoveNodePolicy {
    private static final String POLICY_NAME = NodeServicePolicies.OnMoveNodePolicy.QNAME.getLocalName();
    private boolean isClassBehaviour = false;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    @Override
    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        if (!oldChildAssocRef.getParentRef().equals((Object)newChildAssocRef.getParentRef())) {
            this.triggerChildrenRules(newChildAssocRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerChildrenRules(ChildAssociationRef newChildAssocRef) {
        NodeRef nodeRef = newChildAssocRef.getChildRef();
        boolean enabled = this.ruleService.rulesEnabled(nodeRef);
        try {
            if (enabled) {
                this.ruleService.disableRules(nodeRef);
            }
            this.triggerRules(newChildAssocRef.getParentRef(), nodeRef);
            for (ChildAssociationRef ref : this.nodeService.getChildAssocs(nodeRef)) {
                this.triggerChildrenRules(ref);
            }
        }
        finally {
            if (enabled) {
                this.ruleService.enableRules(nodeRef);
            }
        }
    }
}

