/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.QueryCollection;
import org.alfresco.repo.search.QueryCollectionImpl;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class QueryRegisterComponentImpl
implements QueryRegisterComponent {
    private DictionaryService dictionaryService;
    private NamespacePrefixResolver namespaceService;
    private List<String> initCollections = null;
    private Map<String, QueryCollection> collections = new HashMap<String, QueryCollection>();

    private synchronized void loadCollectionsOnDemand() {
        if (this.initCollections != null) {
            for (String location : this.initCollections) {
                this.loadQueryCollection(location);
            }
        }
        this.initCollections = null;
    }

    @Override
    public CannedQueryDef getQueryDefinition(QName qName) {
        this.loadCollectionsOnDemand();
        for (String key : this.collections.keySet()) {
            QueryCollection collection = this.collections.get(key);
            CannedQueryDef def = collection.getQueryDefinition(qName);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    @Override
    public String getCollectionNameforQueryDefinition(QName qName) {
        this.loadCollectionsOnDemand();
        for (String key : this.collections.keySet()) {
            QueryCollection collection = this.collections.get(key);
            if (!collection.containsQueryDefinition(qName)) continue;
            return key;
        }
        return null;
    }

    @Override
    public QueryParameterDefinition getParameterDefinition(QName qName) {
        this.loadCollectionsOnDemand();
        for (String key : this.collections.keySet()) {
            QueryCollection collection = this.collections.get(key);
            QueryParameterDefinition def = collection.getParameterDefinition(qName);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    @Override
    public String getCollectionNameforParameterDefinition(QName qName) {
        this.loadCollectionsOnDemand();
        for (String key : this.collections.keySet()) {
            QueryCollection collection = this.collections.get(key);
            if (!collection.containsParameterDefinition(qName)) continue;
            return key;
        }
        return null;
    }

    @Override
    public QueryCollection getQueryCollection(String location) {
        this.loadCollectionsOnDemand();
        return this.collections.get(location);
    }

    @Override
    public void loadQueryCollection(String location) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(location);
            SAXReader reader = new SAXReader();
            Document document = reader.read(is);
            is.close();
            QueryCollection collection = QueryCollectionImpl.createQueryCollection(document.getRootElement(), this.dictionaryService, this.namespaceService);
            this.collections.put(location, collection);
        }
        catch (DocumentException de) {
            throw new AlfrescoRuntimeException("Error reading XML", (Throwable)de);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IO Error reading XML", (Throwable)e);
        }
    }

    public void setCollections(List<String> collections) {
        this.initCollections = collections;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespacePrefixResolver namespaceService) {
        this.namespaceService = namespaceService;
    }
}

