/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSetRow;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SolrJSONResultSet
implements ResultSet {
    private NodeService nodeService;
    private ArrayList<Pair<Long, Float>> page;
    private ArrayList<NodeRef> refs;
    private ResultSetMetaData rsmd;
    private Long status;
    private Long queryTime;
    private Long numberFound;
    private Long start;
    private Float maxScore;
    private SimpleResultSetMetaData resultSetMetaData;
    private HashMap<String, List<Pair<String, Integer>>> fieldFacets = new HashMap(1);
    private NodeDAO nodeDao;

    public SolrJSONResultSet(JSONObject json, SearchParameters searchParameters, NodeService nodeService, NodeDAO nodeDao, LimitBy limitBy, int maxResults) {
        this.nodeService = nodeService;
        this.nodeDao = nodeDao;
        try {
            JSONObject facet_counts;
            int i;
            JSONObject responseHeader = json.getJSONObject("responseHeader");
            this.status = responseHeader.getLong("status");
            this.queryTime = responseHeader.getLong("QTime");
            JSONObject response = json.getJSONObject("response");
            this.numberFound = response.getLong("numFound");
            this.start = response.getLong("start");
            this.maxScore = Float.valueOf(response.getString("maxScore"));
            JSONArray docs = response.getJSONArray("docs");
            int numDocs = docs.length();
            ArrayList<Long> rawDbids = new ArrayList<Long>(numDocs);
            ArrayList<Float> rawScores = new ArrayList<Float>(numDocs);
            for (i = 0; i < numDocs; ++i) {
                JSONObject doc = docs.getJSONObject(i);
                JSONArray dbids = doc.getJSONArray("DBID");
                Long dbid = dbids.getLong(0);
                Float score = Float.valueOf(doc.getString("score"));
                rawDbids.add(dbid);
                rawScores.add(score);
            }
            if (searchParameters.isBulkFetchEnabled()) {
                nodeDao.cacheNodesById(rawDbids);
            }
            this.page = new ArrayList(numDocs);
            this.refs = new ArrayList(numDocs);
            for (i = 0; i < numDocs; ++i) {
                Long dbid = rawDbids.get(i);
                NodeRef nodeRef = nodeService.getNodeRef(dbid);
                if (nodeRef == null) continue;
                this.page.add((Pair<Long, Float>)new Pair((Object)dbid, rawScores.get(i)));
                this.refs.add(nodeRef);
            }
            if (json.has("facet_counts") && (facet_counts = json.getJSONObject("facet_counts")).has("facet_fields")) {
                JSONObject facet_fields = facet_counts.getJSONObject("facet_fields");
                Iterator it = facet_fields.keys();
                while (it.hasNext()) {
                    String fieldName = (String)it.next();
                    JSONArray facets = facet_fields.getJSONArray(fieldName);
                    int facetArraySize = facets.length();
                    ArrayList<Pair> facetValues = new ArrayList<Pair>(facetArraySize / 2);
                    for (int i2 = 0; i2 < facetArraySize; i2 += 2) {
                        String facetEntryName = facets.getString(i2);
                        Integer facetEntryCount = Integer.parseInt(facets.getString(i2 + 1));
                        Pair pair = new Pair((Object)facetEntryName, (Object)facetEntryCount);
                        facetValues.add(pair);
                    }
                    this.fieldFacets.put(fieldName, facetValues);
                }
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.resultSetMetaData = new SimpleResultSetMetaData(maxResults > 0 && this.numberFound < (long)maxResults ? LimitBy.UNLIMITED : limitBy, PermissionEvaluationMode.EAGER, searchParameters);
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void close() {
    }

    public boolean getBulkFetch() {
        return true;
    }

    public int getBulkFetchSize() {
        return Integer.MAX_VALUE;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(this.getNodeRef(n));
        if (primaryParentAssoc != null) {
            return primaryParentAssoc;
        }
        return null;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> refs = new ArrayList<ChildAssociationRef>(this.page.size());
        for (int i = 0; i < this.page.size(); ++i) {
            refs.add(this.getChildAssocRef(i));
        }
        return refs;
    }

    public NodeRef getNodeRef(int n) {
        return this.refs.get(n);
    }

    public List<NodeRef> getNodeRefs() {
        return Collections.unmodifiableList(this.refs);
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultSetRow getRow(int i) {
        return new SolrJSONResultSetRow(this, i);
    }

    public float getScore(int n) {
        return ((Float)this.page.get(n).getSecond()).floatValue();
    }

    public int getStart() {
        return this.start.intValue();
    }

    public boolean hasMore() {
        return this.numberFound > this.start + (long)this.page.size() + 1L;
    }

    public int length() {
        return this.page.size();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return bulkFetch;
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return bulkFetchSize;
    }

    public Iterator<ResultSetRow> iterator() {
        return new SolrJSONResultSetRowIterator(this);
    }

    public Long getQueryTime() {
        return this.queryTime;
    }

    public long getNumberFound() {
        return this.numberFound;
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        List<Pair<String, Integer>> answer = this.fieldFacets.get(field);
        if (answer != null) {
            return answer;
        }
        return Collections.emptyList();
    }
}

