/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.fts;

import java.util.List;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class FullTextSearchIndexerBootstrapBean
extends AbstractLifecycleBean {
    protected static final Log log = LogFactory.getLog(FullTextSearchIndexerBootstrapBean.class);
    private FullTextSearchIndexer fullTextSearchIndexer;
    private NodeService nodeService;

    protected void onBootstrap(ApplicationEvent event) {
        List storeRefs = this.nodeService.getStores();
        for (StoreRef storeRef : storeRefs) {
            if (storeRef.getProtocol().equals("avm")) continue;
            this.fullTextSearchIndexer.requiresIndex(storeRef);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public FullTextSearchIndexer getFullTextSearchIndexer() {
        return this.fullTextSearchIndexer;
    }

    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

