/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.index.CachingIndexReader;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCounting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.OpenBitSet;

public class ReferenceCountingReadOnlyIndexReaderFactory {
    private static Log s_logger = LogFactory.getLog(ReferenceCountingReadOnlyIndexReaderFactory.class);
    private static WeakHashMap<String, ReferenceCountingReadOnlyIndexReader> log = new WeakHashMap();

    public static IndexReader createReader(String id, IndexReader indexReader, boolean enableCaching, LuceneConfig config) {
        ReferenceCountingReadOnlyIndexReader rc = new ReferenceCountingReadOnlyIndexReader(id, indexReader, enableCaching, config);
        if (s_logger.isDebugEnabled()) {
            if (log.containsKey(id)) {
                s_logger.debug((Object)("Replacing ref counting reader for " + id));
            }
            s_logger.debug((Object)("Created ref counting reader for " + id + " " + rc.toString()));
            log.put(new String(id), rc);
        }
        return rc;
    }

    public static void destroy() {
        log.clear();
    }

    public static String getState(String id) {
        ReferenceCountingReadOnlyIndexReader rc;
        if (s_logger.isDebugEnabled() && (rc = log.get(id)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Id = " + rc.getId() + " Invalid = " + rc.getReferenceCount() + " invalid = " + rc.getInvalidForReuse() + " closed=" + rc.getClosed());
            return builder.toString();
        }
        return "<UNKNOWN>";
    }

    static class TermDocSet
    implements TermDocs {
        OpenBitSet set;
        int position = -1;

        TermDocSet(OpenBitSet set) {
            this.set = set;
        }

        public void close() throws IOException {
        }

        public int doc() {
            return this.position;
        }

        public int freq() {
            return 1;
        }

        public boolean next() throws IOException {
            ++this.position;
            this.position = this.set.nextSetBit(this.position);
            return this.position != -1;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(Term term) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(TermEnum termEnum) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean skipTo(int target) throws IOException {
            do {
                if (this.next()) continue;
                return false;
            } while (target > this.doc());
            return true;
        }
    }

    private static class SingleFieldSelector
    implements FieldSelector {
        String field;
        boolean last;

        SingleFieldSelector(String field, boolean last) {
            this.field = field;
            this.last = last;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (fieldName.equals(this.field)) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }

    static class WithUseCount<T>
    implements Comparable<WithUseCount<T>> {
        AtomicInteger count = new AtomicInteger(0);
        T object;
        int doc;

        WithUseCount(T object, int doc) {
            this.object = object;
            this.doc = doc;
        }

        @Override
        public int compareTo(WithUseCount<T> other) {
            return other.count.get() - this.count.get();
        }
    }

    public static class ReferenceCountingReadOnlyIndexReader
    extends FilterIndexReader
    implements ReferenceCounting,
    CachingIndexReader {
        private static Log s_logger = LogFactory.getLog(ReferenceCountingReadOnlyIndexReader.class);
        private static final long serialVersionUID = 7693185658022810428L;
        private static Field s_field;
        String id;
        int refCount = 0;
        boolean invalidForReuse = false;
        boolean allowsDeletions;
        boolean wrapper_closed = false;
        ConcurrentHashMap<Integer, Boolean> isCategory = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<List<org.apache.lucene.document.Field>>> documentCache = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<List<org.apache.lucene.document.Field>>> idCache = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<org.apache.lucene.document.Field>> pathCache = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<org.apache.lucene.document.Field>> typeCache = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<List<org.apache.lucene.document.Field>>> parentCache = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, WithUseCount<List<org.apache.lucene.document.Field>>> linkAspectCache = new ConcurrentHashMap();
        private boolean enableCaching;
        private LuceneConfig config;
        private final long creationTime;
        private final Deque<Throwable> references;
        private final ListFieldAccessor LIST_FIELD_ACCESSOR = new ListFieldAccessor();
        private final MultipleValueFieldAccessor MV_ID_FIELD_ACCESSOR = new MultipleValueFieldAccessor("ID");
        private final SingleValueFieldAccessor SV_TYPE_FIELD_ACCESSOR = new SingleValueFieldAccessor("TYPE");
        private final SingleValueFieldAccessor SV_PATH_FIELD_ACCESSOR = new SingleValueFieldAccessor("PATH");
        private final MultipleValueFieldAccessor MV_PARENT_FIELD_ACCESSOR = new MultipleValueFieldAccessor("PARENT");
        private final MultipleValueFieldAccessor MV_LINKASPECT_FIELD_ACCESSOR = new MultipleValueFieldAccessor("LINKASPECT");
        private OpenBitSet nodes = null;

        ReferenceCountingReadOnlyIndexReader(String id, IndexReader indexReader, boolean enableCaching, LuceneConfig config) {
            super(indexReader);
            this.creationTime = System.currentTimeMillis();
            this.references = new LinkedList<Throwable>();
            this.references.add(new Exception(this.refCount + ": " + indexReader.toString()));
            this.id = id;
            if (enableCaching && config != null) {
                this.enableCaching = config.isCacheEnabled();
            }
            this.config = config;
        }

        @Override
        public synchronized long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public synchronized Deque<Throwable> getReferences() {
            return this.references;
        }

        public synchronized void incRef() {
            if (this.wrapper_closed) {
                throw new IllegalStateException(Thread.currentThread().getName() + "Indexer is closed " + this.id);
            }
            if (this.refCount++ > 0) {
                super.incRef();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " - increment - ref count is " + this.refCount + "        ... " + super.toString()));
            }
            if (!this.wrapper_closed) {
                try {
                    s_field.set(this, false);
                }
                catch (IllegalArgumentException e) {
                    throw new AlfrescoRuntimeException("Failed to mark index as open ..", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new AlfrescoRuntimeException("Failed to mark index as open ..", (Throwable)e);
                }
            }
            this.references.add(new Exception(this.refCount + ": " + this.in.toString()));
        }

        private synchronized void decrementReferenceCount() throws IOException {
            --this.refCount;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " - decrement - ref count is " + this.refCount + "        ... " + super.toString()));
            }
            this.closeIfRequired();
            if (this.refCount < 0) {
                s_logger.error((Object)("Invalid reference count for Reader " + this.id + " is " + this.refCount + "        ... " + super.toString()));
            }
        }

        private void closeIfRequired() throws IOException {
            if (this.refCount == 0 && this.invalidForReuse && !this.wrapper_closed) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " closed." + "        ... " + super.toString()));
                }
                if (this.enableCaching) {
                    // empty if block
                }
                super.decRef();
                this.wrapper_closed = true;
                if (!this.references.isEmpty()) {
                    this.references.removeLast();
                }
            } else if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " still open .... ref = " + this.refCount + " invalidForReuse = " + this.invalidForReuse + "        ... " + super.toString()));
            }
        }

        @Override
        public synchronized int getReferenceCount() {
            return this.refCount;
        }

        public synchronized boolean getInvalidForReuse() {
            return this.invalidForReuse;
        }

        public synchronized boolean getClosed() {
            return this.wrapper_closed;
        }

        @Override
        public synchronized void setInvalidForReuse() throws IOException {
            if (this.wrapper_closed) {
                throw new IllegalStateException(Thread.currentThread().getName() + "Indexer is closed " + this.id);
            }
            this.invalidForReuse = true;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " set invalid for reuse" + "        ... " + super.toString()));
            }
            this.closeIfRequired();
        }

        public synchronized void decRef() throws IOException {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " closing" + "        ... " + super.toString()));
            }
            if (this.wrapper_closed) {
                throw new IllegalStateException(Thread.currentThread().getName() + "Indexer is closed " + this.id);
            }
            this.decrementReferenceCount();
            if (this.refCount > 0) {
                super.decRef();
                if (!this.references.isEmpty()) {
                    this.references.removeLast();
                }
            }
        }

        protected void doClose() throws IOException {
            this.in.decRef();
        }

        protected void doDelete(int n) throws IOException {
            throw new UnsupportedOperationException("Delete is not supported by read only index readers");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T manageCache(ConcurrentHashMap<Integer, WithUseCount<T>> cache, Accessor<T> accessor, int n, FieldSelector fieldSelector, int limit) throws IOException {
            Integer key = n;
            WithUseCount<T> value = cache.get(key);
            if (value == null) {
                T made = accessor.get(n, fieldSelector);
                value = new WithUseCount<T>(made, n);
                cache.put(key, value);
                if (limit >= 0 && cache.size() >= limit) {
                    HashMap<Integer, Object> keep = new HashMap<Integer, Object>();
                    Object[] existing = new WithUseCount[]{};
                    ConcurrentHashMap<Integer, WithUseCount<T>> concurrentHashMap = cache;
                    synchronized (concurrentHashMap) {
                        existing = cache.values().toArray(existing);
                        cache.clear();
                    }
                    Arrays.sort(existing);
                    for (Object current : existing) {
                        keep.put(((WithUseCount)current).doc, current);
                        if (((WithUseCount)current).count.get() == 0 || keep.size() > limit / 4) break;
                    }
                    keep.put(key, value);
                    cache.putAll(keep);
                }
            } else {
                value.count.getAndIncrement();
            }
            return value.object;
        }

        public Document document(int n, FieldSelector fieldSelector) throws IOException {
            if (fieldSelector == null && this.enableCaching) {
                List<org.apache.lucene.document.Field> listOfFields = this.manageCache(this.documentCache, this.LIST_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxDocumentCacheSize());
                Document document = new Document();
                document.getFields().addAll(listOfFields);
                return document;
            }
            if (this.enableCaching && fieldSelector instanceof SingleFieldSelector) {
                SingleFieldSelector sfs = (SingleFieldSelector)fieldSelector;
                if (sfs.field.equals("ID") && !sfs.last) {
                    List<org.apache.lucene.document.Field> idFields = this.manageCache(this.idCache, this.MV_ID_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxDocIdCacheSize());
                    Document d = new Document();
                    d.getFields().addAll(idFields);
                    return d;
                }
                if (sfs.field.equals("ISCATEGORY") && sfs.last) {
                    Integer key = n;
                    Boolean isCat = this.isCategory.get(key);
                    if (isCat == null) {
                        isCat = this.getStringValue(n, "ISCATEGORY") != null;
                        this.isCategory.put(key, isCat);
                    }
                    Document d = new Document();
                    if (isCat.booleanValue()) {
                        d.add((Fieldable)new org.apache.lucene.document.Field("ISCATEGORY", "T", Field.Store.NO, Field.Index.UN_TOKENIZED));
                    }
                    return d;
                }
                if (sfs.field.equals("PATH") && sfs.last) {
                    org.apache.lucene.document.Field pathField = this.manageCache(this.pathCache, this.SV_PATH_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxPathCacheSize());
                    Document d = new Document();
                    d.add((Fieldable)pathField);
                    return d;
                }
                if (sfs.field.equals("TYPE") && sfs.last) {
                    org.apache.lucene.document.Field typeField = this.manageCache(this.typeCache, this.SV_TYPE_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxTypeCacheSize());
                    Document d = new Document();
                    d.add((Fieldable)typeField);
                    return d;
                }
                if (sfs.field.equals("PARENT") && !sfs.last) {
                    List<org.apache.lucene.document.Field> listOfFields = this.manageCache(this.parentCache, this.MV_PARENT_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxParentCacheSize());
                    Document document = new Document();
                    document.getFields().addAll(listOfFields);
                    return document;
                }
                if (sfs.field.equals("LINKASPECT") && !sfs.last) {
                    List<org.apache.lucene.document.Field> listOfFields = this.manageCache(this.linkAspectCache, this.MV_LINKASPECT_FIELD_ACCESSOR, n, fieldSelector, this.config.getMaxLinkAspectCacheSize());
                    Document document = new Document();
                    document.getFields().addAll(listOfFields);
                    return document;
                }
            }
            return super.document(n, fieldSelector);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isInvalidForReuse() {
            return this.invalidForReuse;
        }

        public String getId(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("ID", true));
            return d.getField("ID").stringValue();
        }

        public String getPathLinkId(int n) throws IOException {
            Document document = this.document(n, new SingleFieldSelector("ID", true));
            org.apache.lucene.document.Field[] fields = document.getFields("ID");
            org.apache.lucene.document.Field field = fields[fields.length - 1];
            return field == null ? null : field.stringValue();
        }

        public String[] getIds(int n) throws IOException {
            return this.getStringValues(n, "ID");
        }

        public String[] getLinkAspects(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("LINKASPECT", false));
            return d.getValues("LINKASPECT");
        }

        public String[] getParents(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("PARENT", false));
            return d.getValues("PARENT");
        }

        public String getPath(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("PATH", true));
            org.apache.lucene.document.Field f = d.getField("PATH");
            return f == null ? null : f.stringValue();
        }

        public String getType(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("TYPE", true));
            org.apache.lucene.document.Field f = d.getField("TYPE");
            return f == null ? null : f.stringValue();
        }

        public String getIsCategory(int n) throws IOException {
            Document d = this.document(n, new SingleFieldSelector("ISCATEGORY", true));
            org.apache.lucene.document.Field f = d.getField("ISCATEGORY");
            return f == null ? null : f.stringValue();
        }

        private String getStringValue(int n, String fieldName) throws IOException {
            Document document = this.document(n);
            org.apache.lucene.document.Field field = document.getField(fieldName);
            return field == null ? null : field.stringValue();
        }

        private String[] getStringValues(int n, String fieldName) throws IOException {
            Document document = this.document(n);
            ArrayList fields = new ArrayList();
            ArrayList<String> answer = new ArrayList<String>(2);
            fields.addAll(document.getFields());
            for (org.apache.lucene.document.Field field : fields) {
                if (!field.name().equals(fieldName)) continue;
                answer.add(field.stringValue());
            }
            return answer.toArray(new String[answer.size()]);
        }

        public synchronized TermDocs getNodeDocs() throws IOException {
            if (this.nodes == null) {
                TermDocs nodeDocs = this.termDocs(new Term("ISNODE", "T"));
                this.nodes = new OpenBitSet();
                while (nodeDocs.next()) {
                    this.nodes.set((long)nodeDocs.doc());
                }
                nodeDocs.close();
            }
            return new TermDocSet(this.nodes);
        }

        static {
            Class<IndexReader> c = IndexReader.class;
            try {
                s_field = c.getDeclaredField("closed");
                s_field.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new AlfrescoRuntimeException("Reference counting index reader needs access to org.apache.lucene.index.IndexReader.closed to work correctly", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new AlfrescoRuntimeException("Reference counting index reader needs access to org.apache.lucene.index.IndexReader.closed to work correctly (incompatible version of lucene)", (Throwable)e);
            }
        }

        private class SingleValueFieldAccessor
        implements Accessor<org.apache.lucene.document.Field> {
            String fieldName;

            SingleValueFieldAccessor(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            public org.apache.lucene.document.Field get(int n, FieldSelector fieldSelector) throws IOException {
                return new org.apache.lucene.document.Field(this.fieldName, ReferenceCountingReadOnlyIndexReader.this.getStringValue(n, this.fieldName), Field.Store.NO, Field.Index.UN_TOKENIZED);
            }
        }

        private class MultipleValueFieldAccessor
        implements Accessor<List<org.apache.lucene.document.Field>> {
            String fieldName;

            MultipleValueFieldAccessor(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            public List<org.apache.lucene.document.Field> get(int n, FieldSelector fieldSelector) throws IOException {
                Document document = ReferenceCountingReadOnlyIndexReader.super.document(n, fieldSelector);
                org.apache.lucene.document.Field[] fields = document.getFields(this.fieldName);
                ArrayList<org.apache.lucene.document.Field> cacheable = new ArrayList<org.apache.lucene.document.Field>(fields.length);
                for (org.apache.lucene.document.Field field : fields) {
                    cacheable.add(field);
                }
                return cacheable;
            }
        }

        private class ListFieldAccessor
        implements Accessor<List<org.apache.lucene.document.Field>> {
            private ListFieldAccessor() {
            }

            @Override
            public List<org.apache.lucene.document.Field> get(int n, FieldSelector fieldSelector) throws IOException {
                Document document = ReferenceCountingReadOnlyIndexReader.super.document(n, fieldSelector);
                List fields = document.getFields();
                ArrayList<org.apache.lucene.document.Field> cacheable = new ArrayList<org.apache.lucene.document.Field>(fields.size());
                cacheable.addAll(fields);
                return cacheable;
            }
        }

        private static interface Accessor<T> {
            public T get(int var1, FieldSelector var2) throws IOException;
        }
    }
}

